/* The two `main' functions are shamelessly ripped off from
 * guile-1.2/libguile/guile.c.
 *
 * Hopefully this will evolve into a nice shell.
 */


#include <libguile.h>
#include "../guile-gtk/guile-gtk.h"

#include "gnome.h"


/* Debugger interface (don't change the order of the following lines) */
#define GDB_TYPE SCM
#include <libguile/gdb_interface.h>
GDB_INTERFACE;


extern void gnome_guile_session_init (void);

/***** Export Gnome functions to Scheme *****/

/* FIXME!!!  All this stuff should be generated automatically.
 * XXX: Remember to export all useful GNOME functions to the Scheme part.
 */

static SCM
guile_gnome_libdir_file(SCM scm_filename)
{
	char *filename;
	char *libdir_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG1, "gnome-libdir-file");

	filename    = SCM_CHARS(scm_filename);
	libdir_file = gnome_libdir_file(filename);

	ret = scm_makfrom0str(libdir_file);
	g_free(libdir_file);

	return ret;
}


static SCM
guile_gnome_datadir_file(SCM scm_filename)
{
	char *filename;
	char *datadir_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG1, "gnome-datadir-file");
	
	filename    = SCM_CHARS(scm_filename);
	datadir_file = gnome_datadir_file(filename);

	ret = scm_makfrom0str(datadir_file);
	g_free(datadir_file);

	return ret;
}
	

static SCM
guile_gnome_pixmap_file(SCM scm_filename)
{
	char *filename;
	char *pixmap_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG1, "gnome-pixmap-file");
	
	filename    = SCM_CHARS(scm_filename);
	pixmap_file = gnome_pixmap_file(filename);

	ret = scm_makfrom0str(pixmap_file);
	g_free(pixmap_file);

	return ret;
}
	

static SCM
guile_gnome_unconditional_libdir_file(SCM scm_filename)
{
	char *filename;
	char *libdir_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG1,
		   "gnome-unconditional-libdir-file");

	filename    = SCM_CHARS(scm_filename);
	libdir_file = gnome_unconditional_libdir_file(filename);

	ret = scm_makfrom0str(libdir_file);
	g_free(libdir_file);

	return ret;
}


static SCM
guile_gnome_unconditional_datadir_file(SCM scm_filename)
{
	char *filename;
	char *datadir_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG1,
		   "gnome-unconditional-datadir-file");
	
	filename    = SCM_CHARS(scm_filename);
	datadir_file = gnome_unconditional_datadir_file(filename);

	ret = scm_makfrom0str(datadir_file);
	g_free(datadir_file);

	return ret;
}
	

static SCM
guile_gnome_unconditional_pixmap_file(SCM scm_filename)
{
	char *filename;
	char *pixmap_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG1,
		   "gnome-unconditional-pixmap-file");
	
	filename    = SCM_CHARS(scm_filename);
	pixmap_file = gnome_unconditional_pixmap_file(filename);

	ret = scm_makfrom0str(pixmap_file);
	g_free(pixmap_file);

	return ret;
}


static SCM
guile_gnome_config_get_string(SCM path)
{
	char *thepath;
	char *value;
	SCM   ret;
	
	SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path, SCM_ARG1, "gnome-config-get-string");

	thepath = SCM_CHARS(path);
	value = gnome_config_get_string(thepath);

	ret = scm_makfrom0str(value);
	g_free(value);

	return ret;
}


static SCM
guile_gnome_config_get_int(SCM path)
{
	char *thepath;
	long  value;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path, SCM_ARG1, "gnome-config-get-int");

	thepath = SCM_CHARS(path);
	value = gnome_config_get_int(thepath);

	ret = scm_long2num(value);
	return ret;
}


static SCM
guile_gnome_config_get_bool(SCM path)
{
	char *thepath;
	long  value;

	SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path, SCM_ARG1, "gnome-config-get-int");

	thepath = SCM_CHARS(path);
	value = gnome_config_get_bool(thepath);

	return value ? SCM_BOOL_T : SCM_BOOL_F;
}

static SCM
guile_gnome_config_set_string(SCM path, SCM value)
{
	char *thepath;
	char *thevalue;

	SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path, SCM_ARG1, "gnome-config-set-string");
	SCM_ASSERT(SCM_NIMP(value) && SCM_STRINGP(value), path, SCM_ARG2, "gnome-config-set-string");

	thepath = SCM_CHARS(path);
	thevalue = SCM_CHARS(value);

	gnome_config_set_string(thepath, thevalue);

	return SCM_UNSPECIFIED;
}


static SCM
guile_gnome_config_set_int(SCM path, SCM value)
{
	char *thepath;
	int   thevalue;

	SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path, SCM_ARG1, "gnome-config-set-int");
	SCM_ASSERT(SCM_INUMP(value), path, SCM_ARG2, "gnome-config-set-int");

	thepath = SCM_CHARS(path);
	thevalue = SCM_INUM(value);

	gnome_config_set_int(thepath, thevalue);

	return SCM_UNSPECIFIED;
}


static SCM
guile_gnome_config_set_bool(SCM path, SCM value)
{
	char *thepath;
	int   thevalue;

	SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path, SCM_ARG1, "gnome-config-set-int");

	thepath = SCM_CHARS(path);
	thevalue = (value == SCM_BOOL_F) ? 0 : 1;

	gnome_config_set_bool(thepath, thevalue);

	return SCM_UNSPECIFIED;
}


static SCM
guile_gnome_config_has_section(SCM path)
{
	char *thepath;
	int   has;
	
	SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path, SCM_ARG1, "gnome-config-has-section");

	thepath = SCM_CHARS(path);
	has = gnome_config_has_section(thepath);

	return has ? SCM_BOOL_T : SCM_BOOL_F;
}


static SCM
guile_gnome_config_drop_all(void)
{
	gnome_config_drop_all();

	return SCM_UNSPECIFIED;
}


static SCM
guile_gnome_config_sync(void)
{
	gnome_config_sync();

	return SCM_UNSPECIFIED;
}


static SCM
guile_gnome_config_clean_file(SCM path)
{
	char *thepath;

	SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path, SCM_ARG1, "gnome-config-clean-file");

	thepath = SCM_CHARS(path);
	gnome_config_clean_file(thepath);

	return SCM_UNSPECIFIED;
}


static SCM
guile_gnome_config_clean_section(SCM path)
{
	char *thepath;

	SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path, SCM_ARG1, "gnome-config-clean-section");

	thepath = SCM_CHARS(path);
	gnome_config_clean_section(thepath);

	return SCM_UNSPECIFIED;
}


static SCM
guile_gnome_config_clean_key(SCM path)
{
	char *thepath;

	SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path, SCM_ARG1, "gnome-config-clean-key");

	thepath = SCM_CHARS(path);
	gnome_config_clean_file(thepath);

	return SCM_UNSPECIFIED;
}


static SCM
guile_gnome_config_set_prefix(SCM path)
{
	char *thepath;

	SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path, SCM_ARG1, "gnome-config-set-prefix");

	thepath = SCM_CHARS(path);
	gnome_config_set_prefix(thepath);

	return SCM_UNSPECIFIED;
}


static SCM
guile_gnome_config_drop_prefix(void)
{
	gnome_config_drop_prefix();

	return SCM_UNSPECIFIED;
}


static void
init_guile_gnome_defs(void)
{
	/* utilities */

	scm_make_gsubr("gnome-libdir-file", 1, 0, 0, guile_gnome_libdir_file);
	scm_make_gsubr("gnome-datadir-file", 1, 0, 0, guile_gnome_datadir_file);
	scm_make_gsubr("gnome-pixmap-file", 1, 0, 0, guile_gnome_pixmap_file);
	scm_make_gsubr("gnome-unconditional-libdir-file", 1, 0, 0, guile_gnome_unconditional_libdir_file);
	scm_make_gsubr("gnome-unconditional-datadir-file", 1, 0, 0, guile_gnome_unconditional_datadir_file);
	scm_make_gsubr("gnome-unconditional-pixmap-file", 1, 0, 0, guile_gnome_unconditional_pixmap_file);

	/* Configuration */
	
	scm_make_gsubr("gnome-config-get-string", 1, 0, 0, guile_gnome_config_get_string);
	scm_make_gsubr("gnome-config-get-int", 1, 0, 0, guile_gnome_config_get_int);
	scm_make_gsubr("gnome-config-get-bool", 1, 0, 0, guile_gnome_config_get_bool);
	scm_make_gsubr("gnome-config-set-string", 2, 0, 0, guile_gnome_config_set_string);
	scm_make_gsubr("gnome-config-set-int", 2, 0, 0, guile_gnome_config_set_int);
	scm_make_gsubr("gnome-config-set-bool", 2, 0, 0, guile_gnome_config_set_bool);
	scm_make_gsubr("gnome-config-has-section", 1, 0, 0, guile_gnome_config_has_section);
	/* FIXME: gnome-config-init-iterator and gnome-config-iterator-next are missing */
	scm_make_gsubr("gnome-config-drop-all", 0, 0, 0, guile_gnome_config_drop_all);
	scm_make_gsubr("gnome-config-sync", 0, 0, 0, guile_gnome_config_sync);
	scm_make_gsubr("gnome-config-clean-file", 1, 0, 0, guile_gnome_config_clean_file);
	scm_make_gsubr("gnome-config-clean-section", 1, 0, 0, guile_gnome_config_clean_section);
	scm_make_gsubr("gnome-config-clean-key", 1, 0, 0, guile_gnome_config_clean_key);
	scm_make_gsubr("gnome-config-set-prefix", 1, 0, 0, guile_gnome_config_set_prefix);
	scm_make_gsubr("gnome-config-drop-prefix", 0, 0, 0, guile_gnome_config_drop_prefix);
}

static void
locate_error (char *s)
{
	fprintf (stderr,
		 "I could not locate the %s file\n"
		 "please check that you have either installed the software,\n"
		 "Or you have set the GNOMEDIR variable to point to an appropiate\n"
		 "location\n", s);
	exit (1);
}

static void
inner_main (void *closure, int argc, char **argv)
{
	char *shared_guile_scm = gnome_datadir_file ("gnome/gnome.scm");
	char *cmd;
	char **argv_copy;
	int  i;

	/* We load the glue... */

	if (!shared_guile_scm){
		locate_error ("gnome.scm");
		exit (1);
	}

	/* ... initialize Guile-Gtk... */

	sgtk_init (&argc, &argv);

	/* ... then we initialize Gnome... */

	gnome_init(&argc, &argv);

	/* ... load the Scheme part of Gnome for apps to use... */

	init_guile_gnome_defs();
	gnome_guile_session_init ();
	scm_primitive_load_path (scm_makfrom0str ("ice-9/boot-9.scm"));
	{
		extern int scm_ice_9_already_loaded;
		
		scm_ice_9_already_loaded = 1;
	}
	scm_primitive_load (scm_makfrom0str (shared_guile_scm));

#if 0
	argv_copy = (char **) malloc (sizeof (char *) * (argc+3));
	for (i = 1; i < argc; i++)
		argv_copy [i+2] = argv [i];
	argv_copy [0] = argv [0];
	argv_copy [1] = "-l";
	argv_copy [2] = shared_guile_scm;
	argc += 2;
#endif
	scm_shell (argc, argv);

	g_free (shared_guile_scm);
}

int
main (int argc, char **argv)
{
	scm_boot_guile (argc, argv, inner_main, 0);
	return 0; /* never reached */
}
