#include "obgtk.h"

@implementation Gtk_Table
- castGtkTable:(GtkTable *) castitem
{
  gtktable = castitem;
  return [super castGtkContainer:GTK_CONTAINER(castitem)];
}

- init
{
  return [self initWithTableInfo:5 cntCols:2 isHomo:1];
}

- initWithTableInfo:(gint) rows
	    cntCols:(gint) columns
	     isHomo:(gint) homogeneous
{
  gtktable = GTK_TABLE(gtk_table_new(rows, columns, homogeneous));
  return [super castGtkContainer:GTK_CONTAINER(gtktable)];
}

- attach     :(Gtk_Widget *) child
   attachLeft:(gint) left_attach
  attachRight:(gint) right_attach
    attachTop:(gint) top_attach
 attachBottom:(gint) bottom_attach
     optionsX:(gint) xoptions
     optionsY:(gint) yoptions
     paddingX:(gint) xpadding
     paddingY:(gint) ypadding
{
  gtk_table_attach(gtktable, child->gtkwidget,
		   left_attach, right_attach,
		   top_attach, bottom_attach,
		   xoptions, yoptions,
		   xpadding, ypadding);
  return self;
}

- attach_defaults:(Gtk_Widget *) child
       attachLeft:(gint) left_attach
      attachRight:(gint) right_attach
	attachTop:(gint) top_attach
     attachBottom:(gint) bottom_attach
{
  gtk_table_attach_defaults(gtktable, child->gtkwidget,
			    left_attach, right_attach,
			    top_attach, bottom_attach);
  return self;
}

- set_row_spacing:(gint) row
	  Spacing:(gint) spacing
{
  gtk_table_set_row_spacing(gtktable, row, spacing);
  return self;
}

- set_col_spacing:(gint) row
	  Spacing:(gint) spacing
{
  gtk_table_set_col_spacing(gtktable, row, spacing);
  return self;
}

- set_row_spacings:(gint) spacing
{
  gtk_table_set_row_spacings(gtktable, spacing);
  return self;
}

- set_col_spacings:(gint) spacing
{
  gtk_table_set_col_spacings(gtktable, spacing);
  return self;
}
@end
