#!@GNOMEG@ -s
-*- scheme -*-
!#

;; FIXME: set up the textdomain here.
;; (bindtextdomain ...)
;; (textdomain "network-utilities")

(define (create-itools-panel useful-options-widget
			     extended-options-widget
			     build-command-func)

  (define timer '())
  (define pipe '())

  (define (run-process command text-widget stop-button)
    (define (timeout)
      (let try-another-char ()
	(cond ((char-ready? pipe)
	       (let ((the-char (read-char pipe)))
		 (if (eof-object? the-char)
		     (gtk-button-clicked stop-button)
		     (begin
		       ; (display the-char)
		       (gtk-text-insert text-widget #f #f #f
					(string the-char) 1)
		       (if (eq? the-char #\newline)
			     (gtk-text-thaw text-widget))
		       
		       (if (not (eof-object? pipe))
			   (if (char-ready? pipe)
			       (try-another-char))))))))))
    (set! pipe (open-input-pipe command))
    (set! timer (gtk-timeout-add 100 timeout)))
  
  (let* ((host    (gtk-label-new (gettext "Host:")))
	 (entry   (gtk-entry-new))
	 (go      (gtk-button-new-with-label (gettext "Go!")))
	 (stop    (gtk-button-new-with-label (gettext "Stop")))
	 (frame   (gtk-frame-new (gettext "Options")))
	 (details (gtk-button-new-with-label (gettext "Details...")))
	 (options (gnome-make-filled-vbox
		   #f 0
		   (gnome-boxed-widget (gnome-make-filled-hbox
					#f 0
					(gnome-boxed-widget
					 useful-options-widget)
					'pack-end
					(gnome-boxed-widget details)))
		   (gnome-boxed-widget #f #f 4 extended-options-widget)))
	 (hadj    (gtk-adjustment-new 0.0 0.0 0.0 0.0 0.0 0.0))
	 (vadj    (gtk-adjustment-new 0.0 0.0 0.0 0.0 0.0 0.0))
	 (table   (gtk-table-new 2 2 #f))
	 (hsbar   (gtk-hscrollbar-new hadj))
	 (vsbar   (gtk-vscrollbar-new vadj))
	 (text    (gtk-text-new hadj vadj))
	 (panel   (gnome-make-filled-vbox
		   #f 4
		   
		   ; Hostname and go/stop buttons
		   
		   (gnome-boxed-widget (gnome-make-filled-hbox
					#f 10
					(gnome-boxed-widget host)
					(gnome-boxed-widget entry)
					'pack-end
					(gnome-boxed-widget stop)
					(gnome-boxed-widget go)))
		   
		   ; Useful options and details button
		   
		   (gnome-boxed-widget #f #f 4 frame)
		   
		   ; Output text widget

		   'pack-end
		   (gnome-boxed-widget #t #t 0 table))))

    (gtk-table-attach table text 0 1 0 1 '(expand fill) '(expand fill) 0 0)
    (gtk-table-attach table hsbar 0 1 1 2 '(expand fill) '() 0 0)
    (gtk-table-attach table vsbar 1 2 0 1 '() '(expand fill) 0 0)
    (gtk-widget-show-multi text hsbar vsbar)

    ; HACK HACK HACK: GtkText should be fixed (recompute_geometry(),
    ; gtk_text_realize(), gtk_text_size_allocate())

    (gtk-text-freeze text)
    (gtk-signal-connect text "map" (lambda () (gtk-text-thaw text)))
    (gtk-signal-connect text "unmap" (lambda () (gtk-text-freeze text)))
    
    (gtk-container-add frame options)
    (gtk-container-border-width panel 6)
    (gtk-container-border-width options 4)
    (gtk-widget-set-usize go 60 0)
    (gtk-widget-set-usize stop 60 0)
    (gtk-widget-set-usize details 60 0)

    (gtk-text-set-editable text #f)
    (gtk-widget-set-sensitive text #f)
    (gtk-widget-set-sensitive stop #f)
    (gtk-widget-set-sensitive go #f)

    (gtk-signal-connect entry "changed"
			(lambda ()
			  (let ((host (gtk-entry-get-text entry)))
			    (if (string=? host "")
				(gtk-widget-set-sensitive go #f)
				(gtk-widget-set-sensitive go #t)))))
			    
    (gtk-signal-connect go "clicked"
			(lambda ()
			  (let ((s-host (gtk-entry-get-text entry)))
			    (gtk-widget-set-sensitive host #f)
			    (gtk-widget-set-sensitive entry #f)
			    (gtk-widget-set-sensitive go #f)
			    (gtk-widget-set-sensitive stop #t)
			    (gtk-widget-set-sensitive useful-options-widget #f)
			    (gtk-widget-set-sensitive extended-options-widget #f)
			    (run-process (build-command-func s-host) text stop))))
    
    (gtk-signal-connect stop "clicked"
			(lambda ()
			  (gtk-widget-set-sensitive host #t)
			  (gtk-widget-set-sensitive entry #t)
			  (gtk-widget-set-sensitive go #t)
			  (gtk-widget-set-sensitive stop #f)
			  (gtk-widget-set-sensitive useful-options-widget #t)
			  (gtk-widget-set-sensitive extended-options-widget #t)
			  (gtk-timeout-remove timer)
			  (set! timer '())
			  (close-input-port pipe)))

    (gtk-widget-hide extended-options-widget)
    (let ((detailed #f))
      (gtk-signal-connect details "clicked"
			  (lambda ()
			    (gtk-container-disable-resize panel)
			    (if detailed
				(gtk-widget-hide extended-options-widget)
				(gtk-widget-show extended-options-widget))
			    (gtk-container-enable-resize panel)
			    (set! detailed (not detailed)))))

    panel))

(define (create-ping-panel)
   (let ((hostname-widget (gtk-check-button-new-with-label (gettext "Host name resolution")))
	 (table           (gtk-table-new 2 2 #f))
	 (l-packetsize    (gtk-label-new (gettext "Packet size:")))
         (e-packetsize    (gtk-entry-new))
	 (l-packetcount   (gtk-label-new (gettext "Number of probes sent:")))
	 (e-packetcount   (gtk-entry-new))

	 ; Parameters 
	 (hostname-on     #t)
	 (packetsize      0)
	 (packetcount     0))

     ;
     ; Hostname lookups
     ;
     (gtk-toggle-button-set-state hostname-widget hostname-on)
     (gtk-signal-connect hostname-widget "toggled"
			 (lambda () (set! hostname-on (not hostname-on))))

     ;
     ; Packet size
     ;
     (gtk-entry-set-text e-packetsize (if (= packetsize 0) "default" (number->string packetsize)))
     (gtk-table-attach-defaults table l-packetsize 0 1 0 1)
     (gtk-table-attach-defaults table e-packetsize 1 2 0 1)
     (gtk-misc-set-alignment l-packetsize 1.0 0.5)
     
     (gtk-entry-set-text e-packetcount (if (= packetcount 0) "unlimited" (number->string packetcount)))
     (gtk-table-attach-defaults table l-packetcount 0 1 1 2)
     (gtk-table-attach-defaults table e-packetcount 1 2 1 2)
     (gtk-misc-set-alignment l-packetcount 1.0 0.5)

     (gtk-table-set-col-spacing table 0 6)

     (gtk-widget-show-multi e-packetcount l-packetcount e-packetsize l-packetsize table)
     
     (create-itools-panel hostname-widget table
			  (lambda (host)
			    (let ((s-packetsize  (gtk-entry-get-text e-packetsize))
				  (s-packetcount (gtk-entry-get-text e-packetcount)))

			      (string-append "ping "
					     (if hostname-on "" "-n ")
					     
					     (cond ((string=? s-packetsize "default") "")
						   (else
						    (if (string->number s-packetsize)
							(string-append "-s " s-packetsize " ")
							"")))
					     
					     (cond ((string=? s-packetcount "unlimited") "")
						   (else
						    (if (string->number s-packetcount)
							(string-append "-c " s-packetcount " ")
							"")))
					     
					     host " 2>&1"))))))

(define (create-traceroute-panel)
   (let ((hostname-widget (gtk-check-button-new-with-label (gettext "Host name resolution")))
	 (table           (gtk-table-new 2 2 #f))
	 (l-maxhops       (gtk-label-new (gettext "Max number of hops:")))
         (e-maxhops       (gtk-entry-new))
	 (l-queries       (gtk-label-new (gettext "Number of queries:")))
	 (e-queries       (gtk-entry-new))

	 ; Parameters 
	 (hostname-on     #t)
	 (maxhops         30)
	 (queries         0))

     ;
     ; Hostname lookups
     ;
     (gtk-toggle-button-set-state hostname-widget hostname-on)
     (gtk-signal-connect hostname-widget "toggled"
			 (lambda () (set! hostname-on (not hostname-on))))

     ;
     ; Max hops
     ;
     (gtk-entry-set-text e-maxhops (if (= maxhops 0) "30" (number->string maxhops)))
     (gtk-table-attach-defaults table l-maxhops 0 1 0 1)
     (gtk-table-attach-defaults table e-maxhops 1 2 0 1)
     (gtk-misc-set-alignment l-maxhops 1.0 0.5)
     
     (gtk-entry-set-text e-queries (if (= queries 0) "3" (number->string queries)))
     (gtk-table-attach-defaults table l-queries 0 1 1 2)
     (gtk-table-attach-defaults table e-queries 1 2 1 2)
     (gtk-misc-set-alignment l-queries 1.0 0.5)

     (gtk-table-set-col-spacing table 0 6)

     (gtk-widget-show-multi e-maxhops l-maxhops e-queries l-queries table)
     
     (create-itools-panel hostname-widget table
			  (lambda (host)
			    (let ((s-queries (gtk-entry-get-text e-queries))
				  (s-maxhops (gtk-entry-get-text e-maxhops)))
			      
			      (string-append "traceroute "
					     (if hostname-on "" "-n ")

					     (if (string=? s-maxhops "30")
						 ""
						 (string-append "-m " s-maxhops " "))

					     (if (string=? s-queries "3")
						 ""
						 (string-append "-q " s-queries " "))
					     
					     host " 2>&1"))))))

(define (create-host-lookup-panel)

  (define default-server (gettext "default server"))
  ;; We define this in a strange way so that xgettext can pick up the
  ;; strings.
  (define menu-entries (map
			(lambda (elt)
			  (cons (gettext (cadar elt)) (cdr elt)))
			'(((gettext "Address") "A")
			  ((gettext "Name") "PTR")
			  ((gettext "Name server") "NS")
			  ((gettext "Mail exchanger") "MX")
			  ((gettext "Alias") "CNAME")
			  ((gettext "Start of authority") "SOA")
			  ((gettext "Any record") "ANY"))))
    
  (let ((hbox        (gtk-hbox-new #f 6))
	(l-search    (gtk-label-new (gettext "Search for:")))
	(m-search    (gtk-option-menu-new))
	(l-server    (gtk-label-new (gettext "Server:")))
	(e-server    (gtk-entry-new))

	; Parameters
	(query-type  "A")
	)

    (define (add-entries-to-menu menu items)
      (let ((this-menu (gtk-menu-new)))
	(for-each (lambda (x)
		    (let ((item (gtk-menu-item-new-with-label (string-append (car x) " (" (cadr x) ")"))))
		      (gtk-menu-append this-menu item)
		      (gtk-widget-show item)
		      (gtk-signal-connect item "activate"
					  (lambda ()
					    (set! query-type (cadr x))))))
		  items)
	(gtk-option-menu-set-menu menu this-menu)))

    (add-entries-to-menu m-search menu-entries)
    (gtk-box-pack-start hbox l-search #f #f 0)
    (gtk-box-pack-start hbox m-search #f #f 0)
    (gtk-box-pack-start hbox l-server #f #f 0)
    (gtk-box-pack-start hbox e-server #t #t 0)
    (gtk-widget-show-multi hbox l-search m-search l-server e-server)

    (gtk-entry-set-text e-server default-server)
    (create-itools-panel hbox (gtk-hbox-new #f 0)
			 (lambda (host)
			   (let ((server (gtk-entry-get-text e-server)))
			     (string-append
			      "host "
			      "-t "
			      query-type
			      " "
			      host
			      " "
			      (if (string=? server default-server)
				  ""
				  server)))))))

(define (create-whois-panel)

  (define default-server (gettext "default server"))
  ;; We define this in a strange way so that xgettext can pick up the
  ;; strings.
  (define menu-entries (map
			(lambda (elt)
			  (cons (gettext (cadar elt)) (cdr elt))
			  '(((gettext "Address") "A")
			    ((gettext "Name") "PTR")
			    ((gettext "Name server") "NS")
			    ((gettext "Mail exchanger") "MX")
			    ((gettext "Alias") "CNAME")
			    ((gettext "Start of authority") "SOA")
			    ((gettext "Any record") "ANY")))))
    
  (let ((hbox        (gtk-hbox-new #f 6))
	(l-search    (gtk-label-new (gettext "Search for:")))
	(m-search    (gtk-option-menu-new))
	(l-server    (gtk-label-new (gettext "Server:")))
	(e-server    (gtk-entry-new))

	; Parameters
	(query-type  "A")
	)

    (define (add-entries-to-menu menu items)
      (let ((this-menu (gtk-menu-new)))
	(for-each (lambda (x)
		    (let ((item (gtk-menu-item-new-with-label (string-append (car x) " (" (cadr x) ")"))))
		      (gtk-menu-append this-menu item)
		      (gtk-widget-show item)
		      (gtk-signal-connect item "activate"
					  (lambda ()
					    (set! query-type (cadr x))))))
		  items)
	(gtk-option-menu-set-menu menu this-menu)))

    (add-entries-to-menu m-search menu-entries)
    (gtk-box-pack-start hbox l-search #f #f 0)
    (gtk-box-pack-start hbox m-search #f #f 0)
    (gtk-box-pack-start hbox l-server #f #f 0)
    (gtk-box-pack-start hbox e-server TRUE TRUE 0)
    (gtk-widget-show-multi hbox l-search m-search l-server e-server)

    (gtk-entry-set-text e-server default-server)
    (create-itools-panel hbox (gtk-hbox-new #f 0)
			 (lambda (host)
			   (let ((server (gtk-entry-get-text e-server)))
			     (string-append
			      "host "
			      "-t "
			      query-type
			      " "
			      host
			      " "
			      (if (string=? server default-server)
				  ""
				  server)))))))


	       
(define (create-about-panel)
  (let ((alignment (gtk-alignment-new 0.5 0.5 0.0 0.0)))
    (gtk-container-add
     alignment
     (gnome-make-filled-vbox
      #f
      3
      (gnome-boxed-widget (gtk-label-new (gettext "GNOME Network Utilities")))
      (gnome-boxed-widget (gtk-label-new (string-append (gettext "Version ") "@MYVERSION@")))
      (gnome-boxed-widget (gtk-label-new "Federico Mena <federico@nuclecu.unam.mx>"))
      (gnome-boxed-widget (gtk-label-new "Miguel de Icaza <miguel@nuclecu.unam.mx>"))))
    (gtk-widget-show alignment)
    alignment))

(define (create-itools-notebook)
  (let ((notebook (gtk-notebook-new)))
    (gtk-notebook-append-page notebook (create-ping-panel)        (gtk-label-new (gettext "Ping")))
    (gtk-notebook-append-page notebook (create-traceroute-panel)  (gtk-label-new (gettext "Traceroute")))
    (gtk-notebook-append-page notebook (create-host-lookup-panel) (gtk-label-new (gettext "Host resolution")))
;    (gtk-notebook-append-page notebook (create-whois-panel)       (gtk-label-new " Whois "))
    (gtk-notebook-append-page notebook (create-about-panel)       (gtk-label-new (gettext "About")))
    (gtk-widget-show notebook)
    notebook))

(define (internet-tools)
  (let ((window (gtk-window-new 'toplevel))
	(vbox (gtk-vbox-new #f 0))
	(hbox (gtk-hbox-new #f 0))
	(quit (gtk-button-new-with-label (gettext "Exit"))))
    (gtk-window-set-policy window #t #t #t)
    (gtk-window-set-title window (gettext "GNOME Network Utilities"))
    (gtk-signal-connect window "delete_event" (lambda (x) (gtk-main-quit) 1))
    (gtk-container-add window vbox)
    (gtk-box-pack-start vbox (create-itools-notebook) #t #t 0)
    (gtk-container-border-width hbox 4)
    (gtk-box-pack-start vbox hbox #f #f 0)
    (gtk-box-pack-end hbox quit #f #f 0)
    (gtk-signal-connect quit "clicked" (lambda () (gtk-main-quit)))
    (gtk-widget-show-multi quit hbox vbox window)))

(launch-gnome internet-tools)


