#include "obgtk.h"

@implementation Gtk_Notebook
- init
{
  gtknotebook = GTK_NOTEBOOK(gtk_notebook_new());
  return [super castGtkContainer:GTK_CONTAINER(gtknotebook)];
}

- append_page:(Gtk_Widget *) child
       aLabel:(Gtk_Widget *) tab_label
{
  gtk_notebook_append_page(gtknotebook, child->gtkwidget,
			   tab_label->gtkwidget);
  return self;
}

- prepend_page:(Gtk_Widget *) child
	aLabel:(Gtk_Widget *) tab_label
{
  gtk_notebook_append_page(gtknotebook, child->gtkwidget,
			   tab_label->gtkwidget);
  return self;
}

- insert_page:(Gtk_Widget *) child
       aLabel:(Gtk_Widget *) tab_label
	 aPos:(gint) position
{
  gtk_notebook_insert_page(gtknotebook, child->gtkwidget,
			   tab_label->gtkwidget, position);
  return self;
}

- remove_page:(gint) page_num
{
  gtk_notebook_remove_page(gtknotebook, page_num);
  return self;
}

- (gint) current_page
{
  return gtk_notebook_current_page(gtknotebook);
}

- set_page:(gint) page_num
{
  gtk_notebook_set_page(gtknotebook, page_num);
  return self;
}

- next_page
{
  gtk_notebook_next_page(gtknotebook);
  return self;
}

- prev_page
{
  gtk_notebook_prev_page(gtknotebook);
  return self;
}

- set_tab_pos:(GtkPositionType) pos
{
  gtk_notebook_set_tab_pos(gtknotebook, pos);
  return self;
}

- set_show_tabs:(gint) show_tabs
{
  gtk_notebook_set_show_tabs(gtknotebook, show_tabs);
  return self;
}

- set_show_border:(gint) show_border
{
  gtk_notebook_set_show_border(gtknotebook, show_border);
  return self;
}
@end
