#include "obgtk.h"

@implementation Gtk_ScrolledWindow
- init
{
  id th = [Gtk_Adjustment new], tv = [Gtk_Adjustment new], retval;
  retval = [self initWithAdjustments:th adjV:tv];
  [th free]; [tv free];
  return retval;
}

- initWithAdjustments:(Gtk_Adjustment *) hadjustment
  adjV:(Gtk_Adjustment *) vadjustment
{
  gtkscrolledwindow = GTK_SCROLLED_WINDOW(gtk_scrolled_window_new(hadjustment->gtkadjustment,
								  vadjustment->gtkadjustment));
  return [super castGtkContainer:GTK_CONTAINER(gtkscrolledwindow)];
}

- (Gtk_Adjustment *)get_hadjustment
{
  return [[Gtk_Adjustment alloc] castGtkAdjustment:gtk_scrolled_window_get_hadjustment(gtkscrolledwindow)];
}

- (Gtk_Adjustment *)get_vadjustment
{
  return [[Gtk_Adjustment alloc] castGtkAdjustment:gtk_scrolled_window_get_vadjustment(gtkscrolledwindow)];
}

- set_policy:(GtkPolicyType) hscrollbar_policy
    pVScroll:(GtkPolicyType) vscrollbar_policy
{
  gtk_scrolled_window_set_policy(gtkscrolledwindow,
				 hscrollbar_policy,
				 vscrollbar_policy);
  return self;
}
@end
