#include "obgtk.h"

@implementation Gtk_Text
- init
{
  id th = [Gtk_Adjustment new], tv = [Gtk_Adjustment new], retval;
  retval = [self initWithAdjustments:th adjV:tv];
  [th free]; [tv free];
  return retval;
}

- initWithAdjustments:(Gtk_Adjustment *) hadjustment
		    adjV:(Gtk_Adjustment *) vadjustment
{
  gtktext = GTK_TEXT(gtk_text_new(hadjustment->gtkadjustment,
				  vadjustment->gtkadjustment));
  return [super castGtkWidget:GTK_WIDGET(gtktext)];
}

- set_adjustments:(Gtk_Adjustment *) hadjustment
	     adjV:(Gtk_Adjustment *) vadjustment
{
  gtk_text_set_adjustments(gtktext,
			   hadjustment->gtkadjustment,
			   vadjustment->gtkadjustment);
  return self;
}

- set_editable:(gint) editable
{
  gtk_text_set_editable(gtktext, editable);
  return self;
}

- set_point:(gint) index
{
  gtk_text_set_point(gtktext, index);
  return self;
}

- (guint) get_point;
{
  return gtk_text_get_point(gtktext);
}

- (guint) get_length
{
  return gtk_text_get_length(gtktext);
}

- freeze
{
  gtk_text_freeze(gtktext);
  return self;
}

- thaw
{
  gtk_text_thaw(gtktext);
  return self;
}

- insert :(GdkFont *) font
    colFg:(GdkColor *) fore
    colBg:(GdkColor *) back
 insChars:(const char *) chars
   insLen:(gint) length
{
  gtk_text_insert(gtktext, font, fore, back, chars, length);
  return self;
}

- (gint) backward_delete:(guint) nchars
{
  return gtk_text_backward_delete(gtktext, nchars);
}

- (gint) forward_delete:(guint) nchars
{
  return gtk_text_forward_delete(gtktext, nchars);
}
@end
