/* GnomENIUS Calculator
 * Copyright (C) 1997 George Lebl.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _CALC_H_
#define _CALC_H_

typedef enum {INFIX_NOTATION,POSTFIX_NOTATION,PREFIX_NOTATION} notation_t;
typedef enum {	NO_ERROR=0,
		PARSE_ERROR
	} error_t;

typedef struct {
	/*about incoming stuff*/
	notation_t notation_in; /*notation of input*/
	int float_prec;        /*precision of floats to use*/
	/*about outgoing stuff*/
	notation_t notation_out; /*notation of output*/
	int max_digits; /*max digits in the display 0= as many as I got*/
	int make_floats_ints;  /*make ints from floats during calculations*/
	int results_as_floats;  /*give result as float*/
	int scientific_notation; /*allways scientific notation*/
} calcstate_t;

char * evalexp(char * str, calcstate_t state,void (*errorfunc)(char *));

#endif
