/* GnomENIUS Calculator
 * Copyright (C) 1997 George Lebl.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _MYMATH_H_
#define _MYMATH_H_

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE !FALSE
#endif

/*get sin*/
void mympf_sin(mpf_t rop, mpf_t op);

/*get cos*/
void mympf_cos(mpf_t rop, mpf_t op);

/*get the value for pi*/
void mympf_getpi(mpf_t rop);

/*get the value for e*/
void mympf_gete(mpf_t rop);

/*my own power function for floats, very simple :) */
void mympf_pow_ui(mpf_t rop,mpf_t op,unsigned long e);

#endif
