/* GnomeTalk: Main interface module
 * (C) 1997 the Free Software Foundation
 *
 * Author: Federico Mena          (quartic@gimp.org)
 * Further hacks: Miguel de Icaza (miguel@kernel.org)
 */

#include <unistd.h>
#include <gdk/gdkkeysyms.h>
#include <gemvt/libgemvt.h>
#include "gnome.h"
#include "gemvt/libgemvt.h"
#include "global.h"
#include "talk.h"


#define TALK_WIDTH      80
#define TALK_HEIGHT     10
#define TALK_SCROLLBACK 100


static int sock_input_id;

char his_erase, his_kill, his_win_erase;


static void
tty_display(GtkTty *tty, char ch)
{
	GtkTerm *term = GTK_TERM(tty);
	int i;
	
	switch (ch) {
		case '\n':
			gtk_tty_put_in(tty, "\r\n", 2);
			break;

		case TALK_ERASE:
			gtk_tty_put_in(tty, "\b \b", 3);
			break;

		case TALK_KILL: /* ^U */
			for (i = term->cur_x; i > 0; i--)
				gtk_tty_put_in(tty, "\b \b", 3);
			break;

		case TALK_WIN_ERASE:
			gtk_term_clear (term, TRUE, TRUE);
			break;

		default:
			gtk_tty_put_in(tty, &ch, 1);
			break;
	}
}


static char
translate(char c)
{
	if (c == his_erase)
		return TALK_ERASE;
	else if (c == his_kill)
		return TALK_KILL;
	else if (c == his_win_erase)
		return TALK_WIN_ERASE;
	else
		return c;
}

gint
talk_quit(GtkWidget *widget, gpointer data)
{
		gdk_input_remove(sock_input_id);
		gtk_main_quit();

		return TRUE;
}

static void
read_from_socket(gpointer data, gint fd, GdkInputCondition condition)
{
	int  n;
	char ch;
	
	if (!(condition & GDK_INPUT_READ))
		return;

	n = read(fd, &ch, 1);

	if (n <= 0) {
                talk_quit(NULL, NULL);
		return;
	}

	tty_display(GTK_TTY(data), translate(ch));
}


static gint
key_press(GtkWidget *widget, const gchar *char_code, guint length, guint keyval, guint key_state, gpointer data)
{
	char ch;
	
	if (length > 0) {
		switch (keyval) {
		case GDK_Return:
			ch = '\n';
			break;
			
		case GDK_Delete:
		case GDK_BackSpace:
			ch = TALK_ERASE;
			break;
			
		default:
			ch = char_code[0];
			break;
		}
		
		write(talk_socket, &ch, 1);
		tty_display(GTK_TTY(widget), ch);
		
		return TRUE;
	}
	
	return FALSE;
}


static void
tty_scroll(GtkAdjustment *adj, gpointer *tty)
{
	gtk_term_set_scroll_offset(GTK_TERM(tty),
				   (gint)adj->value-TALK_SCROLLBACK);
}

void
create_talk_interface(void)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *his;
	GtkWidget *ours;
	GtkObject *adj;
	GtkWidget *scrollbar;
	char      *str;

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
			   GTK_SIGNAL_FUNC(talk_quit), NULL);
	gtk_window_set_title(GTK_WINDOW(window), _("Talk"));

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	gtk_widget_show(vbox);

	/* His */

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 2);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	str = g_copy_strings(_("Talking to "), his_name, NULL);
	label = gtk_label_new(str);
	g_free(str);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);
	
	his = gtk_tty_new(TALK_WIDTH, TALK_HEIGHT, TALK_SCROLLBACK);
	gtk_box_pack_start(GTK_BOX(hbox), his, TRUE, TRUE, 0);
	gtk_widget_set_sensitive (his, FALSE);
	gtk_widget_show(his);

	sock_input_id = gdk_input_add(talk_socket,
				      GDK_INPUT_READ,
				      read_from_socket,
				      his);

	adj = gtk_adjustment_new(TALK_SCROLLBACK, 0, TALK_SCROLLBACK, 1, 1, 1);
	gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
			   GTK_SIGNAL_FUNC(tty_scroll), his);
	scrollbar = gtk_vscrollbar_new(GTK_ADJUSTMENT(adj));
	gtk_box_pack_start(GTK_BOX(hbox), scrollbar, TRUE, TRUE, 0);
	gtk_widget_show(scrollbar);

	
	/* Ours */

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	ours = gtk_tty_new(TALK_WIDTH, TALK_HEIGHT, TALK_SCROLLBACK);
	gtk_box_pack_start(GTK_BOX(hbox), ours, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(ours), "key_press",
			   (GtkSignalFunc) key_press,
			   NULL);

	gtk_widget_grab_focus (ours);
	gtk_widget_show(ours);

	adj = gtk_adjustment_new(TALK_SCROLLBACK, 0, TALK_SCROLLBACK, 1, 1, 1);
	gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
			   GTK_SIGNAL_FUNC(tty_scroll), ours);
	scrollbar = gtk_vscrollbar_new(GTK_ADJUSTMENT(adj));
	gtk_box_pack_start(GTK_BOX(hbox), scrollbar, TRUE, TRUE, 0);
	gtk_widget_show(scrollbar);

	gtk_widget_show(window);
}
