/* The two `main' functions are shamelessly ripped off from
 * guile-1.2/libguile/guile.c.
 *
 * Hopefully this will evolve into a nice shell.
 */


#include <libguile.h>
#include "../guile-gtk/guile-gtk.h"

#include "gnome.h"


/* Debugger interface (don't change the order of the following lines) */
#define GDB_TYPE SCM
#include <libguile/gdb_interface.h>
GDB_INTERFACE;


/***** Export Gnome functions to Scheme *****/

/* FIXME!!!  All this stuff should be generated automatically */

SCM
guile_gnome_libdir_file(SCM scm_filename)
{
	char *filename;
	char *libdir_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG2, "gnome-libdir-file");

	filename    = SCM_CHARS(scm_filename);
	libdir_file = gnome_libdir_file(filename);

	ret = scm_makfrom0str(libdir_file);
	free(libdir_file);

	return ret;
}


SCM
guile_gnome_datadir_file(SCM scm_filename)
{
	char *filename;
	char *datadir_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG2, "gnome-datadir-file");
	
	filename    = SCM_CHARS(scm_filename);
	datadir_file = gnome_datadir_file(filename);

	ret = scm_makfrom0str(datadir_file);
	free(datadir_file);

	return ret;
}
	

static void
init_guile_gnome_defs(void)
{
	scm_make_gsubr("gnome-libdir-file", 1, 0, 0, guile_gnome_libdir_file);
	scm_make_gsubr("gnome-datadir-file", 1, 0, 0, guile_gnome_datadir_file);
}

void
locate_error (char *s)
{
	fprintf (stderr,
		 "I could not locate the %s file\n"
		 "please check that you have either installed the software,\n"
		 "Or you have set the GNOMEDIR variable to point to an appropiate\n"
		 "location\n", s);
	exit (1);
}

static void
inner_main (void *closure, int argc, char **argv)
{
	char *shared_guile_scm = gnome_datadir_file ("gnome/gnome.scm");
	char *cmd;
	char **argv_copy;
	int  i;

	/* We load the glue... */

	if (!shared_guile_scm){
		locate_error ("gnome.scm");
		exit (1);
	}

	/* ... initialize Guile-Gtk... */

	sgtk_init (&argc, &argv);

	/* ... then we initialize Gnome... */

	gnome_init(&argc, &argv);

	/* ... load the Scheme part of Gnome for apps to use... */

	init_guile_gnome_defs();
	
	scm_primitive_load (scm_makfrom0str (shared_guile_scm));

#if 0
	argv_copy = (char **) malloc (sizeof (char *) * (argc+3));
	for (i = 1; i < argc; i++)
		argv_copy [i+2] = argv [i];
	argv_copy [0] = argv [0];
	argv_copy [1] = "-l";
	argv_copy [2] = shared_guile_scm;
	argc += 2;
#endif
	scm_shell (argc, argv);

	free (shared_guile_scm);
}

int
main (int argc, char **argv)
{
	scm_boot_guile (argc, argv, inner_main, 0);
	return 0; /* never reached */
}
