#include <gtk/gtk.h>
#include <string.h>
#include "libgnome/gnome-defs.h"
#include "gnome-properties.h"
#include "gnome-actionarea.h"

GnomePropertyConfigurator *
gnome_property_configurator_new (void)
{
	GnomePropertyConfigurator *this = g_malloc (sizeof (GnomePropertyConfigurator));
	GtkWidget *notebook;

	notebook = gtk_notebook_new ();
	gtk_widget_show (notebook);
	
	this->notebook = notebook;

	return this;
}

void
gnome_property_configurator_destroy (GnomePropertyConfigurator *this)
{
	gtk_widget_destroy (this->notebook);
}

void
gnome_property_configurator_register (GnomePropertyConfigurator *this,
				      GtkWidget *title_widget, GtkWidget *content_widget,
				      int (*callback)(GnomePropertyRequest))
{
	gtk_notebook_append_page (GTK_NOTEBOOK (this->notebook), content_widget, title_widget);

	printf ("add\n");

	gtk_widget_show (content_widget);
	gtk_widget_show (title_widget);
}

