/* GNOME GUI Library
 * Copyright (C) 1997 the Free Software Foundation
 *
 * Author: Miguel de Icaza
 */

#include "libgnome/gnome-defs.h"
#include "gnome-messagebox.h"
#include <gtk/gtk.h>

struct pixmap_item {
	GdkPixmap *pixmap;
	GdkBitmap *mask;
};

static GHashTable *pixmap_hash;

GtkWidget *
gnome_create_pixmap_widget (GtkWidget *window, GtkWidget *holder, char *file)
{
	struct pixmap_item *pit;
	GtkStyle  *style;
	GtkWidget *pixmap_widget;
	void      *s;

	g_assert(window != NULL);

	if (!file)
		return NULL;

	if (!pixmap_hash)
		pixmap_hash = g_hash_table_new (g_string_hash, g_string_equal);
	
	if (!GTK_WIDGET_REALIZED(window))
		gtk_widget_realize(window);

	style = holder ? gtk_widget_get_style (holder) : 0;
	if ((s = g_hash_table_lookup (pixmap_hash, file))){
		pit = s;
		return gtk_pixmap_new (pit->pixmap, pit->mask);
	}

	pit = g_new (struct pixmap_item, 1);
	pit->pixmap = gdk_pixmap_create_from_xpm (window->window, &pit->mask,
						  &style->bg [GTK_STATE_NORMAL],
						  file);
	pixmap_widget = gtk_pixmap_new (pit->pixmap, pit->mask);
	g_hash_table_insert (pixmap_hash, g_strdup (file), pit);
	
	return pixmap_widget;
}

static void
destroy_hash_element (void *key, void *val, void *data)
{
	struct pixmap_item *pi = val;

	gdk_pixmap_destroy (pi->pixmap);
	gdk_pixmap_destroy (pi->mask);
	g_free (val);
	g_free (key);
}

void
gnome_destroy_pixmap_cache (void)
{
	if (!pixmap_hash)
		return;

	g_hash_table_foreach (pixmap_hash, destroy_hash_element, 0);
	g_hash_table_destroy (pixmap_hash);
}
