#include <stdio.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include "gnome.h"
#include "gnome-desktop.h"

#define _(String) gettext(String)

void test (char *);
GtkWidget *main_window;
GList *props = NULL;

struct gnome_prop {
	GFunc *call;
};

GnomePropertyConfigurator *display_config;

load_configurators (void)
{
	background_setup (main_window);
        screensaver_setup (main_window);
}

void
configurators_setup (void)
{
	/* Load the external configurators */
	load_configurators ();

	/* Then, start up the internal configurators */
}

int
gnome_config_load_int (char *str)
{
	return 0;
}

void
register_extension (GtkWidget *title_widget, GtkWidget *content_widget,
		    int (*callback)(GnomePropertyRequest r))
{
	gnome_property_configurator_register (display_config, title_widget, content_widget, callback);
}

GtkWidget *
get_monitor_preview_widget (GtkWidget *window)
{
	GtkWidget *pwid;
	GdkPixmap *pixmap, *mask;
	GtkStyle  *style;
	char *f;
	
	style = gtk_widget_get_style (window);
	f = gnome_datadir_file ("pixmaps/monitor.xpm");
	/* FIXME if f is 0, alert () */
	pixmap = gdk_pixmap_create_from_xpm (window->window, &mask, &style->bg [GTK_STATE_NORMAL], f);
	free (f);

	pwid = gtk_pixmap_new (pixmap, mask);
	gtk_widget_show (pwid);

	return pwid;
}

static gint
deleteFn (GtkWidget *widget, gpointer *data)
{
	gtk_widget_destroy (main_window);
	gtk_main_quit ();

	return TRUE;
}

static void
display_properties_action (GtkWidget *w, gint close)
{
	gnome_property_configurator_request (display_config, GNOME_PROPERTY_APPLY);
	gnome_property_configurator_request (display_config, GNOME_PROPERTY_WRITE);
	gnome_config_sync ();

	if (close)
		deleteFn (NULL, NULL);
}

void
display_properties_setup (void)
{
	GtkWidget *vbox = gtk_vbox_new (FALSE, 0),
		*hbox = gtk_hbox_new (FALSE, GNOME_PAD),
		*bf = gtk_frame_new (NULL),
		*bok = gtk_button_new_with_label (_("  Ok  ")),
		*bapl = gtk_button_new_with_label (_(" Apply ")),
		*bcl = gtk_button_new_with_label (_(" Cancel "));

	display_config = gnome_property_configurator_new ();
	main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_policy (GTK_WINDOW (main_window), FALSE, FALSE, TRUE);
	gtk_signal_connect (GTK_OBJECT (main_window), "delete_event",
			    GTK_SIGNAL_FUNC (deleteFn), NULL);	

	gtk_signal_connect (GTK_OBJECT (bcl), "clicked",
			    GTK_SIGNAL_FUNC (deleteFn), NULL);	

	gtk_signal_connect (GTK_OBJECT (bok), "clicked",
			    GTK_SIGNAL_FUNC (display_properties_action), (gpointer) 1);

	gtk_signal_connect (GTK_OBJECT (bapl), "clicked",
			    GTK_SIGNAL_FUNC (display_properties_action), (gpointer) 0);

	gtk_container_border_width (GTK_CONTAINER (hbox), GNOME_PAD);
	gtk_frame_set_shadow_type (GTK_FRAME (bf), GTK_SHADOW_OUT);

	configurators_setup ();

	gtk_container_add (GTK_CONTAINER(main_window), vbox);
	gtk_box_pack_start (GTK_BOX (vbox), display_config->notebook, FALSE, FALSE, 0);
	
	gtk_box_pack_end (GTK_BOX (hbox), bcl, FALSE, FALSE, 0);
	gtk_box_pack_end (GTK_BOX (hbox), bapl, FALSE, FALSE, 0);
	gtk_box_pack_end (GTK_BOX (hbox), bok, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER(bf), hbox);
	gtk_box_pack_start (GTK_BOX (vbox), bf, FALSE, FALSE, 0);

	gtk_widget_show (bok);
	gtk_widget_show (bapl);
	gtk_widget_show (bcl);
	gtk_widget_show (hbox);
	gtk_widget_show (bf);
	gtk_widget_show (display_config->notebook);
	gtk_widget_show (vbox);
	gtk_widget_show (main_window);
}

int
main (int argc, char *argv [])
{
	gtk_init (&argc, &argv);
	gnome_init (&argc, &argv);
	
	display_properties_setup ();

	gtk_main ();

	gnome_property_configurator_destroy (display_config);
	return 0;
}
