
#include <gtk/gtk.h>
#include <gnome.h>
#include "minefield.h"

static GtkWidget *mfield;
GtkWidget *flags_label;
GtkWidget *setupdialog;
GtkWidget *mfieldbox;
GtkWidget *xentry;
GtkWidget *yentry;
GtkWidget *mentry;

int ysize, xsize;
int nmines;

void quit_game(GtkWidget *widget, gpointer data)
{
        gtk_main_quit();
}

void new_game(GtkWidget *widget, gpointer data)
{
	gtk_minefield_restart(GTK_MINEFIELD(mfield));
	gtk_widget_draw(mfield, NULL);
}

void setupdialog_destroy(GtkWidget *widget, int mode)
{
	if (mode == 1) {
		gtk_widget_destroy(setupdialog);
	} else {
		setupdialog = NULL;
	}
}

void marks_changed(GtkWidget *widget, gpointer data)
{
        GtkMineField *mf = GTK_MINEFIELD(widget);
	char val[16];

	sprintf(val, "Flags: %d", mf->flags);
	gtk_label_set(GTK_LABEL(flags_label), val);
}

void lose_game(GtkWidget *widget, gpointer data)
{
        gtk_label_set(GTK_LABEL(flags_label), "Boink!");
}

void create_mfield(void)
{
	mfield = gtk_minefield_new(xsize, ysize);
	gtk_minefield_set_mines(GTK_MINEFIELD(mfield), (guint)nmines);
	new_game(mfield, NULL);
	gtk_box_pack_start(GTK_BOX(mfieldbox), mfield, TRUE, TRUE, 0);

	gtk_signal_connect(GTK_OBJECT(mfield), "marks_changed",
			   GTK_SIGNAL_FUNC(marks_changed), NULL);
	gtk_signal_connect(GTK_OBJECT(mfield), "explode",
			   GTK_SIGNAL_FUNC(lose_game), NULL);
	
        gtk_widget_show(mfield);
}

void do_setup(GtkWidget *widget, gpointer data)
{
	int xs, ys, nm;
	int restart;

	restart = 0;
	xs = atoi(gtk_entry_get_text(GTK_ENTRY(xentry)));
	ys = atoi(gtk_entry_get_text(GTK_ENTRY(yentry)));
        nm = atoi(gtk_entry_get_text(GTK_ENTRY(mentry)));

	if (xs != xsize || ys != ysize) {
		xsize = xs;
		ysize = ys;
		gtk_widget_destroy(mfield);
		create_mfield();
		restart = 1;
	}

	if (nm != nmines) {
                nmines = nm;
		gtk_minefield_set_mines(GTK_MINEFIELD(mfield), (guint)nmines);
		restart = 1;
	}

	if (restart) new_game(mfield, NULL);
	gtk_widget_destroy(setupdialog);
}

void setup_game(GtkWidget *widget, gpointer data)
{
        GtkWidget *all_boxes;
	GtkWidget *box;
        GtkWidget *label;
	GtkWidget *button;
	gchar numstr[8];
	
        if (setupdialog) return;
	setupdialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_container_border_width(GTK_CONTAINER(setupdialog), 10);
	gtk_window_set_title(GTK_WINDOW(setupdialog), "Gnomine setup");
	gtk_signal_connect(GTK_OBJECT(setupdialog),
			   "destroy",
			   GTK_SIGNAL_FUNC(setupdialog_destroy),
			   0);

	all_boxes = gtk_vbox_new(TRUE, 5);
	gtk_container_add(GTK_CONTAINER(setupdialog), all_boxes);

	box = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(all_boxes), box, TRUE, TRUE, 0);
	label = gtk_label_new("Horizontal size:");
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 0);
	gtk_widget_show(label);
	xentry = gtk_entry_new();
	gtk_widget_set_usize(xentry, 50, -1);
	gtk_box_pack_start(GTK_BOX(box), xentry, FALSE, TRUE, 0); /*fold00*/
	sprintf(numstr, "%d", xsize);
	gtk_entry_set_text(GTK_ENTRY(xentry),numstr);
	gtk_widget_show(xentry);
	gtk_widget_show(box);

	box = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(all_boxes), box, TRUE, TRUE, 0);
	label = gtk_label_new("Vertical size:");
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 0);
	gtk_widget_show(label);
	yentry = gtk_entry_new();
	gtk_widget_set_usize(yentry, 50, -1);
	gtk_box_pack_start(GTK_BOX(box), yentry, FALSE, TRUE, 0); /*fold00*/
	sprintf(numstr, "%d", ysize);
	gtk_entry_set_text(GTK_ENTRY(yentry),numstr);
	gtk_widget_show(yentry);
	gtk_widget_show(box);

	box = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(all_boxes), box, TRUE, TRUE, 0);
	label = gtk_label_new("Number of mines:");
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 0);
	gtk_widget_show(label);
	mentry = gtk_entry_new();
	gtk_widget_set_usize(mentry, 50, -1);
	gtk_box_pack_start(GTK_BOX(box), mentry, FALSE, TRUE, 0); /*FOLD00*/
	sprintf(numstr, "%d", nmines);
	gtk_entry_set_text(GTK_ENTRY(mentry),numstr);
	gtk_widget_show(mentry);
	gtk_widget_show(box);

	box = gtk_hbox_new(TRUE, 5);
	gtk_box_pack_start(GTK_BOX(all_boxes), box, TRUE, TRUE, 0);
	button = gtk_button_new_with_label("Ok");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(do_setup), NULL);
	gtk_box_pack_start(GTK_BOX(box), button, TRUE, TRUE, 5); /*FOLD00*/
        gtk_widget_show(button);
	button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
                           (GtkSignalFunc)setupdialog_destroy,
			   (gpointer)1);
	gtk_box_pack_start(GTK_BOX(box), button, TRUE, TRUE, 5); /*FOLD00*/
        gtk_widget_show(button);
        gtk_widget_show(box);
	
	gtk_widget_show(all_boxes);
	gtk_widget_show(setupdialog);
}

void main(int argc, char *argv[])
{
        GtkWidget *window;
        GtkWidget *all_boxes;
	GtkWidget *menu_box;
	GtkWidget *status_table;
        GtkWidget *menu;
        GtkWidget *menubar;
        GtkWidget *menubar_item;
        GtkWidget *menu_item;
	
        gtk_init(&argc, &argv);
        gnome_init(&argc, &argv);
	
        window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_window_set_title(GTK_WINDOW(window), "Gnomine");
//        gtk_container_border_width(GTK_CONTAINER(window), 30);
        
        gtk_signal_connect(GTK_OBJECT(window), "destroy",
                           GTK_SIGNAL_FUNC(quit_game), NULL);

        all_boxes = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(window), all_boxes);
        


        menu_box = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(all_boxes), menu_box, TRUE, TRUE, 0);

        menu = gtk_menu_new();

        menubar_item = gtk_menu_item_new_with_label("Game");

	menu_item = gtk_menu_item_new_with_label("New");
        gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                           GTK_SIGNAL_FUNC(new_game), NULL);
        gtk_menu_append(GTK_MENU(menu), menu_item);
        gtk_widget_show(menu_item);

	menu_item = gtk_menu_item_new_with_label("Setup");
        gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                           GTK_SIGNAL_FUNC(setup_game), NULL);
        gtk_menu_append(GTK_MENU(menu), menu_item);
        gtk_widget_show(menu_item);

	menu_item = gtk_menu_item_new_with_label("Quit");
        gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                           GTK_SIGNAL_FUNC(quit_game), NULL);
        gtk_menu_append(GTK_MENU(menu), menu_item);
        gtk_widget_show(menu_item);

        gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubar_item), menu);
        gtk_widget_show(menubar_item);

        menubar = gtk_menu_bar_new();
        gtk_widget_show(menubar);
        gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubar_item);

        gtk_box_pack_start(GTK_BOX(menu_box), menubar, TRUE, TRUE, 0);

        gtk_widget_show(menu_box);

	xsize = gnome_config_get_int("/gnomine/geometry/xsize=20");
	ysize = gnome_config_get_int("/gnomine/geometry/ysize=20");
	nmines = gnome_config_get_int("/gnomine/geometry/nmines=20");

        mfieldbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(all_boxes), mfieldbox, TRUE, TRUE, 0);
	gtk_widget_show(mfieldbox);

	create_mfield();
        status_table = gtk_table_new(1, 3, TRUE);
	gtk_box_pack_start(GTK_BOX(all_boxes), status_table, TRUE, TRUE, 0);

	flags_label = gtk_label_new("Flags: ");
	gtk_table_attach(GTK_TABLE(status_table), flags_label,
			 0, 1, 0, 1, 0, 0, 3, 3);
	gtk_widget_show(flags_label);
	
        gtk_widget_show(status_table);
	
	gtk_widget_show(all_boxes);
        gtk_widget_show(window);

        gtk_main();

	gnome_config_set_int("/gnomine/geometry/xsize", xsize);
	gnome_config_set_int("/gnomine/geometry/ysize", ysize);
	gnome_config_set_int("/gnomine/geometry/nmines", nmines);
	gnome_config_sync();
}



