/*
 * GNOME panel menu module.
 * (C) 1997 The Free Software Foundation
 *
 * Author: Miguel de Icaza
 */

#include <stdio.h>
#include <libintl.h>
#include <sys/stat.h>
#include <dlfcn.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include "gnome.h"
#include "../applet.h"
#define _(String) gettext(String)


#define free_if_empty(x) { if (x) g_free (x); }

char *gnome_folder;

PanelCallback callback;

char *
query (void)
{
	return "Menu";
}

void
activate_app_def (GtkWidget *widget, void *data)
{
	struct gnome_desktop_entry *item = data;

	gnome_desktop_entry_launch (item);
}

void
setup_menuitem (GtkWidget *menuitem, GtkWidget *pixmap, char *thisfile)
{
	GtkWidget *label, *hbox, *align;
	char *p = strstr (thisfile, ".desktop");

	if (p)
		*p = 0;

	label = gtk_label_new (thisfile);
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_widget_show (label);
	
	hbox = gtk_hbox_new (FALSE, 0);
	align = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
	gtk_container_border_width (GTK_CONTAINER (align), 1);

	gtk_box_pack_start (GTK_BOX (hbox), align, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 4);
	gtk_container_add (GTK_CONTAINER (menuitem), hbox);

	if (pixmap){
		gtk_container_add (GTK_CONTAINER (align), pixmap);
		gtk_widget_set_usize (align, 22, 16);
	} else
		gtk_widget_set_usize (align, 22, 16);
	
	gtk_widget_show (align);
	gtk_widget_show (hbox);
	gtk_widget_show (menuitem);
}

void
free_app_def (GtkWidget *widget, void *data)
{
	struct gnome_desktop_entry *item = data;

	gnome_desktop_entry_free (item);
}

void
add_menu_separator (GtkWidget *menu)
{
	GtkWidget *menuitem;
	
	menuitem = gtk_menu_item_new ();
	gtk_widget_show (menuitem);
	gtk_container_add (GTK_CONTAINER (menu), menuitem);
}

void
free_string (GtkWidget *widget, void *data)
{
	g_free (data);
}

void
add_to_panel (char *applet, char *arg)
{
	PanelCommand cmd;
	
	fprintf (stderr, "Asking Panel to add [%s,%s] to the panel\n", applet, arg);
	cmd.cmd = PANEL_CMD_NEW_APPLET;
	cmd.params.new_applet.applet = applet;
	cmd.params.new_applet.params  = arg;
	(*callback) (&cmd);
}

void
add_app_to_panel (GtkWidget *widget, void *data)
{
	struct gnome_desktop_entry *ii = data;

	add_to_panel ("Launcher", ii->location);
}

void
add_dir_to_panel (GtkWidget *widget, void *data)
{
	add_to_panel (query (), data);
}

GtkWidget *
create_menu_at (GtkWidget *window, char *menudir, int create_app_menu)
{	
	struct gnome_desktop_entry *item_info;
	GtkWidget *menu;
	struct dirent *dent;
	struct stat s;
	char *filename;
	DIR *dir;
	int  items = 0;
	
	dir = opendir (menudir);
	if (dir == NULL)
		return NULL;

	menu = gtk_menu_new ();
	
	while ((dent = readdir (dir)) != NULL){
		GtkWidget     *menuitem, *sub, *pixmap;
		GtkSignalFunc activate_func;
		char          *thisfile, *pixmap_name;

		thisfile = dent->d_name;
		/* Skip over . and .. */
		if ((thisfile [0] == '.' && thisfile [1] == 0) ||
		    (thisfile [0] == '.' && thisfile [1] == '.' && thisfile [2] == 0))
			continue;

		filename = g_concat_dir_and_file (menudir, thisfile);
		if (stat (filename, &s) == -1){
			g_free (filename);
			continue;
		}

		sub = 0;
		item_info = 0;
		if (S_ISDIR (s.st_mode)){
			sub = create_menu_at (window, filename, create_app_menu);
			if (!sub){
				g_free (filename);
				continue;
			}
			/* just for now */
			pixmap_name = 0;

			if (create_app_menu){
				GtkWidget *pixmap = 0;
				char *text;

				/* FIXME: Loading the pixmap over and over is far from efficient */
				text = g_copy_strings ("Menu: ", thisfile, NULL);

				menuitem = gtk_menu_item_new ();
				gtk_menu_prepend (GTK_MENU (sub), menuitem);
				gtk_widget_show (menuitem);
				
				menuitem = gtk_menu_item_new ();
				if (gnome_folder){
					pixmap =gnome_create_pixmap_widget (window, menuitem, gnome_folder);
					gtk_widget_show (pixmap);
				}
				setup_menuitem (menuitem, pixmap, text);
				g_free (text);
				text = g_strdup (filename);
				gtk_menu_prepend (GTK_MENU (sub), menuitem);
				gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
						    (GtkSignalFunc) add_dir_to_panel,
						    text);
				gtk_signal_connect (GTK_OBJECT (menuitem), "destroy",
						    (GtkSignalFunc) free_string,
						    text);
						    
			}
		} else {
			if (strstr (filename, ".desktop") == 0){
				g_free (filename);
				continue;
			}
			item_info = gnome_desktop_entry_load (filename);
			if (!item_info){
				g_free (filename);
				continue;
			}
			pixmap_name = item_info->small_icon;

		}
		items++;
		menuitem = gtk_menu_item_new ();
		if (sub)
			gtk_menu_item_set_submenu (GTK_MENU_ITEM(menuitem), sub);

		pixmap = 0;
		if (pixmap_name && g_file_exists (pixmap_name)){
			pixmap = gnome_create_pixmap_widget (window, menuitem, item_info->small_icon);
			if (pixmap)
				gtk_widget_show (pixmap);
		}
		setup_menuitem (menuitem, pixmap, thisfile);

		gtk_menu_append (GTK_MENU (menu), menuitem);

		gtk_signal_connect (GTK_OBJECT (menuitem), "destroy",
				    (GtkSignalFunc) free_app_def, item_info);

		activate_func = create_app_menu ? add_app_to_panel : activate_app_def;
		gtk_signal_connect (GTK_OBJECT (menuitem), "activate", activate_func, item_info);

		g_free (filename);
	}
	closedir (dir);

	if (items == 0){
		gtk_widget_destroy (menu);
		return 0;
	}
	return menu;
}

void
menu_position (GtkMenu *menu, gint *x, gint *y, gpointer data)
{
	GtkWidget *widget = (GtkWidget *) data;
	int wx, wy;
	
	gdk_window_get_origin (widget->window, &wx, &wy);
	
	*x = wx;
	*y = wy - GTK_WIDGET (menu)->allocation.height;
}

void
activate_menu (GtkWidget *widget, void *closure)
{
        GtkWidget *menu = closure ;

	gtk_menu_popup (GTK_MENU (menu), 0, 0, menu_position, widget, 1, 0);
}

void
panel_configure (GtkWidget *widget, void *data)
{
	printf ("Panel configuration\n");
}

void
panel_reload (GtkWidget *widget, void *data)
{
}

static void
munge_applet_item(gpointer untrans, gpointer user_data)
{
	GList **list;
	GList  *node;
	int     pos;

	list = user_data;

	/* Insert applet id in alphabetical order */
	
	node = *list;
	pos  = 0;
	
	for (pos = 0; node; node = node->next, pos++)
		if (strcmp(_(untrans), _(node->data)) < 0)
			break;
	
	*list = g_list_insert(*list, g_strdup(_(untrans)), pos);

	/* We can destroy the untranslated id now */

	g_free(untrans);
}

static void
append_list_item_to_menu(gpointer data, gpointer user_data)
{
	GtkMenu   *menu;
	GtkWidget *menuitem;

	menu = GTK_MENU(user_data);
	menuitem = gtk_menu_item_new();
	setup_menuitem(menuitem, NULL, data);
	/* FIXME: connect to "activate" signal */
	gtk_menu_append(menu, menuitem);

	g_free(data); /* We can now destroy the string */
}

static GtkWidget *
create_applets_menu(void)
{
	GtkWidget    *menu;
	GList        *list;
	GList        *applets_list;
	PanelCommand  cmd;

	/* Get list of applet types */

	cmd.cmd = PANEL_CMD_GET_APPLET_TYPES;
	list = (*callback) (&cmd);

	/* Now translate and sort them */

	applets_list = NULL;
	g_list_foreach(list, munge_applet_item, &applets_list);

	/* Untranslated items have been destroyed by
	 * munge_applet_item(), now create a menu of the translated
	 * and sorted ones.
	 */

	g_list_free(list);

	menu = gtk_menu_new();

	g_list_foreach(applets_list, append_list_item_to_menu, menu);

	/* Translated items have been destroyed by
	 * append_list_item_to_menu(), now just destroy the list.
	 */

	g_list_free(applets_list);
	return menu;
}

GtkWidget *
create_panel_submenu (GtkWidget *app_menu)
{
	GtkWidget *menu, *menuitem;

	menu = gtk_menu_new ();
	
	menuitem = gtk_menu_item_new ();
	setup_menuitem (menuitem, 0, _("Add to panel"));
	gtk_menu_append (GTK_MENU (menu), menuitem);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), app_menu);

	menuitem = gtk_menu_item_new ();
	setup_menuitem (menuitem, 0, _("Add applet"));
	gtk_menu_append (GTK_MENU (menu), menuitem);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), create_applets_menu());

	add_menu_separator(menu);
	
	menuitem = gtk_menu_item_new ();
	setup_menuitem (menuitem, 0, _("Configure"));
	gtk_menu_append (GTK_MENU (menu), menuitem);
        gtk_signal_connect (GTK_OBJECT (menuitem), "activate", (GtkSignalFunc) panel_configure, 0);

	menuitem = gtk_menu_item_new ();
	setup_menuitem (menuitem, 0, _("Reload configuration"));
	gtk_menu_append (GTK_MENU (menu), menuitem);
        gtk_signal_connect (GTK_OBJECT (menuitem), "activate", (GtkSignalFunc) panel_reload, 0);

	return menu;
}

void
panel_lock (GtkWidget *widget, void *data)
{
	system ("gnome-lock");
}

void
panel_logout (GtkWidget *widget, void *data)
{
	PanelCommand cmd;

	cmd.cmd = PANEL_CMD_QUIT;
	(*callback) (&cmd);
}

void
add_special_entries (GtkWidget *menu, GtkWidget *app_menu)
{
	GtkWidget *menuitem;
	
	/* Panel entry */

	add_menu_separator (menu);

	menuitem = gtk_menu_item_new ();
	setup_menuitem (menuitem, 0, _("Panel"));
	gtk_menu_append (GTK_MENU (menu), menuitem);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), create_panel_submenu (app_menu));

	add_menu_separator (menu);
	
	menuitem = gtk_menu_item_new ();
	setup_menuitem (menuitem, 0, _("Lock screen"));
	gtk_menu_append (GTK_MENU (menu), menuitem);
	gtk_signal_connect (GTK_OBJECT (menuitem), "activate", (GtkSignalFunc) panel_lock, 0);

	menuitem = gtk_menu_item_new ();
	setup_menuitem (menuitem, 0, _("Log out"));
	gtk_menu_append (GTK_MENU (menu), menuitem);
	gtk_signal_connect (GTK_OBJECT (menuitem), "activate", (GtkSignalFunc) panel_logout, 0);
}


GtkWidget *
create_panel_menu (GtkWidget *window, char *menudir, int main_menu)
{
	GtkWidget *vbox, *button, *pixmap, *button_pixmap, *menu, *app_menu;
	static char *button_pixmap_name;
	char *pixmap_name;

	if (main_menu)
		pixmap_name = gnome_unconditional_pixmap_file ("panel-menu-main.xpm");
	else
		pixmap_name = gnome_unconditional_pixmap_file ("panel-folder.xpm");
		
	if (!button_pixmap_name)
		button_pixmap_name = gnome_pixmap_file ("arrowup.xpm");

	vbox   = gtk_vbox_new (FALSE, 0);
	button = gtk_button_new ();
	gtk_widget_show (vbox);
	gtk_widget_show (button);

	button_pixmap = gnome_create_pixmap_widget (window, button, button_pixmap_name);
	pixmap        = gnome_create_pixmap_widget (window, button, pixmap_name);

	gtk_container_add (GTK_CONTAINER (button), button_pixmap);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), pixmap, FALSE, FALSE, 0);

	gtk_widget_show (button_pixmap);
	gtk_widget_show (button);
	gtk_widget_show (pixmap);
	gtk_widget_show (vbox);

	menu = create_menu_at (window, menudir, 0);
	if (main_menu){
		app_menu = create_menu_at (window, menudir, 1);
		add_special_entries (menu, app_menu);
	}
	gtk_signal_connect (GTK_OBJECT (button), "clicked", (GtkSignalFunc) activate_menu, menu);

	g_free (pixmap_name);
	return vbox;
}

GtkWidget *
create_menu_widget (GtkWidget *window, char *arguments, char *menudir)
{
	GtkWidget *menu, *add_menu;
	int main_menu;
	
	main_menu = (strcmp (arguments, ".") == 0);
	menu = create_panel_menu (window, menudir, main_menu);
	return menu;
}

gpointer
panel_callback (AppletCommand *cmd)
{
	return NULL;
}

void
init (PanelCallback cback, Panel *panel, char *params, int xpos, int ypos)
{
	GtkWidget *menu_component;
	char *menu_base = gnome_unconditional_datadir_file ("apps");
	char *this_menu;
	PanelCommand cmd;

	if (!getenv ("PATH"))
		return;

	fprintf (stderr, "Menu: %s\n", params);
	
	if (*params == '/')
		this_menu = strdup (params);
	else 
		this_menu = g_concat_dir_and_file (menu_base, params);

	if (!g_file_exists (this_menu)){
		g_free (menu_base);
		g_free (this_menu);
		return;
	}

	gnome_folder = gnome_unconditional_pixmap_file ("gnome-folder-small.xpm");
	if (!g_file_exists (gnome_folder)){
		free (gnome_folder);
		gnome_folder = NULL;
	}
	
	callback = cback;
	menu_component = create_menu_widget (panel->window, params, this_menu);

	fprintf (stderr, "REGISTRANDO: %s\n", params);
	cmd.cmd = PANEL_CMD_REGISTER_TOY;
	cmd.params.register_toy.applet   = menu_component;
	cmd.params.register_toy.callback = panel_callback;
	cmd.params.register_toy.id       = query();
	cmd.params.register_toy.params   = params;
	cmd.params.register_toy.xpos     = xpos;
	cmd.params.register_toy.ypos     = ypos;
	cmd.params.register_toy.flags    = APPLET_HAS_PROPERTIES;

	(*callback) (&cmd);
}

#if 0
main (int argc, char *argv [])
{
	GtkWidget *window;
	GtkWidget *thing;
	void *lib_handle;
	char *f;
	void *(*init_ptr)(GtkWidget *, char *);

	gtk_init (&argc, &argv);
	gnome_init (&argc, &argv);

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	thing = init (window, ".");
	if (!thing)
		return printf ("Module was not initialized\n");
	
	gtk_container_add (GTK_CONTAINER (window), (GtkWidget *) thing);
	gtk_widget_set_usize (window, 48, 48);
	gtk_window_set_policy (window, 0, 0, 1);
	gtk_widget_show (window);
	gtk_widget_realize (window);
	gtk_main ();
	
	return 0;
}
#endif
