
/* GnomeMeeting -- A Video-Conferencing application
 * Copyright (C) 2000-2002 Damien Sandras
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *                         tray.h  -  description
 *                         -------------------------
 *   begin                : Wed Oct 3 2001
 *   copyright            : (C) 2000-2002 by Miguel Rodrguez
 *   description          : This file contains all functions needed for
 *                          the system tray.
 *   email                : migrax@terra.es (all the new code)
 *                          dsandras@seconix.com (old applet code).
 *
 */

#ifndef _TRAY_H_
#define _TRAY_H_

#include "config.h"
#include <glib-object.h>

G_BEGIN_DECLS

/* DESCRIPTION  :  This callback is called by a timeout function
 * BEHAVIOR     :  If current picture in the tray is globe,
 *                 then displays globe2, else displays globe
 * PRE          :  /
 */
gint gnomemeeting_tray_flash (GObject *);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Init the tray and menus and callbacks (for this tray icon)
 * PRE          :  /
 */
GObject *gnomemeeting_init_tray (void);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  If int = 0, displays the available icon.
 *                 If int = 1, displays the ringing icon and plays a sound.
 *                 If int = 2, displays the busy icon.
 * PRE          :  /
 */
void gnomemeeting_tray_set_content (GObject *, int);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Show the tray icon.
 * PRE          :  /
 */
void gnomemeeting_tray_show (GObject *);


/* DESCRIPTION  : /
 * BEHAVIOR     : Hide the tray window
 * PRE          : /
 */
void gnomemeeting_tray_hide (GObject *);

/* DESCRIPTION  : Returns a popup menu item
 * BEHAVIOR     : 
 * PRE          : /
 */
GObject *gnomemeeting_tray_get_uiinfo (GObject *tray, int index);

/* DESCRIPTION  : Returns true if the tray shows a rining phone
 * BEHAVIOR     : 
 * PRE          : /
 */
gboolean gnomemeeting_tray_is_ringing (GObject *tray);

G_END_DECLS

#endif
