/* cheese-effects-manager.c generated by valac, the Vala compiler
 * generated from cheese-effects-manager.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <cheese-effect.h>
#include <locale.h>
#include <glib/gstdio.h>
#include <cheese-config.h>


#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GeeArrayList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_effects_manager_parent_class = NULL;

#define GROUP_NAME "Cheese Effect"
GType cheese_effects_manager_get_type (void);
enum  {
	CHEESE_EFFECTS_MANAGER_DUMMY_PROPERTY
};
CheeseEffect* cheese_effects_manager_parse_effect_file (const char* filename);
static GeeArrayList* cheese_effects_manager_load_effects_from_directory (CheeseEffectsManager* self, const char* directory);
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const char* name);
static void cheese_effects_manager_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



CheeseEffect* cheese_effects_manager_parse_effect_file (const char* filename) {
	CheeseEffect* result = NULL;
	GError * _inner_error_;
	GKeyFile* kf;
	CheeseEffect* eff;
	char* locale;
	char* _tmp7_;
	char* _tmp5_;
	char* _tmp4_ = NULL;
	char* _tmp6_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	_inner_error_ = NULL;
	kf = g_key_file_new ();
	eff = cheese_effect_new ();
	locale = g_strdup (setlocale (LC_ALL, ""));
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		g_key_file_load_from_file (kf, filename, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch6_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch6_g_file_error;
			}
			_g_key_file_free0 (kf);
			_g_object_unref0 (eff);
			_g_free0 (locale);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp0_ = g_key_file_get_locale_string (kf, GROUP_NAME, "Name", locale, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch6_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch6_g_file_error;
			}
			_g_key_file_free0 (kf);
			_g_object_unref0 (eff);
			_g_free0 (locale);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		g_object_set (eff, "name", _tmp1_ = _tmp0_, NULL);
		_g_free0 (_tmp1_);
		_tmp2_ = g_key_file_get_string (kf, GROUP_NAME, "PipelineDescription", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch6_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch6_g_file_error;
			}
			_g_key_file_free0 (kf);
			_g_object_unref0 (eff);
			_g_free0 (locale);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		g_object_set (eff, "pipeline-desc", _tmp3_ = _tmp2_, NULL);
		_g_free0 (_tmp3_);
	}
	goto __finally6;
	__catch6_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("cheese-effects-manager.vala:43: Error: %s\n", err->message);
			result = NULL;
			_g_error_free0 (err);
			_g_key_file_free0 (kf);
			_g_object_unref0 (eff);
			_g_free0 (locale);
			return result;
		}
	}
	goto __finally6;
	__catch6_g_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("cheese-effects-manager.vala:48: Error: %s\n", err->message);
			result = NULL;
			_g_error_free0 (err);
			_g_key_file_free0 (kf);
			_g_object_unref0 (eff);
			_g_free0 (locale);
			return result;
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (kf);
		_g_object_unref0 (eff);
		_g_free0 (locale);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	g_message ("cheese-effects-manager.vala:52: Found %s (%s)", _tmp5_ = (g_object_get (eff, "name", &_tmp4_, NULL), _tmp4_), _tmp7_ = (g_object_get (eff, "pipeline-desc", &_tmp6_, NULL), _tmp6_));
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	result = eff;
	_g_key_file_free0 (kf);
	_g_free0 (locale);
	return result;
}


static GeeArrayList* cheese_effects_manager_load_effects_from_directory (CheeseEffectsManager* self, const char* directory) {
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	GeeArrayList* effects;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	_inner_error_ = NULL;
	effects = gee_array_list_new (CHEESE_TYPE_EFFECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	if (g_file_test (directory, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)) {
		GDir* dir;
		char* cur_file;
		char* _tmp2_;
		dir = NULL;
		cur_file = NULL;
		{
			GDir* _tmp0_;
			GDir* _tmp1_;
			_tmp0_ = g_dir_open (directory, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch7_g_file_error;
				}
				_g_dir_close0 (dir);
				_g_free0 (cur_file);
				_g_object_unref0 (effects);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			dir = (_tmp1_ = _tmp0_, _g_dir_close0 (dir), _tmp1_);
		}
		goto __finally7;
		__catch7_g_file_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("cheese-effects-manager.vala:71: Error: %s\n", err->message);
				result = NULL;
				_g_error_free0 (err);
				_g_dir_close0 (dir);
				_g_free0 (cur_file);
				_g_object_unref0 (effects);
				return result;
			}
		}
		__finally7:
		if (_inner_error_ != NULL) {
			_g_dir_close0 (dir);
			_g_free0 (cur_file);
			_g_object_unref0 (effects);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		cur_file = (_tmp2_ = g_strdup (g_dir_read_name (dir)), _g_free0 (cur_file), _tmp2_);
		while (TRUE) {
			char* _tmp5_;
			if (!(cur_file != NULL)) {
				break;
			}
			if (g_str_has_suffix (cur_file, ".effect")) {
				char* _tmp3_;
				CheeseEffect* _tmp4_;
				CheeseEffect* effect;
				effect = (_tmp4_ = cheese_effects_manager_parse_effect_file (_tmp3_ = g_build_filename (directory, cur_file, NULL)), _g_free0 (_tmp3_), _tmp4_);
				gee_abstract_collection_add ((GeeAbstractCollection*) effects, effect);
				_g_object_unref0 (effect);
			}
			cur_file = (_tmp5_ = g_strdup (g_dir_read_name (dir)), _g_free0 (cur_file), _tmp5_);
		}
		_g_dir_close0 (dir);
		_g_free0 (cur_file);
	}
	result = effects;
	return result;
}


CheeseEffectsManager* cheese_effects_manager_construct (GType object_type) {
	CheeseEffectsManager * self;
	GeeArrayList* _tmp0_;
	self = (CheeseEffectsManager*) g_object_new (object_type, NULL);
	self->effects = (_tmp0_ = gee_array_list_new (CHEESE_TYPE_EFFECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->effects), _tmp0_);
	return self;
}


CheeseEffectsManager* cheese_effects_manager_new (void) {
	return cheese_effects_manager_construct (CHEESE_TYPE_EFFECTS_MANAGER);
}


void cheese_effects_manager_load_effects (CheeseEffectsManager* self) {
	char* system_effects;
	GeeArrayList* _tmp0_;
	char* user_effects;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	system_effects = g_build_filename (PACKAGE_DATADIR, "effects", NULL);
	gee_abstract_collection_add_all ((GeeAbstractCollection*) self->effects, (GeeCollection*) (_tmp0_ = cheese_effects_manager_load_effects_from_directory (self, system_effects)));
	_g_object_unref0 (_tmp0_);
	user_effects = g_build_filename (g_get_user_data_dir (), ".cheese", "effects", NULL);
	gee_abstract_collection_add_all ((GeeAbstractCollection*) self->effects, (GeeCollection*) (_tmp1_ = cheese_effects_manager_load_effects_from_directory (self, user_effects)));
	_g_object_unref0 (_tmp1_);
	{
		GeeIterator* _e_it;
		_e_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->effects);
		while (TRUE) {
			CheeseEffect* e;
			char* _tmp3_;
			char* _tmp2_ = NULL;
			gboolean _tmp4_;
			if (!gee_iterator_next (_e_it)) {
				break;
			}
			e = (CheeseEffect*) gee_iterator_get (_e_it);
			if ((_tmp4_ = _vala_strcmp0 (_tmp3_ = (g_object_get (e, "pipeline-desc", &_tmp2_, NULL), _tmp2_), "identity") == 0, _g_free0 (_tmp3_), _tmp4_)) {
				gee_abstract_collection_remove ((GeeAbstractCollection*) self->effects, e);
				gee_abstract_list_insert ((GeeAbstractList*) self->effects, 0, e);
				_g_object_unref0 (e);
				break;
			}
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
	_g_free0 (system_effects);
	_g_free0 (user_effects);
}


CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const char* name) {
	CheeseEffect* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GeeIterator* _eff_it;
		_eff_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->effects);
		while (TRUE) {
			CheeseEffect* eff;
			char* _tmp1_;
			char* _tmp0_ = NULL;
			gboolean _tmp2_;
			if (!gee_iterator_next (_eff_it)) {
				break;
			}
			eff = (CheeseEffect*) gee_iterator_get (_eff_it);
			if ((_tmp2_ = _vala_strcmp0 (_tmp1_ = (g_object_get (eff, "name", &_tmp0_, NULL), _tmp0_), name) == 0, _g_free0 (_tmp1_), _tmp2_)) {
				result = eff;
				_g_object_unref0 (_eff_it);
				return result;
			}
			_g_object_unref0 (eff);
		}
		_g_object_unref0 (_eff_it);
	}
	result = NULL;
	return result;
}


static void cheese_effects_manager_class_init (CheeseEffectsManagerClass * klass) {
	cheese_effects_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = cheese_effects_manager_finalize;
}


static void cheese_effects_manager_instance_init (CheeseEffectsManager * self) {
}


static void cheese_effects_manager_finalize (GObject* obj) {
	CheeseEffectsManager * self;
	self = CHEESE_EFFECTS_MANAGER (obj);
	_g_object_unref0 (self->effects);
	G_OBJECT_CLASS (cheese_effects_manager_parent_class)->finalize (obj);
}


GType cheese_effects_manager_get_type (void) {
	static volatile gsize cheese_effects_manager_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_effects_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseEffectsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_effects_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseEffectsManager), 0, (GInstanceInitFunc) cheese_effects_manager_instance_init, NULL };
		GType cheese_effects_manager_type_id;
		cheese_effects_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "CheeseEffectsManager", &g_define_type_info, 0);
		g_once_init_leave (&cheese_effects_manager_type_id__volatile, cheese_effects_manager_type_id);
	}
	return cheese_effects_manager_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




