/* rygel-http-item-uri-test.c generated by valac, the Vala compiler
 * generated from rygel-http-item-uri-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_ITEM_URI_TEST (rygel_http_item_uri_test_get_type ())
#define RYGEL_HTTP_ITEM_URI_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITest))
#define RYGEL_HTTP_ITEM_URI_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestClass))
#define RYGEL_IS_HTTP_ITEM_URI_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST))
#define RYGEL_IS_HTTP_ITEM_URI_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI_TEST))
#define RYGEL_HTTP_ITEM_URI_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestClass))

typedef struct _RygelHTTPItemURITest RygelHTTPItemURITest;
typedef struct _RygelHTTPItemURITestClass RygelHTTPItemURITestClass;
typedef struct _RygelHTTPItemURITestPrivate RygelHTTPItemURITestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelHTTPServerPrivate {
	char* _path_root;
};

struct _RygelHTTPItemURITest {
	GObject parent_instance;
	RygelHTTPItemURITestPrivate * priv;
};

struct _RygelHTTPItemURITestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPItemURITestPrivate {
	RygelHTTPServer* server;
};


static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_item_uri_test_parent_class = NULL;

GQuark rygel_http_request_error_quark (void);
GQuark rygel_test_error_quark (void);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerPrivate))
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
static void rygel_http_server_set_path_root (RygelHTTPServer* self, const char* value);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
const char* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_finalize (GObject* obj);
static void rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_http_item_uri_test_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_ITEM_URI_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestPrivate))
enum  {
	RYGEL_HTTP_ITEM_URI_TEST_DUMMY_PROPERTY
};
#define RYGEL_HTTP_ITEM_URI_TEST_ITEM_ID "HELLO"
#define RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX 1
#define RYGEL_HTTP_ITEM_URI_TEST_SUBTITLE_INDEX 1
#define RYGEL_HTTP_ITEM_URI_TEST_TRANSCODE_TARGET "MP3"
static RygelHTTPItemURITest* rygel_http_item_uri_test_new (GError** error);
static RygelHTTPItemURITest* rygel_http_item_uri_test_construct (GType object_type, GError** error);
void rygel_http_item_uri_test_run (RygelHTTPItemURITest* self, GError** error);
gint rygel_http_item_uri_test_main (char** args, int args_length1);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_thumbnail (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_subtitle (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_transcoder (RygelHTTPItemURITest* self);
static char* rygel_http_item_uri_test_test_to_string (RygelHTTPItemURITest* self, RygelHTTPItemURI* uri);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_from_string (RygelHTTPItemURITest* self, const char* str, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_new (const char* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const char* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const char* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const char* uri, RygelHTTPServer* http_server, GError** error);
char* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_item_uri_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


#line 41 "rygel-http-item-uri-test.vala"
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
#line 173 "rygel-http-item-uri-test.c"
	GError * _inner_error_;
	RygelHTTPServer * self;
	_inner_error_ = NULL;
#line 41 "rygel-http-item-uri-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 42 "rygel-http-item-uri-test.vala"
	rygel_http_server_set_path_root (self, RYGEL_HTTP_SERVER_SERVER_PATH);
#line 181 "rygel-http-item-uri-test.c"
	{
		GUPnPContext* _tmp0_;
		GUPnPContext* _tmp1_;
#line 45 "rygel-http-item-uri-test.vala"
		_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 187 "rygel-http-item-uri-test.c"
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
#line 45 "rygel-http-item-uri-test.vala"
		self->context = (_tmp1_ = _tmp0_, _g_object_unref0 (self->context), _tmp1_);
#line 193 "rygel-http-item-uri-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
			{
				_g_error_free0 (_error_);
				goto __finally0;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 50 "rygel-http-item-uri-test.vala"
	g_assert (self->context != NULL);
#line 51 "rygel-http-item-uri-test.vala"
	g_assert (gssdp_client_get_host_ip ((GSSDPClient*) self->context) != NULL);
#line 52 "rygel-http-item-uri-test.vala"
	g_assert (gupnp_context_get_port (self->context) > 0);
#line 228 "rygel-http-item-uri-test.c"
	return self;
}


#line 41 "rygel-http-item-uri-test.vala"
RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 41 "rygel-http-item-uri-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 237 "rygel-http-item-uri-test.c"
}


const char* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_path_root;
#line 37 "rygel-http-item-uri-test.vala"
	return result;
#line 247 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_set_path_root (RygelHTTPServer* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_path_root = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_path_root), _tmp0_);
	g_object_notify ((GObject *) self, "path-root");
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPServerPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_http_server_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
	self->priv = RYGEL_HTTP_SERVER_GET_PRIVATE (self);
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (obj);
	_g_free0 (self->priv->_path_root);
	_g_object_unref0 (self->context);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		g_value_set_string (value, rygel_http_server_get_path_root (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		rygel_http_server_set_path_root (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 64 "rygel-http-item-uri-test.vala"
gint rygel_http_item_uri_test_main (char** args, int args_length1) {
#line 325 "rygel-http-item-uri-test.c"
	gint result = 0;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		RygelHTTPItemURITest* test;
#line 66 "rygel-http-item-uri-test.vala"
		test = rygel_http_item_uri_test_new (&_inner_error_);
#line 333 "rygel-http-item-uri-test.c"
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch1_rygel_test_error_skip;
			}
			goto __catch1_g_error;
		}
#line 68 "rygel-http-item-uri-test.vala"
		rygel_http_item_uri_test_run (test, &_inner_error_);
#line 342 "rygel-http-item-uri-test.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (test);
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch1_rygel_test_error_skip;
			}
			goto __catch1_g_error;
		}
		_g_object_unref0 (test);
	}
	goto __finally1;
	__catch1_rygel_test_error_skip:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			result = 77;
			_g_error_free0 (_error_);
#line 70 "rygel-http-item-uri-test.vala"
			return result;
#line 363 "rygel-http-item-uri-test.c"
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 72 "rygel-http-item-uri-test.vala"
			g_critical ("rygel-http-item-uri-test.vala:72: %s", _error_->message);
#line 375 "rygel-http-item-uri-test.c"
			result = -1;
			_g_error_free0 (_error_);
#line 74 "rygel-http-item-uri-test.vala"
			return result;
#line 380 "rygel-http-item-uri-test.c"
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
#line 77 "rygel-http-item-uri-test.vala"
	return result;
#line 392 "rygel-http-item-uri-test.c"
}


#line 64 "rygel-http-item-uri-test.vala"
int main (int argc, char ** argv) {
#line 398 "rygel-http-item-uri-test.c"
	g_thread_init (NULL);
#line 64 "rygel-http-item-uri-test.vala"
	g_type_init ();
#line 64 "rygel-http-item-uri-test.vala"
	return rygel_http_item_uri_test_main (argv, argc);
#line 404 "rygel-http-item-uri-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 80 "rygel-http-item-uri-test.vala"
void rygel_http_item_uri_test_run (RygelHTTPItemURITest* self, GError** error) {
#line 415 "rygel-http-item-uri-test.c"
	GError * _inner_error_;
	RygelHTTPItemURI** _tmp1_;
	gint _uris_size_;
	gint uris_length1;
	RygelHTTPItemURI** _tmp0_ = NULL;
	RygelHTTPItemURI** uris;
#line 80 "rygel-http-item-uri-test.vala"
	g_return_if_fail (self != NULL);
#line 424 "rygel-http-item-uri-test.c"
	_inner_error_ = NULL;
	uris = (_tmp1_ = (_tmp0_ = g_new0 (RygelHTTPItemURI*, 4 + 1), _tmp0_[0] = rygel_http_item_uri_test_test_construction (self), _tmp0_[1] = rygel_http_item_uri_test_test_construction_with_thumbnail (self), _tmp0_[2] = rygel_http_item_uri_test_test_construction_with_subtitle (self), _tmp0_[3] = rygel_http_item_uri_test_test_construction_with_transcoder (self), _tmp0_), uris_length1 = 4, _uris_size_ = uris_length1, _tmp1_);
	{
		RygelHTTPItemURI** uri_collection;
		int uri_collection_length1;
		int uri_it;
#line 87 "rygel-http-item-uri-test.vala"
		uri_collection = uris;
#line 433 "rygel-http-item-uri-test.c"
		uri_collection_length1 = uris_length1;
		for (uri_it = 0; uri_it < uris_length1; uri_it = uri_it + 1) {
			RygelHTTPItemURI* uri;
			uri = _g_object_ref0 (uri_collection[uri_it]);
			{
				char* str;
				RygelHTTPItemURI* _tmp2_;
#line 88 "rygel-http-item-uri-test.vala"
				str = rygel_http_item_uri_test_test_to_string (self, uri);
#line 89 "rygel-http-item-uri-test.vala"
				_tmp2_ = rygel_http_item_uri_test_test_construction_from_string (self, str, &_inner_error_);
#line 445 "rygel-http-item-uri-test.c"
				_g_object_unref0 (_tmp2_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (str);
					_g_object_unref0 (uri);
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_object_unref), NULL);
					return;
				}
				_g_free0 (str);
				_g_object_unref0 (uri);
			}
		}
	}
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_object_unref), NULL);
}


#line 93 "rygel-http-item-uri-test.vala"
static RygelHTTPItemURITest* rygel_http_item_uri_test_construct (GType object_type, GError** error) {
#line 465 "rygel-http-item-uri-test.c"
	GError * _inner_error_;
	RygelHTTPItemURITest * self;
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	_inner_error_ = NULL;
#line 93 "rygel-http-item-uri-test.vala"
	self = (RygelHTTPItemURITest*) g_object_new (object_type, NULL);
#line 94 "rygel-http-item-uri-test.vala"
	_tmp0_ = rygel_http_server_new (&_inner_error_);
#line 475 "rygel-http-item-uri-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 94 "rygel-http-item-uri-test.vala"
	self->priv->server = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->server), _tmp1_);
#line 489 "rygel-http-item-uri-test.c"
	return self;
}


#line 93 "rygel-http-item-uri-test.vala"
static RygelHTTPItemURITest* rygel_http_item_uri_test_new (GError** error) {
#line 93 "rygel-http-item-uri-test.vala"
	return rygel_http_item_uri_test_construct (RYGEL_TYPE_HTTP_ITEM_URI_TEST, error);
#line 498 "rygel-http-item-uri-test.c"
}


#line 97 "rygel-http-item-uri-test.vala"
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction (RygelHTTPItemURITest* self) {
#line 504 "rygel-http-item-uri-test.c"
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri;
#line 97 "rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 98 "rygel-http-item-uri-test.vala"
	uri = rygel_http_item_uri_new (RYGEL_HTTP_ITEM_URI_TEST_ITEM_ID, self->priv->server, -1, -1, NULL);
#line 99 "rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 513 "rygel-http-item-uri-test.c"
	result = uri;
#line 101 "rygel-http-item-uri-test.vala"
	return result;
#line 517 "rygel-http-item-uri-test.c"
}


#line 104 "rygel-http-item-uri-test.vala"
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_subtitle (RygelHTTPItemURITest* self) {
#line 523 "rygel-http-item-uri-test.c"
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri;
#line 104 "rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 105 "rygel-http-item-uri-test.vala"
	uri = rygel_http_item_uri_new (RYGEL_HTTP_ITEM_URI_TEST_ITEM_ID, self->priv->server, RYGEL_HTTP_ITEM_URI_TEST_SUBTITLE_INDEX, -1, NULL);
#line 108 "rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 532 "rygel-http-item-uri-test.c"
	result = uri;
#line 110 "rygel-http-item-uri-test.vala"
	return result;
#line 536 "rygel-http-item-uri-test.c"
}


#line 113 "rygel-http-item-uri-test.vala"
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_thumbnail (RygelHTTPItemURITest* self) {
#line 542 "rygel-http-item-uri-test.c"
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri;
#line 113 "rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 114 "rygel-http-item-uri-test.vala"
	uri = rygel_http_item_uri_new (RYGEL_HTTP_ITEM_URI_TEST_ITEM_ID, self->priv->server, RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX, -1, NULL);
#line 117 "rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 551 "rygel-http-item-uri-test.c"
	result = uri;
#line 119 "rygel-http-item-uri-test.vala"
	return result;
#line 555 "rygel-http-item-uri-test.c"
}


#line 122 "rygel-http-item-uri-test.vala"
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_transcoder (RygelHTTPItemURITest* self) {
#line 561 "rygel-http-item-uri-test.c"
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri;
#line 122 "rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 123 "rygel-http-item-uri-test.vala"
	uri = rygel_http_item_uri_new (RYGEL_HTTP_ITEM_URI_TEST_ITEM_ID, self->priv->server, RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX, -1, RYGEL_HTTP_ITEM_URI_TEST_TRANSCODE_TARGET);
#line 128 "rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 570 "rygel-http-item-uri-test.c"
	result = uri;
#line 130 "rygel-http-item-uri-test.vala"
	return result;
#line 574 "rygel-http-item-uri-test.c"
}


#line 133 "rygel-http-item-uri-test.vala"
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_from_string (RygelHTTPItemURITest* self, const char* str, GError** error) {
#line 580 "rygel-http-item-uri-test.c"
	RygelHTTPItemURI* result = NULL;
	GError * _inner_error_;
	RygelHTTPItemURI* uri;
	char* _tmp0_;
#line 133 "rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 133 "rygel-http-item-uri-test.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 589 "rygel-http-item-uri-test.c"
	_inner_error_ = NULL;
#line 135 "rygel-http-item-uri-test.vala"
	uri = rygel_http_item_uri_new_from_string (str, self->priv->server, &_inner_error_);
#line 593 "rygel-http-item-uri-test.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 136 "rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 137 "rygel-http-item-uri-test.vala"
	g_assert (_vala_strcmp0 (_tmp0_ = rygel_http_item_uri_to_string (uri), str) == 0);
#line 602 "rygel-http-item-uri-test.c"
	_g_free0 (_tmp0_);
	result = uri;
#line 139 "rygel-http-item-uri-test.vala"
	return result;
#line 607 "rygel-http-item-uri-test.c"
}


#line 142 "rygel-http-item-uri-test.vala"
static char* rygel_http_item_uri_test_test_to_string (RygelHTTPItemURITest* self, RygelHTTPItemURI* uri) {
#line 613 "rygel-http-item-uri-test.c"
	char* result = NULL;
	char* str;
#line 142 "rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 142 "rygel-http-item-uri-test.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 143 "rygel-http-item-uri-test.vala"
	str = rygel_http_item_uri_to_string (uri);
#line 144 "rygel-http-item-uri-test.vala"
	g_assert (str != NULL);
#line 624 "rygel-http-item-uri-test.c"
	result = str;
#line 146 "rygel-http-item-uri-test.vala"
	return result;
#line 628 "rygel-http-item-uri-test.c"
}


static void rygel_http_item_uri_test_class_init (RygelHTTPItemURITestClass * klass) {
	rygel_http_item_uri_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPItemURITestPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_test_finalize;
}


static void rygel_http_item_uri_test_instance_init (RygelHTTPItemURITest * self) {
	self->priv = RYGEL_HTTP_ITEM_URI_TEST_GET_PRIVATE (self);
}


static void rygel_http_item_uri_test_finalize (GObject* obj) {
	RygelHTTPItemURITest * self;
	self = RYGEL_HTTP_ITEM_URI_TEST (obj);
	_g_object_unref0 (self->priv->server);
	G_OBJECT_CLASS (rygel_http_item_uri_test_parent_class)->finalize (obj);
}


GType rygel_http_item_uri_test_get_type (void) {
	static volatile gsize rygel_http_item_uri_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURITestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURITest), 0, (GInstanceInitFunc) rygel_http_item_uri_test_instance_init, NULL };
		GType rygel_http_item_uri_test_type_id;
		rygel_http_item_uri_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURITest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_test_type_id__volatile, rygel_http_item_uri_test_type_id);
	}
	return rygel_http_item_uri_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




