/* rygel-media-export-harvester.c generated by valac, the Vala compiler
 * generated from rygel-media-export-harvester.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <rygel.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
typedef struct _RygelMediaExportHarvesterPrivate RygelMediaExportHarvesterPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER (rygel_media_export_dummy_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainer))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))

typedef struct _RygelMediaExportDummyContainer RygelMediaExportDummyContainer;
typedef struct _RygelMediaExportDummyContainerClass RygelMediaExportDummyContainerClass;
typedef struct _RygelNullContainerPrivate RygelNullContainerPrivate;
typedef struct _RygelMediaExportDummyContainerPrivate RygelMediaExportDummyContainerPrivate;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _RygelMediaExportHarvesterEnumerateDirectoryData RygelMediaExportHarvesterEnumerateDirectoryData;
typedef struct _RygelMediaExportHarvesterHarvestData RygelMediaExportHarvesterHarvestData;

#define RYGEL_MEDIA_EXPORT_TYPE_ITEM (rygel_media_export_item_get_type ())
#define RYGEL_MEDIA_EXPORT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ITEM, RygelMediaExportItem))
#define RYGEL_MEDIA_EXPORT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ITEM, RygelMediaExportItemClass))
#define RYGEL_MEDIA_EXPORT_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ITEM))
#define RYGEL_MEDIA_EXPORT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ITEM, RygelMediaExportItemClass))

typedef struct _RygelMediaExportItem RygelMediaExportItem;
typedef struct _RygelMediaExportItemClass RygelMediaExportItemClass;

struct _RygelMediaExportHarvester {
	GObject parent_instance;
	RygelMediaExportHarvesterPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelMediaExportHarvesterClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvesterPrivate {
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportMediaCache* media_db;
	GQueue* containers;
	GeeQueue* files;
	GFile* origin;
	RygelMediaContainer* parent;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GRegex* file_filter;
	char* flag;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_DB_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_DB_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_DB_ERROR_UNSUPPORTED_SEARCH
} RygelMediaDBError;
#define RYGEL_MEDIA_DB_ERROR rygel_media_db_error_quark ()
struct _RygelNullContainer {
	RygelMediaContainer parent_instance;
	RygelNullContainerPrivate * priv;
};

struct _RygelNullContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelMediaExportDummyContainer {
	RygelNullContainer parent_instance;
	RygelMediaExportDummyContainerPrivate * priv;
	GFile* file;
	GeeArrayList* seen_children;
};

struct _RygelMediaExportDummyContainerClass {
	RygelNullContainerClass parent_class;
};

struct _RygelMediaExportHarvesterEnumerateDirectoryData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvester* self;
	GFile* directory;
	GFileEnumerator* enumerator;
	GList* list;
	gboolean _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GError * err;
	RygelMediaContainer* _tmp3_;
	GError * _inner_error_;
};

struct _RygelMediaExportHarvesterHarvestData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvester* self;
	GFile* file;
	GFileInfo* info;
	GFile* _tmp0_;
	RygelMediaExportDummyContainer* container;
	gint64 timestamp;
	gboolean _tmp1_;
	char* id;
	GFile* _tmp5_;
	char* _tmp6_;
	char* _tmp4_;
	gboolean _tmp3_;
	char* _tmp2_;
	char* _tmp7_;
	GError * err;
	GError * _inner_error_;
};


static gpointer rygel_media_export_harvester_parent_class = NULL;

GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_HARVESTER_HARVESTER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_SIZE
static void rygel_media_export_harvester_on_extracted_cb (RygelMediaExportHarvester* self, GFile* file, GUPnPDLNAInformation* dlna, const char* mime, guint64 size, guint64 mtime);
static void _rygel_media_export_harvester_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GUPnPDLNAInformation* info, const char* mime, guint64 size, guint64 mtime, gpointer self);
static void rygel_media_export_harvester_on_extractor_error_cb (RygelMediaExportHarvester* self, GFile* file, GError* _error_);
static void _rygel_media_export_harvester_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
RygelMediaExportHarvester* rygel_media_export_harvester_new (RygelMediaContainer* parent, RygelMediaExportMediaCache* media_db, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, const char* flag);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, RygelMediaContainer* parent, RygelMediaExportMediaCache* media_db, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, const char* flag);
GQuark rygel_media_export_database_error_quark (void);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, const char* object_id, gint64* timestamp, GError** error);
GQuark rygel_media_db_error_quark (void);
RygelMediaItem* rygel_media_export_media_cache_get_item (RygelMediaExportMediaCache* self, const char* item_id, GError** error);
static gboolean rygel_media_export_harvester_push_if_changed_or_unknown (RygelMediaExportHarvester* self, GFile* file, GFileInfo* info, char** id);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dummy_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_recursive_file_monitor_monitor (RygelMediaExportRecursiveFileMonitor* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_recursive_file_monitor_monitor_finish (RygelMediaExportRecursiveFileMonitor* self, GAsyncResult* _res_);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_new (GFile* file, RygelMediaContainer* parent);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_construct (GType object_type, GFile* file, RygelMediaContainer* parent);
void rygel_media_export_dummy_container_seen (RygelMediaExportDummyContainer* self, const char* id);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
static gboolean rygel_media_export_harvester_process_children (RygelMediaExportHarvester* self, GList* list);
static void rygel_media_export_harvester_enumerate_directory_data_free (gpointer _data);
static void rygel_media_export_harvester_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_list_free_g_object_unref (GList* self);
static void rygel_media_export_harvester_cleanup_database (RygelMediaExportHarvester* self, RygelMediaExportDummyContainer* container);
static void rygel_media_export_harvester_do_update (RygelMediaExportHarvester* self);
static void rygel_media_export_harvester_enumerate_directory (RygelMediaExportHarvester* self, GFile* directory, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_harvester_enumerate_directory_finish (RygelMediaExportHarvester* self, GAsyncResult* _res_);
static gboolean rygel_media_export_harvester_enumerate_directory_co (RygelMediaExportHarvesterEnumerateDirectoryData* data);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const char* container_id, GError** error);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const char* id, GError** error);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file);
void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, const char* id, const char* flag, GError** error);
char* rygel_media_export_item_get_id (GFile* file);
static gboolean rygel_media_export_harvester_on_idle (RygelMediaExportHarvester* self);
static void rygel_media_export_harvester_harvest_data_free (gpointer _data);
static void rygel_media_export_harvester_harvest_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _rygel_media_export_harvester_on_idle_gsource_func (gpointer self);
void rygel_media_export_harvester_harvest (RygelMediaExportHarvester* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_harvester_harvest_finish (RygelMediaExportHarvester* self, GAsyncResult* _res_);
static gboolean rygel_media_export_harvester_harvest_co (RygelMediaExportHarvesterHarvestData* data);
RygelMediaExportItem* rygel_media_export_item_new_simple (RygelMediaContainer* parent, GFile* file, const char* mime, guint64 size, guint64 mtime);
RygelMediaExportItem* rygel_media_export_item_construct_simple (GType object_type, RygelMediaContainer* parent, GFile* file, const char* mime, guint64 size, guint64 mtime);
GType rygel_media_export_item_get_type (void) G_GNUC_CONST;
RygelMediaExportItem* rygel_media_export_item_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const char* mime, guint64 size, guint64 mtime);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
static void rygel_media_export_harvester_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 296 "rygel-media-export-harvester.vala"
static void _rygel_media_export_harvester_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GUPnPDLNAInformation* info, const char* mime, guint64 size, guint64 mtime, gpointer self) {
#line 280 "rygel-media-export-harvester.c"
	rygel_media_export_harvester_on_extracted_cb (self, file, info, mime, size, mtime);
}


#line 342 "rygel-media-export-harvester.vala"
static void _rygel_media_export_harvester_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self) {
#line 287 "rygel-media-export-harvester.c"
	rygel_media_export_harvester_on_extractor_error_cb (self, file, err);
}


static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


#line 42 "rygel-media-export-harvester.vala"
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, RygelMediaContainer* parent, RygelMediaExportMediaCache* media_db, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, const char* flag) {
#line 304 "rygel-media-export-harvester.c"
	GError * _inner_error_;
	RygelMediaExportHarvester * self;
	RygelMediaContainer* _tmp0_;
	RygelMediaExportMetadataExtractor* _tmp1_;
	RygelMediaExportMediaCache* _tmp2_;
	GeeQueue* _tmp3_;
	GQueue* _tmp4_;
	GFile* _tmp5_;
	RygelMediaExportRecursiveFileMonitor* _tmp6_;
	GCancellable* _tmp7_;
	char* _tmp8_;
	RygelMetaConfig* config;
#line 42 "rygel-media-export-harvester.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 42 "rygel-media-export-harvester.vala"
	g_return_val_if_fail (media_db != NULL, NULL);
#line 42 "rygel-media-export-harvester.vala"
	g_return_val_if_fail (extractor != NULL, NULL);
#line 42 "rygel-media-export-harvester.vala"
	g_return_val_if_fail (monitor != NULL, NULL);
#line 325 "rygel-media-export-harvester.c"
	_inner_error_ = NULL;
#line 42 "rygel-media-export-harvester.vala"
	self = (RygelMediaExportHarvester*) g_object_new (object_type, NULL);
#line 47 "rygel-media-export-harvester.vala"
	self->priv->parent = (_tmp0_ = _g_object_ref0 (parent), _g_object_unref0 (self->priv->parent), _tmp0_);
#line 48 "rygel-media-export-harvester.vala"
	self->priv->extractor = (_tmp1_ = _g_object_ref0 (extractor), _g_object_unref0 (self->priv->extractor), _tmp1_);
#line 49 "rygel-media-export-harvester.vala"
	self->priv->media_db = (_tmp2_ = _g_object_ref0 (media_db), _g_object_unref0 (self->priv->media_db), _tmp2_);
#line 50 "rygel-media-export-harvester.vala"
	g_signal_connect_object (self->priv->extractor, "extraction-done", (GCallback) _rygel_media_export_harvester_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done, self, 0);
#line 51 "rygel-media-export-harvester.vala"
	g_signal_connect_object (self->priv->extractor, "error", (GCallback) _rygel_media_export_harvester_on_extractor_error_cb_rygel_media_export_metadata_extractor_error, self, 0);
#line 52 "rygel-media-export-harvester.vala"
	self->priv->files = (_tmp3_ = (GeeQueue*) gee_linked_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->files), _tmp3_);
#line 53 "rygel-media-export-harvester.vala"
	self->priv->containers = (_tmp4_ = g_queue_new (), _g_queue_free0 (self->priv->containers), _tmp4_);
#line 54 "rygel-media-export-harvester.vala"
	self->priv->origin = (_tmp5_ = NULL, _g_object_unref0 (self->priv->origin), _tmp5_);
#line 55 "rygel-media-export-harvester.vala"
	self->priv->monitor = (_tmp6_ = _g_object_ref0 (monitor), _g_object_unref0 (self->priv->monitor), _tmp6_);
#line 56 "rygel-media-export-harvester.vala"
	self->cancellable = (_tmp7_ = g_cancellable_new (), _g_object_unref0 (self->cancellable), _tmp7_);
#line 57 "rygel-media-export-harvester.vala"
	self->priv->flag = (_tmp8_ = g_strdup (flag), _g_free0 (self->priv->flag), _tmp8_);
#line 58 "rygel-media-export-harvester.vala"
	config = rygel_meta_config_get_default ();
#line 353 "rygel-media-export-harvester.c"
	{
		GeeArrayList* extensions;
		char** _tmp9_;
		gint _escaped_extensions_size_;
		gint escaped_extensions_length1;
		char** escaped_extensions;
		char* list;
		char* _tmp10_;
		GRegex* _tmp11_;
		GRegex* _tmp12_;
		GRegex* _tmp13_;
#line 61 "rygel-media-export-harvester.vala"
		extensions = rygel_configuration_get_string_list ((RygelConfiguration*) config, "MediaExport", "include-filter", &_inner_error_);
#line 367 "rygel-media-export-harvester.c"
		if (_inner_error_ != NULL) {
			goto __catch38_g_error;
		}
		escaped_extensions = (_tmp9_ = g_new0 (char*, 0 + 1), escaped_extensions_length1 = 0, _escaped_extensions_size_ = escaped_extensions_length1, _tmp9_);
		{
			GeeIterator* _extension_it;
#line 66 "rygel-media-export-harvester.vala"
			_extension_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) extensions);
#line 66 "rygel-media-export-harvester.vala"
			while (TRUE) {
#line 378 "rygel-media-export-harvester.c"
				char* extension;
#line 66 "rygel-media-export-harvester.vala"
				if (!gee_iterator_next (_extension_it)) {
#line 66 "rygel-media-export-harvester.vala"
					break;
#line 384 "rygel-media-export-harvester.c"
				}
#line 66 "rygel-media-export-harvester.vala"
				extension = (char*) gee_iterator_get (_extension_it);
#line 67 "rygel-media-export-harvester.vala"
				_vala_array_add1 (&escaped_extensions, &escaped_extensions_length1, &_escaped_extensions_size_, g_regex_escape_string (extension, -1));
#line 390 "rygel-media-export-harvester.c"
				_g_free0 (extension);
			}
			_g_object_unref0 (_extension_it);
		}
#line 70 "rygel-media-export-harvester.vala"
		list = g_strjoinv ("|", escaped_extensions);
#line 71 "rygel-media-export-harvester.vala"
		_tmp12_ = (_tmp11_ = g_regex_new (_tmp10_ = g_strdup_printf ("(%s)$", list), G_REGEX_CASELESS | G_REGEX_OPTIMIZE, 0, &_inner_error_), _g_free0 (_tmp10_), _tmp11_);
#line 399 "rygel-media-export-harvester.c"
		if (_inner_error_ != NULL) {
			_g_free0 (list);
			escaped_extensions = (_vala_array_free (escaped_extensions, escaped_extensions_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (extensions);
			goto __catch38_g_error;
		}
#line 71 "rygel-media-export-harvester.vala"
		self->priv->file_filter = (_tmp13_ = _tmp12_, _g_regex_unref0 (self->priv->file_filter), _tmp13_);
#line 408 "rygel-media-export-harvester.c"
		_g_free0 (list);
		escaped_extensions = (_vala_array_free (escaped_extensions, escaped_extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (extensions);
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			GRegex* _tmp14_;
#line 75 "rygel-media-export-harvester.vala"
			self->priv->file_filter = (_tmp14_ = NULL, _g_regex_unref0 (self->priv->file_filter), _tmp14_);
#line 423 "rygel-media-export-harvester.c"
			_g_error_free0 (_error_);
		}
	}
	__finally38:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (config);
	return self;
}


#line 42 "rygel-media-export-harvester.vala"
RygelMediaExportHarvester* rygel_media_export_harvester_new (RygelMediaContainer* parent, RygelMediaExportMediaCache* media_db, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, const char* flag) {
#line 42 "rygel-media-export-harvester.vala"
	return rygel_media_export_harvester_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, parent, media_db, extractor, monitor, flag);
#line 443 "rygel-media-export-harvester.c"
}


#line 79 "rygel-media-export-harvester.vala"
static gboolean rygel_media_export_harvester_push_if_changed_or_unknown (RygelMediaExportHarvester* self, GFile* file, GFileInfo* info, char** id) {
#line 449 "rygel-media-export-harvester.c"
	gboolean result = FALSE;
	GError * _inner_error_;
	char* _tmp1_;
	char* _tmp0_;
	gint64 timestamp = 0LL;
#line 79 "rygel-media-export-harvester.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 79 "rygel-media-export-harvester.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 79 "rygel-media-export-harvester.vala"
	g_return_val_if_fail (info != NULL, FALSE);
#line 461 "rygel-media-export-harvester.c"
	if (id != NULL) {
		*id = NULL;
	}
	_inner_error_ = NULL;
#line 82 "rygel-media-export-harvester.vala"
	*id = (_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_ = g_file_get_uri (file), -1), _g_free0 (*id), _tmp1_);
#line 468 "rygel-media-export-harvester.c"
	_g_free0 (_tmp0_);
	{
		gboolean _tmp2_;
#line 85 "rygel-media-export-harvester.vala"
		_tmp2_ = rygel_media_export_media_cache_exists (self->priv->media_db, *id, &timestamp, &_inner_error_);
#line 474 "rygel-media-export-harvester.c"
		if (_inner_error_ != NULL) {
			goto __catch39_g_error;
		}
#line 85 "rygel-media-export-harvester.vala"
		if (_tmp2_) {
#line 480 "rygel-media-export-harvester.c"
			gint64 mtime;
#line 86 "rygel-media-export-harvester.vala"
			mtime = (gint64) g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 89 "rygel-media-export-harvester.vala"
			if (mtime > timestamp) {
#line 90 "rygel-media-export-harvester.vala"
				gee_queue_offer (self->priv->files, file);
#line 488 "rygel-media-export-harvester.c"
				result = TRUE;
#line 92 "rygel-media-export-harvester.vala"
				return result;
#line 492 "rygel-media-export-harvester.c"
			} else {
				gint64 size;
				RygelMediaItem* item;
#line 95 "rygel-media-export-harvester.vala"
				size = g_file_info_get_size (info);
#line 96 "rygel-media-export-harvester.vala"
				item = rygel_media_export_media_cache_get_item (self->priv->media_db, *id, &_inner_error_);
#line 500 "rygel-media-export-harvester.c"
				if (_inner_error_ != NULL) {
					goto __catch39_g_error;
				}
#line 97 "rygel-media-export-harvester.vala"
				if (item->size != size) {
#line 98 "rygel-media-export-harvester.vala"
					gee_queue_offer (self->priv->files, file);
#line 508 "rygel-media-export-harvester.c"
					result = TRUE;
					_g_object_unref0 (item);
#line 100 "rygel-media-export-harvester.vala"
					return result;
#line 513 "rygel-media-export-harvester.c"
				}
				_g_object_unref0 (item);
			}
		} else {
#line 104 "rygel-media-export-harvester.vala"
			gee_queue_offer (self->priv->files, file);
#line 520 "rygel-media-export-harvester.c"
			result = TRUE;
#line 106 "rygel-media-export-harvester.vala"
			return result;
#line 524 "rygel-media-export-harvester.c"
		}
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 109 "rygel-media-export-harvester.vala"
			g_warning (_ ("Failed to query database: %s"), _error_->message);
#line 536 "rygel-media-export-harvester.c"
			_g_error_free0 (_error_);
		}
	}
	__finally39:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
#line 112 "rygel-media-export-harvester.vala"
	return result;
#line 549 "rygel-media-export-harvester.c"
}


#line 115 "rygel-media-export-harvester.vala"
static gboolean rygel_media_export_harvester_process_children (RygelMediaExportHarvester* self, GList* list) {
#line 555 "rygel-media-export-harvester.c"
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_ = FALSE;
#line 115 "rygel-media-export-harvester.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 561 "rygel-media-export-harvester.c"
	_inner_error_ = NULL;
#line 116 "rygel-media-export-harvester.vala"
	if (list == NULL) {
#line 116 "rygel-media-export-harvester.vala"
		_tmp0_ = TRUE;
#line 567 "rygel-media-export-harvester.c"
	} else {
#line 116 "rygel-media-export-harvester.vala"
		_tmp0_ = g_cancellable_is_cancelled (self->cancellable);
#line 571 "rygel-media-export-harvester.c"
	}
#line 116 "rygel-media-export-harvester.vala"
	if (_tmp0_) {
#line 575 "rygel-media-export-harvester.c"
		result = FALSE;
#line 117 "rygel-media-export-harvester.vala"
		return result;
#line 579 "rygel-media-export-harvester.c"
	}
	{
		GList* info_collection;
		GList* info_it;
#line 120 "rygel-media-export-harvester.vala"
		info_collection = list;
#line 586 "rygel-media-export-harvester.c"
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GFileInfo* info;
#line 120 "rygel-media-export-harvester.vala"
			info = _g_object_ref0 ((GFileInfo*) info_it->data);
#line 591 "rygel-media-export-harvester.c"
			{
				RygelMediaExportDummyContainer* parent_container;
				GFile* dir;
				GFile* file;
#line 121 "rygel-media-export-harvester.vala"
				if (g_utf8_get_char (g_utf8_offset_to_pointer (g_file_info_get_name (info), 0)) == '.') {
#line 598 "rygel-media-export-harvester.c"
					_g_object_unref0 (info);
#line 122 "rygel-media-export-harvester.vala"
					continue;
#line 602 "rygel-media-export-harvester.c"
				}
#line 125 "rygel-media-export-harvester.vala"
				parent_container = _g_object_ref0 (RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER ((RygelMediaContainer*) g_queue_peek_head (self->priv->containers)));
#line 127 "rygel-media-export-harvester.vala"
				dir = _g_object_ref0 (parent_container->file);
#line 128 "rygel-media-export-harvester.vala"
				file = g_file_get_child (dir, g_file_info_get_name (info));
#line 129 "rygel-media-export-harvester.vala"
				if (g_file_info_get_file_type (info) == G_FILE_TYPE_DIRECTORY) {
#line 612 "rygel-media-export-harvester.c"
					RygelMediaExportDummyContainer* container;
#line 130 "rygel-media-export-harvester.vala"
					rygel_media_export_recursive_file_monitor_monitor (self->priv->monitor, file, NULL, NULL);
#line 131 "rygel-media-export-harvester.vala"
					container = rygel_media_export_dummy_container_new (file, (RygelMediaContainer*) parent_container);
#line 133 "rygel-media-export-harvester.vala"
					g_queue_push_tail (self->priv->containers, _g_object_ref0 ((RygelMediaContainer*) container));
#line 134 "rygel-media-export-harvester.vala"
					rygel_media_export_dummy_container_seen (parent_container, ((RygelMediaObject*) container)->id);
#line 622 "rygel-media-export-harvester.c"
					{
						gint64 timestamp = 0LL;
						gboolean _tmp1_;
#line 137 "rygel-media-export-harvester.vala"
						_tmp1_ = rygel_media_export_media_cache_exists (self->priv->media_db, ((RygelMediaObject*) container)->id, &timestamp, &_inner_error_);
#line 628 "rygel-media-export-harvester.c"
						if (_inner_error_ != NULL) {
							goto __catch40_g_error;
						}
#line 137 "rygel-media-export-harvester.vala"
						if (!_tmp1_) {
#line 139 "rygel-media-export-harvester.vala"
							rygel_media_export_media_cache_save_container (self->priv->media_db, (RygelMediaContainer*) container, &_inner_error_);
#line 636 "rygel-media-export-harvester.c"
							if (_inner_error_ != NULL) {
								goto __catch40_g_error;
							}
						}
					}
					goto __finally40;
					__catch40_g_error:
					{
						GError * err;
						err = _inner_error_;
						_inner_error_ = NULL;
						{
#line 142 "rygel-media-export-harvester.vala"
							g_warning (_ ("Failed to update database: %s"), err->message);
#line 651 "rygel-media-export-harvester.c"
							_g_error_free0 (err);
						}
					}
					__finally40:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (container);
						_g_object_unref0 (file);
						_g_object_unref0 (dir);
						_g_object_unref0 (parent_container);
						_g_object_unref0 (info);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					_g_object_unref0 (container);
				} else {
					char* id;
					gboolean _tmp2_ = FALSE;
					char* _tmp5_;
					char* _tmp4_ = NULL;
					id = NULL;
#line 148 "rygel-media-export-harvester.vala"
					if (self->priv->file_filter != NULL) {
#line 675 "rygel-media-export-harvester.c"
						char* _tmp3_;
#line 149 "rygel-media-export-harvester.vala"
						_tmp2_ = !g_regex_match (self->priv->file_filter, _tmp3_ = g_file_get_uri (file), 0, NULL);
#line 679 "rygel-media-export-harvester.c"
						_g_free0 (_tmp3_);
					} else {
#line 148 "rygel-media-export-harvester.vala"
						_tmp2_ = FALSE;
#line 684 "rygel-media-export-harvester.c"
					}
#line 148 "rygel-media-export-harvester.vala"
					if (_tmp2_) {
#line 688 "rygel-media-export-harvester.c"
						_g_free0 (id);
						_g_object_unref0 (file);
						_g_object_unref0 (dir);
						_g_object_unref0 (parent_container);
						_g_object_unref0 (info);
#line 150 "rygel-media-export-harvester.vala"
						continue;
#line 696 "rygel-media-export-harvester.c"
					}
#line 153 "rygel-media-export-harvester.vala"
					rygel_media_export_harvester_push_if_changed_or_unknown (self, file, info, &_tmp4_);
#line 153 "rygel-media-export-harvester.vala"
					id = (_tmp5_ = _tmp4_, _g_free0 (id), _tmp5_);
#line 154 "rygel-media-export-harvester.vala"
					rygel_media_export_dummy_container_seen (parent_container, id);
#line 704 "rygel-media-export-harvester.c"
					_g_free0 (id);
				}
				_g_object_unref0 (file);
				_g_object_unref0 (dir);
				_g_object_unref0 (parent_container);
				_g_object_unref0 (info);
			}
		}
	}
	result = TRUE;
#line 158 "rygel-media-export-harvester.vala"
	return result;
#line 717 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_enumerate_directory_data_free (gpointer _data) {
	RygelMediaExportHarvesterEnumerateDirectoryData* data;
	data = _data;
	_g_object_unref0 (data->directory);
	g_object_unref (data->self);
	g_slice_free (RygelMediaExportHarvesterEnumerateDirectoryData, data);
}


static void rygel_media_export_harvester_enumerate_directory (RygelMediaExportHarvester* self, GFile* directory, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvesterEnumerateDirectoryData* _data_;
	_data_ = g_slice_new0 (RygelMediaExportHarvesterEnumerateDirectoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvester_enumerate_directory);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvester_enumerate_directory_data_free);
	_data_->self = g_object_ref (self);
	_data_->directory = _g_object_ref0 (directory);
	rygel_media_export_harvester_enumerate_directory_co (_data_);
}


static void rygel_media_export_harvester_enumerate_directory_finish (RygelMediaExportHarvester* self, GAsyncResult* _res_) {
	RygelMediaExportHarvesterEnumerateDirectoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_export_harvester_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvesterEnumerateDirectoryData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_export_harvester_enumerate_directory_co (data);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gboolean rygel_media_export_harvester_enumerate_directory_co (RygelMediaExportHarvesterEnumerateDirectoryData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
		case 9:
		goto _state_9;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->_state_ = 7;
			g_file_enumerate_children_async (data->directory, RYGEL_MEDIA_EXPORT_HARVESTER_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, data->self->cancellable, rygel_media_export_harvester_enumerate_directory_ready, data);
			return FALSE;
			_state_7:
			data->enumerator = g_file_enumerate_children_finish (data->directory, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch41_g_error;
			}
			data->list = NULL;
			{
				data->_tmp0_ = TRUE;
#line 170 "rygel-media-export-harvester.vala"
				while (TRUE) {
#line 170 "rygel-media-export-harvester.vala"
					if (!data->_tmp0_) {
#line 174 "rygel-media-export-harvester.vala"
						if (!rygel_media_export_harvester_process_children (data->self, data->list)) {
#line 174 "rygel-media-export-harvester.vala"
							break;
#line 796 "rygel-media-export-harvester.c"
						}
					}
#line 170 "rygel-media-export-harvester.vala"
					data->_tmp0_ = FALSE;
#line 801 "rygel-media-export-harvester.c"
					data->_state_ = 8;
					g_file_enumerator_next_files_async (data->enumerator, 256, G_PRIORITY_DEFAULT, data->self->cancellable, rygel_media_export_harvester_enumerate_directory_ready, data);
					return FALSE;
					_state_8:
					data->_tmp1_ = g_file_enumerator_next_files_finish (data->enumerator, data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						__g_list_free_g_object_unref0 (data->list);
						_g_object_unref0 (data->enumerator);
						goto __catch41_g_error;
					}
#line 171 "rygel-media-export-harvester.vala"
					data->list = (data->_tmp2_ = data->_tmp1_, __g_list_free_g_object_unref0 (data->list), data->_tmp2_);
#line 814 "rygel-media-export-harvester.c"
				}
			}
			data->_state_ = 9;
			g_file_enumerator_close_async (data->enumerator, G_PRIORITY_DEFAULT, data->self->cancellable, rygel_media_export_harvester_enumerate_directory_ready, data);
			return FALSE;
			_state_9:
#line 176 "rygel-media-export-harvester.vala"
			g_file_enumerator_close_finish (data->enumerator, data->_res_, &data->_inner_error_);
#line 823 "rygel-media-export-harvester.c"
			if (data->_inner_error_ != NULL) {
				__g_list_free_g_object_unref0 (data->list);
				_g_object_unref0 (data->enumerator);
				goto __catch41_g_error;
			}
			__g_list_free_g_object_unref0 (data->list);
			_g_object_unref0 (data->enumerator);
		}
		goto __finally41;
		__catch41_g_error:
		{
			data->err = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
#line 178 "rygel-media-export-harvester.vala"
				g_warning (_ ("failed to enumerate folder: %s"), data->err->message);
#line 840 "rygel-media-export-harvester.c"
				_g_error_free0 (data->err);
			}
		}
		__finally41:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
#line 181 "rygel-media-export-harvester.vala"
		rygel_media_export_harvester_cleanup_database (data->self, (data->_tmp3_ = (RygelMediaContainer*) g_queue_peek_head (data->self->priv->containers), RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER (data->_tmp3_) ? ((RygelMediaExportDummyContainer*) data->_tmp3_) : NULL));
#line 182 "rygel-media-export-harvester.vala"
		rygel_media_export_harvester_do_update (data->self);
#line 854 "rygel-media-export-harvester.c"
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 185 "rygel-media-export-harvester.vala"
static void rygel_media_export_harvester_cleanup_database (RygelMediaExportHarvester* self, RygelMediaExportDummyContainer* container) {
#line 870 "rygel-media-export-harvester.c"
	GError * _inner_error_;
#line 185 "rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 185 "rygel-media-export-harvester.vala"
	g_return_if_fail (container != NULL);
#line 876 "rygel-media-export-harvester.c"
	_inner_error_ = NULL;
#line 187 "rygel-media-export-harvester.vala"
	container = RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER ((RygelMediaContainer*) g_queue_peek_head (self->priv->containers));
#line 880 "rygel-media-export-harvester.c"
	{
		GeeArrayList* children;
#line 189 "rygel-media-export-harvester.vala"
		children = rygel_media_export_media_cache_get_child_ids (self->priv->media_db, ((RygelMediaObject*) container)->id, &_inner_error_);
#line 885 "rygel-media-export-harvester.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch42_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		{
			GeeIterator* _seen_id_it;
#line 191 "rygel-media-export-harvester.vala"
			_seen_id_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) container->seen_children);
#line 191 "rygel-media-export-harvester.vala"
			while (TRUE) {
#line 900 "rygel-media-export-harvester.c"
				char* seen_id;
#line 191 "rygel-media-export-harvester.vala"
				if (!gee_iterator_next (_seen_id_it)) {
#line 191 "rygel-media-export-harvester.vala"
					break;
#line 906 "rygel-media-export-harvester.c"
				}
#line 191 "rygel-media-export-harvester.vala"
				seen_id = (char*) gee_iterator_get (_seen_id_it);
#line 192 "rygel-media-export-harvester.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) children, seen_id);
#line 912 "rygel-media-export-harvester.c"
				_g_free0 (seen_id);
			}
			_g_object_unref0 (_seen_id_it);
		}
		{
			GeeIterator* _child_it;
#line 195 "rygel-media-export-harvester.vala"
			_child_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) children);
#line 195 "rygel-media-export-harvester.vala"
			while (TRUE) {
#line 923 "rygel-media-export-harvester.c"
				char* child;
#line 195 "rygel-media-export-harvester.vala"
				if (!gee_iterator_next (_child_it)) {
#line 195 "rygel-media-export-harvester.vala"
					break;
#line 929 "rygel-media-export-harvester.c"
				}
#line 195 "rygel-media-export-harvester.vala"
				child = (char*) gee_iterator_get (_child_it);
#line 196 "rygel-media-export-harvester.vala"
				rygel_media_export_media_cache_remove_by_id (self->priv->media_db, child, &_inner_error_);
#line 935 "rygel-media-export-harvester.c"
				if (_inner_error_ != NULL) {
					_g_free0 (child);
					_g_object_unref0 (_child_it);
					_g_object_unref0 (children);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch42_rygel_media_export_database_error;
					}
					_g_free0 (child);
					_g_object_unref0 (_child_it);
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (child);
			}
			_g_object_unref0 (_child_it);
		}
		_g_object_unref0 (children);
	}
	goto __finally42;
	__catch42_rygel_media_export_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 199 "rygel-media-export-harvester.vala"
			g_warning (_ ("Failed to get children of container %s: %s"), ((RygelMediaObject*) container)->id, err->message);
#line 965 "rygel-media-export-harvester.c"
			_g_error_free0 (err);
		}
	}
	__finally42:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 206 "rygel-media-export-harvester.vala"
static gboolean rygel_media_export_harvester_on_idle (RygelMediaExportHarvester* self) {
#line 980 "rygel-media-export-harvester.c"
	gboolean result = FALSE;
	GError * _inner_error_;
#line 206 "rygel-media-export-harvester.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 985 "rygel-media-export-harvester.c"
	_inner_error_ = NULL;
#line 207 "rygel-media-export-harvester.vala"
	if (g_cancellable_is_cancelled (self->cancellable)) {
#line 989 "rygel-media-export-harvester.c"
		result = FALSE;
#line 208 "rygel-media-export-harvester.vala"
		return result;
#line 993 "rygel-media-export-harvester.c"
	}
#line 211 "rygel-media-export-harvester.vala"
	if (gee_collection_get_size ((GeeCollection*) self->priv->files) > 0) {
#line 997 "rygel-media-export-harvester.c"
		GFile* candidate;
#line 212 "rygel-media-export-harvester.vala"
		candidate = (GFile*) gee_queue_peek (self->priv->files);
#line 213 "rygel-media-export-harvester.vala"
		rygel_media_export_metadata_extractor_extract (self->priv->extractor, candidate);
#line 1003 "rygel-media-export-harvester.c"
		_g_object_unref0 (candidate);
	} else {
#line 214 "rygel-media-export-harvester.vala"
		if (g_queue_get_length (self->priv->containers) > 0) {
#line 1008 "rygel-media-export-harvester.c"
			RygelMediaContainer* _tmp0_;
			RygelMediaExportDummyContainer* container;
			GFile* directory;
#line 215 "rygel-media-export-harvester.vala"
			container = _g_object_ref0 ((_tmp0_ = (RygelMediaContainer*) g_queue_peek_head (self->priv->containers), RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER (_tmp0_) ? ((RygelMediaExportDummyContainer*) _tmp0_) : NULL));
#line 216 "rygel-media-export-harvester.vala"
			directory = _g_object_ref0 (container->file);
#line 217 "rygel-media-export-harvester.vala"
			rygel_media_export_harvester_enumerate_directory (self, directory, NULL, NULL);
#line 1018 "rygel-media-export-harvester.c"
			_g_object_unref0 (directory);
			_g_object_unref0 (container);
		} else {
#line 220 "rygel-media-export-harvester.vala"
			if (self->priv->flag != NULL) {
#line 1024 "rygel-media-export-harvester.c"
				{
					char* _tmp1_;
#line 222 "rygel-media-export-harvester.vala"
					rygel_media_export_media_cache_flag_object (self->priv->media_db, _tmp1_ = rygel_media_export_item_get_id (self->priv->origin), self->priv->flag, &_inner_error_);
#line 1029 "rygel-media-export-harvester.c"
					_g_free0 (_tmp1_);
					if (_inner_error_ != NULL) {
						goto __catch43_g_error;
					}
				}
				goto __finally43;
				__catch43_g_error:
				{
					GError * _error_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					{
						_g_error_free0 (_error_);
					}
				}
				__finally43:
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				;
			}
#line 226 "rygel-media-export-harvester.vala"
			g_signal_emit_by_name (self, "harvested", self->priv->origin);
#line 1055 "rygel-media-export-harvester.c"
		}
	}
	result = FALSE;
#line 229 "rygel-media-export-harvester.vala"
	return result;
#line 1061 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_harvest_data_free (gpointer _data) {
	RygelMediaExportHarvesterHarvestData* data;
	data = _data;
	_g_object_unref0 (data->file);
	g_object_unref (data->self);
	g_slice_free (RygelMediaExportHarvesterHarvestData, data);
}


void rygel_media_export_harvester_harvest (RygelMediaExportHarvester* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvesterHarvestData* _data_;
	_data_ = g_slice_new0 (RygelMediaExportHarvesterHarvestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvester_harvest);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvester_harvest_data_free);
	_data_->self = g_object_ref (self);
	_data_->file = _g_object_ref0 (file);
	rygel_media_export_harvester_harvest_co (_data_);
}


void rygel_media_export_harvester_harvest_finish (RygelMediaExportHarvester* self, GAsyncResult* _res_) {
	RygelMediaExportHarvesterHarvestData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_export_harvester_harvest_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvesterHarvestData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_export_harvester_harvest_co (data);
}


#line 206 "rygel-media-export-harvester.vala"
static gboolean _rygel_media_export_harvester_on_idle_gsource_func (gpointer self) {
#line 1101 "rygel-media-export-harvester.c"
	gboolean result;
	result = rygel_media_export_harvester_on_idle (self);
	return result;
}


static gboolean rygel_media_export_harvester_harvest_co (RygelMediaExportHarvesterHarvestData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 10:
		goto _state_10;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
#line 254 "rygel-media-export-harvester.vala"
			g_cancellable_reset (data->self->cancellable);
#line 1122 "rygel-media-export-harvester.c"
			data->_state_ = 10;
			g_file_query_info_async (data->file, RYGEL_MEDIA_EXPORT_HARVESTER_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, data->self->cancellable, rygel_media_export_harvester_harvest_ready, data);
			return FALSE;
			_state_10:
			data->info = g_file_query_info_finish (data->file, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch44_g_error;
			}
#line 261 "rygel-media-export-harvester.vala"
			if (g_file_info_get_file_type (data->info) == G_FILE_TYPE_DIRECTORY) {
#line 262 "rygel-media-export-harvester.vala"
				data->self->priv->origin = (data->_tmp0_ = _g_object_ref0 (data->file), _g_object_unref0 (data->self->priv->origin), data->_tmp0_);
#line 263 "rygel-media-export-harvester.vala"
				rygel_media_export_recursive_file_monitor_monitor (data->self->priv->monitor, data->file, NULL, NULL);
#line 1137 "rygel-media-export-harvester.c"
				data->container = rygel_media_export_dummy_container_new (data->file, data->self->priv->parent);
#line 265 "rygel-media-export-harvester.vala"
				g_queue_push_tail (data->self->priv->containers, _g_object_ref0 ((RygelMediaContainer*) data->container));
#line 1141 "rygel-media-export-harvester.c"
				data->_tmp1_ = rygel_media_export_media_cache_exists (data->self->priv->media_db, ((RygelMediaObject*) data->container)->id, &data->timestamp, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->container);
					_g_object_unref0 (data->info);
					goto __catch44_g_error;
				}
#line 268 "rygel-media-export-harvester.vala"
				if (!data->_tmp1_) {
#line 269 "rygel-media-export-harvester.vala"
					rygel_media_export_media_cache_save_container (data->self->priv->media_db, (RygelMediaContainer*) data->container, &data->_inner_error_);
#line 1152 "rygel-media-export-harvester.c"
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->container);
						_g_object_unref0 (data->info);
						goto __catch44_g_error;
					}
				}
#line 272 "rygel-media-export-harvester.vala"
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_media_export_harvester_on_idle_gsource_func, g_object_ref (data->self), g_object_unref);
#line 1161 "rygel-media-export-harvester.c"
				_g_object_unref0 (data->container);
			} else {
				data->_tmp2_ = NULL;
#line 275 "rygel-media-export-harvester.vala"
				if ((data->_tmp3_ = rygel_media_export_harvester_push_if_changed_or_unknown (data->self, data->file, data->info, &data->_tmp2_), data->id = (data->_tmp4_ = data->_tmp2_, _g_free0 (data->id), data->_tmp4_), data->_tmp3_)) {
#line 276 "rygel-media-export-harvester.vala"
					g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_media_export_harvester_on_idle_gsource_func, g_object_ref (data->self), g_object_unref);
#line 277 "rygel-media-export-harvester.vala"
					data->self->priv->origin = (data->_tmp5_ = _g_object_ref0 (data->file), _g_object_unref0 (data->self->priv->origin), data->_tmp5_);
#line 278 "rygel-media-export-harvester.vala"
					g_queue_push_tail (data->self->priv->containers, _g_object_ref0 (data->self->priv->parent));
#line 1173 "rygel-media-export-harvester.c"
				} else {
#line 282 "rygel-media-export-harvester.vala"
					g_debug (_ ("File %s does not need harvesting"), data->_tmp6_ = g_file_get_uri (data->file));
#line 1177 "rygel-media-export-harvester.c"
					_g_free0 (data->_tmp6_);
#line 284 "rygel-media-export-harvester.vala"
					g_signal_emit_by_name (data->self, "harvested", data->file);
#line 1181 "rygel-media-export-harvester.c"
				}
				_g_free0 (data->id);
			}
			_g_object_unref0 (data->info);
		}
		goto __finally44;
		__catch44_g_error:
		{
			data->err = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
#line 289 "rygel-media-export-harvester.vala"
				g_warning (_ ("Failed to harvest file %s: %s"), data->_tmp7_ = g_file_get_uri (data->file), data->err->message);
#line 1195 "rygel-media-export-harvester.c"
				_g_free0 (data->_tmp7_);
#line 292 "rygel-media-export-harvester.vala"
				g_signal_emit_by_name (data->self, "harvested", data->file);
#line 1199 "rygel-media-export-harvester.c"
				_g_error_free0 (data->err);
			}
		}
		__finally44:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 296 "rygel-media-export-harvester.vala"
static void rygel_media_export_harvester_on_extracted_cb (RygelMediaExportHarvester* self, GFile* file, GUPnPDLNAInformation* dlna, const char* mime, guint64 size, guint64 mtime) {
#line 1224 "rygel-media-export-harvester.c"
	GError * _inner_error_;
	GFile* entry;
#line 296 "rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 296 "rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 296 "rygel-media-export-harvester.vala"
	g_return_if_fail (mime != NULL);
#line 1233 "rygel-media-export-harvester.c"
	_inner_error_ = NULL;
#line 301 "rygel-media-export-harvester.vala"
	if (g_cancellable_is_cancelled (self->cancellable)) {
#line 302 "rygel-media-export-harvester.vala"
		g_signal_emit_by_name (self, "harvested", self->priv->origin);
#line 1239 "rygel-media-export-harvester.c"
	}
#line 305 "rygel-media-export-harvester.vala"
	entry = (GFile*) gee_queue_peek (self->priv->files);
#line 306 "rygel-media-export-harvester.vala"
	if (entry == NULL) {
#line 1245 "rygel-media-export-harvester.c"
		_g_object_unref0 (entry);
#line 309 "rygel-media-export-harvester.vala"
		return;
#line 1249 "rygel-media-export-harvester.c"
	}
#line 311 "rygel-media-export-harvester.vala"
	if (file == entry) {
#line 1253 "rygel-media-export-harvester.c"
		RygelMediaItem* item;
		GFile* _tmp2_;
		item = NULL;
#line 313 "rygel-media-export-harvester.vala"
		if (dlna == NULL) {
#line 1259 "rygel-media-export-harvester.c"
			RygelMediaItem* _tmp0_;
#line 314 "rygel-media-export-harvester.vala"
			item = (_tmp0_ = (RygelMediaItem*) rygel_media_export_item_new_simple ((RygelMediaContainer*) g_queue_peek_head (self->priv->containers), file, mime, size, mtime), _g_object_unref0 (item), _tmp0_);
#line 1263 "rygel-media-export-harvester.c"
		} else {
			RygelMediaItem* _tmp1_;
#line 320 "rygel-media-export-harvester.vala"
			item = (_tmp1_ = (RygelMediaItem*) rygel_media_export_item_create_from_info ((RygelMediaContainer*) g_queue_peek_head (self->priv->containers), file, dlna, mime, size, mtime), _g_object_unref0 (item), _tmp1_);
#line 1268 "rygel-media-export-harvester.c"
		}
#line 328 "rygel-media-export-harvester.vala"
		if (item != NULL) {
#line 329 "rygel-media-export-harvester.vala"
			rygel_media_object_set_parent_ref ((RygelMediaObject*) item, (RygelMediaContainer*) g_queue_peek_head (self->priv->containers));
#line 1274 "rygel-media-export-harvester.c"
			{
#line 331 "rygel-media-export-harvester.vala"
				rygel_media_export_media_cache_save_item (self->priv->media_db, item, &_inner_error_);
#line 1278 "rygel-media-export-harvester.c"
				if (_inner_error_ != NULL) {
					goto __catch45_g_error;
				}
			}
			goto __finally45;
			__catch45_g_error:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (_error_);
				}
			}
			__finally45:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (item);
				_g_object_unref0 (entry);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
#line 337 "rygel-media-export-harvester.vala"
		_tmp2_ = (GFile*) gee_queue_poll (self->priv->files);
#line 1304 "rygel-media-export-harvester.c"
		_g_object_unref0 (_tmp2_);
#line 338 "rygel-media-export-harvester.vala"
		rygel_media_export_harvester_do_update (self);
#line 1308 "rygel-media-export-harvester.c"
		_g_object_unref0 (item);
	}
	_g_object_unref0 (entry);
}


#line 342 "rygel-media-export-harvester.vala"
static void rygel_media_export_harvester_on_extractor_error_cb (RygelMediaExportHarvester* self, GFile* file, GError* _error_) {
#line 1317 "rygel-media-export-harvester.c"
	GFile* entry;
#line 342 "rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 342 "rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 343 "rygel-media-export-harvester.vala"
	entry = (GFile*) gee_queue_peek (self->priv->files);
#line 344 "rygel-media-export-harvester.vala"
	if (entry == NULL) {
#line 1327 "rygel-media-export-harvester.c"
		_g_object_unref0 (entry);
#line 347 "rygel-media-export-harvester.vala"
		return;
#line 1331 "rygel-media-export-harvester.c"
	}
#line 350 "rygel-media-export-harvester.vala"
	if (file == entry) {
#line 1335 "rygel-media-export-harvester.c"
		GFile* _tmp0_;
#line 351 "rygel-media-export-harvester.vala"
		_tmp0_ = (GFile*) gee_queue_poll (self->priv->files);
#line 1339 "rygel-media-export-harvester.c"
		_g_object_unref0 (_tmp0_);
#line 352 "rygel-media-export-harvester.vala"
		rygel_media_export_harvester_do_update (self);
#line 1343 "rygel-media-export-harvester.c"
	}
	_g_object_unref0 (entry);
}


#line 361 "rygel-media-export-harvester.vala"
static void rygel_media_export_harvester_do_update (RygelMediaExportHarvester* self) {
#line 1351 "rygel-media-export-harvester.c"
	gboolean _tmp0_ = FALSE;
#line 361 "rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 362 "rygel-media-export-harvester.vala"
	if (gee_collection_get_size ((GeeCollection*) self->priv->files) == 0) {
#line 363 "rygel-media-export-harvester.vala"
		_tmp0_ = g_queue_get_length (self->priv->containers) != 0;
#line 1359 "rygel-media-export-harvester.c"
	} else {
#line 362 "rygel-media-export-harvester.vala"
		_tmp0_ = FALSE;
#line 1363 "rygel-media-export-harvester.c"
	}
#line 362 "rygel-media-export-harvester.vala"
	if (_tmp0_) {
#line 1367 "rygel-media-export-harvester.c"
		RygelMediaContainer* _tmp1_;
#line 364 "rygel-media-export-harvester.vala"
		rygel_media_container_updated ((RygelMediaContainer*) g_queue_peek_head (self->priv->containers));
#line 365 "rygel-media-export-harvester.vala"
		_tmp1_ = (RygelMediaContainer*) g_queue_pop_head (self->priv->containers);
#line 1373 "rygel-media-export-harvester.c"
		_g_object_unref0 (_tmp1_);
	}
#line 368 "rygel-media-export-harvester.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_media_export_harvester_on_idle_gsource_func, g_object_ref (self), g_object_unref);
#line 1378 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_class_init (RygelMediaExportHarvesterClass * klass) {
	rygel_media_export_harvester_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvesterPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvester_finalize;
	g_signal_new ("harvested", RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_FILE);
}


static void rygel_media_export_harvester_instance_init (RygelMediaExportHarvester * self) {
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE (self);
}


static void rygel_media_export_harvester_finalize (GObject* obj) {
	RygelMediaExportHarvester * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTER (obj);
	_g_object_unref0 (self->priv->extractor);
	_g_object_unref0 (self->priv->media_db);
	_g_queue_free0 (self->priv->containers);
	_g_object_unref0 (self->priv->files);
	_g_object_unref0 (self->priv->origin);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->priv->monitor);
	_g_regex_unref0 (self->priv->file_filter);
	_g_object_unref0 (self->cancellable);
	_g_free0 (self->priv->flag);
	G_OBJECT_CLASS (rygel_media_export_harvester_parent_class)->finalize (obj);
}


GType rygel_media_export_harvester_get_type (void) {
	static volatile gsize rygel_media_export_harvester_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvester), 0, (GInstanceInitFunc) rygel_media_export_harvester_instance_init, NULL };
		GType rygel_media_export_harvester_type_id;
		rygel_media_export_harvester_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvester", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_harvester_type_id__volatile, rygel_media_export_harvester_type_id);
	}
	return rygel_media_export_harvester_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




