#
# Layout algorithms.
#
# A layout algorithm is a function f: (step, args) -> (x, y, relative)
# A step value of n means that the coordinates of the nth child are being
# requested.
#


RELATIVE_NONE = 0
RELATIVE_X = 1
RELATIVE_Y = 2
RELATIVE_XY = 3


def horizontal(step, args):

    if (not args): return (0, 0, RELATIVE_X)
    else:
        delta = int(args[0])
        x = delta * step
        y = 0
        
        return (x, y, RELATIVE_NONE)



def vertical(step, args):

    if (not args): return (0, 0, RELATIVE_Y)
    delta = int(args[0])
    y = delta * step
    x = 0

    return (x, y, RELATIVE_NONE)



def grid(step, args):

    width, deltax, deltay = args
    x = (step % int(width)) * int(deltax)
    y = (step / int(width)) * int(deltay)

    return (x, y, RELATIVE_NONE)




#
# Association of names with the algorithms.
#
LAYOUTERS = {"horizontal": horizontal,
             "vertical": vertical,
             "grid": grid
             }
