/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-file-savable.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_FILE_SAVABLE_H_
#define _IANJUTA_FILE_SAVABLE_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-file.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_FILE_SAVABLE (ianjuta_file_savable_get_type ())
#define IANJUTA_FILE_SAVABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_FILE_SAVABLE, IAnjutaFileSavable))
#define IANJUTA_IS_FILE_SAVABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_FILE_SAVABLE))
#define IANJUTA_FILE_SAVABLE_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_FILE_SAVABLE, IAnjutaFileSavableIface))

#define IANJUTA_FILE_SAVABLE_ERROR ianjuta_file_savable_error_quark()

typedef struct _IAnjutaFileSavable IAnjutaFileSavable;
typedef struct _IAnjutaFileSavableIface IAnjutaFileSavableIface;

struct _IAnjutaFileSavableIface {
	IAnjutaFileIface g_iface;
	
	/* Signal */
	void (*save_point) (IAnjutaFileSavable *obj, gboolean entered);
	/* Signal */
	void (*saved) (IAnjutaFileSavable *obj, const gchar *uri);

	gboolean (*is_dirty) (IAnjutaFileSavable *obj, GError **err);
	void (*save) (IAnjutaFileSavable *obj, GError **err);
	void (*save_as) (IAnjutaFileSavable *obj, const gchar *uri, GError **err);
	void (*set_dirty) (IAnjutaFileSavable *obj, gboolean dirty, GError **err);

};

GQuark ianjuta_file_savable_error_quark     (void);
GType  ianjuta_file_savable_get_type        (void);

gboolean ianjuta_file_savable_is_dirty (IAnjutaFileSavable *obj, GError **err);

void ianjuta_file_savable_save (IAnjutaFileSavable *obj, GError **err);

void ianjuta_file_savable_save_as (IAnjutaFileSavable *obj, const gchar *uri, GError **err);

void ianjuta_file_savable_set_dirty (IAnjutaFileSavable *obj, gboolean dirty, GError **err);


G_END_DECLS

#endif
