/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-symbol.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_SYMBOL_H_
#define _IANJUTA_SYMBOL_H_

#include <glib-object.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_SYMBOL (ianjuta_symbol_get_type ())
#define IANJUTA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_SYMBOL, IAnjutaSymbol))
#define IANJUTA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_SYMBOL))
#define IANJUTA_SYMBOL_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_SYMBOL, IAnjutaSymbolIface))

#define IANJUTA_TYPE_SYMBOL_FIELD (ianjuta_symbol_field_get_type())
#define IANJUTA_TYPE_SYMBOL_TYPE (ianjuta_symbol_type_get_type())

#define IANJUTA_SYMBOL_ERROR ianjuta_symbol_error_quark()

typedef struct _IAnjutaSymbol IAnjutaSymbol;
typedef struct _IAnjutaSymbolIface IAnjutaSymbolIface;

/** 
 * IAnjutaSymbolField:
 * @IANJUTA_SYMBOL_FIELD_SIMPLE: With this field you will have name, line of declaration,
 *                               is_file_scope and signature of the symbol.
 * @IANJUTA_SYMBOL_FIELD_FILE_PATH: The path to the file. It's obtained using something like
 *									g_strconcat ("/home/user/project_dir/", 
 *									"src/db/realative/path/file.c");
 * @IANJUTA_SYMBOL_FIELD_IMPLEMENTATION: implementation attribute of a symbol. It may be
 *										"pure virtual", "virtual", etc.
 * @IANJUTA_SYMBOL_FIELD_ACCESS: access attribute of a symbol. It may be "public", "private" etc.
 * @IANJUTA_SYMBOL_FIELD_KIND: kind attribute of a symbol. "enumerator", "namespace", "class" are
 *							  some examples.
 * @IANJUTA_SYMBOL_FIELD_TYPE: type attribute of a symbol. Use this field in conjunction with
 *						#IANJUTA_SYMBOL_FIELD_TYPE_NAME as the query would retrieve both
 *						attributes in a quicker way.
 * @IANJUTA_SYMBOL_FIELD_TYPE_NAME: type_name attribute of a symbol. If a type could be
 *									"class" then its type_name may be "MyFooClass" etc.
 * @IANJUTA_SYMBOL_FIELD_LANGUAGE: the language of the symbol, e.g. "C", "Java", etc.
 * @IANJUTA_SYMBOL_FIELD_FILE_IGNORE: field mainly ignored.
 * @IANJUTA_SYMBOL_FIELD_FILE_INCLUDE: field mainly ignored.
 * @IANJUTA_SYMBOL_FIELD_PROJECT_NAME: the project this symbol belongs to.
 * @IANJUTA_SYMBOL_FIELD_WORKSPACE_NAME: the workspace this symbol belongs to.
 *
 * Field masks. Used mainly to retrieve the fields of a symbol
 * throught the call to ianjuta_symbol_get_extra_info_string () or the various
 * ianjuta_symbol_manager_* () functions
 */
typedef enum {
	IANJUTA_SYMBOL_FIELD_SIMPLE = 1,
	IANJUTA_SYMBOL_FIELD_FILE_PATH = 2,
	IANJUTA_SYMBOL_FIELD_IMPLEMENTATION = 4,
	IANJUTA_SYMBOL_FIELD_ACCESS = 8,
	IANJUTA_SYMBOL_FIELD_KIND = 16,
	IANJUTA_SYMBOL_FIELD_TYPE = 32,
	IANJUTA_SYMBOL_FIELD_TYPE_NAME = 64,
	IANJUTA_SYMBOL_FIELD_LANGUAGE = 128,
	IANJUTA_SYMBOL_FIELD_FILE_IGNORE = 256,
	IANJUTA_SYMBOL_FIELD_FILE_INCLUDE = 512,
	IANJUTA_SYMBOL_FIELD_PROJECT_NAME = 1024,
	IANJUTA_SYMBOL_FIELD_WORKSPACE_NAME = 2048
} IAnjutaSymbolField;

/** 
 * IAnjutaSymbolType:
 * @IANJUTA_SYMBOL_TYPE_UNDEF: Unknown type. If you have to search for all the known
 * types use this flag because it's quicker than #IANJUTA_SYMBOL_TYPE_MAX.
 * @IANJUTA_SYMBOL_TYPE_CLASS: Class declaration
 * @IANJUTA_SYMBOL_TYPE_ENUM: Enum declaration 
 * @IANJUTA_SYMBOL_TYPE_ENUMERATOR: Enumerator value 
 * @IANJUTA_SYMBOL_TYPE_FIELD: Field (Java only) 
 * @IANJUTA_SYMBOL_TYPE_FUNCTION: Function definition 
 * @IANJUTA_SYMBOL_TYPE_INTERFACE: Interface (Java only) 
 * @IANJUTA_SYMBOL_TYPE_MEMBER: Member variable of class/struct 
 * @IANJUTA_SYMBOL_TYPE_METHOD: Class method (Java only) 
 * @IANJUTA_SYMBOL_TYPE_NAMESPACE: Namespace declaration 
 * @IANJUTA_SYMBOL_TYPE_PACKAGE: Package (Java only)
 * @IANJUTA_SYMBOL_TYPE_PROTOTYPE: Function prototype 
 * @IANJUTA_SYMBOL_TYPE_STRUCT: Struct declaration 
 * @IANJUTA_SYMBOL_TYPE_TYPEDEF: Typedef 
 * @IANJUTA_SYMBOL_TYPE_UNION: Union 
 * @IANJUTA_SYMBOL_TYPE_VARIABLE: Variable 
 * @IANJUTA_SYMBOL_TYPE_EXTERNVAR: Extern or forward declaration 
 * @IANJUTA_SYMBOL_TYPE_MACRO: Macro (without arguments) 
 * @IANJUTA_SYMBOL_TYPE_MACRO_WITH_ARG: Parameterized macro 
 * @IANJUTA_SYMBOL_TYPE_FILE: File (Pseudo tag) 
 * @IANJUTA_SYMBOL_TYPE_OTHER: Other (non C/C++/Java tag) 
 * @IANJUTA_SYMBOL_TYPE_SCOPE_CONTAINER: types which are subjected to create a scope.
 * @IANJUTA_SYMBOL_TYPE_MAX: Maximum value, means all known values. You can reach
 * the same result using IANJUTA_SYMBOL_TYPE_UNDEF, which is much faster.
 */                   
typedef enum {
	IANJUTA_SYMBOL_TYPE_UNDEF = 1,
	IANJUTA_SYMBOL_TYPE_CLASS = 2,
	IANJUTA_SYMBOL_TYPE_ENUM = 4,
	IANJUTA_SYMBOL_TYPE_ENUMERATOR = 8,
	IANJUTA_SYMBOL_TYPE_FIELD = 16,
	IANJUTA_SYMBOL_TYPE_FUNCTION = 32,
	IANJUTA_SYMBOL_TYPE_INTERFACE = 64,
	IANJUTA_SYMBOL_TYPE_MEMBER = 128,
	IANJUTA_SYMBOL_TYPE_METHOD = 256,
	IANJUTA_SYMBOL_TYPE_NAMESPACE = 512,
	IANJUTA_SYMBOL_TYPE_PACKAGE = 1024,
	IANJUTA_SYMBOL_TYPE_PROTOTYPE = 2048,
	IANJUTA_SYMBOL_TYPE_STRUCT = 4096,
	IANJUTA_SYMBOL_TYPE_TYPEDEF = 8192,
	IANJUTA_SYMBOL_TYPE_UNION = 16384,
	IANJUTA_SYMBOL_TYPE_VARIABLE = 32768,
	IANJUTA_SYMBOL_TYPE_EXTERNVAR = 65536,
	IANJUTA_SYMBOL_TYPE_MACRO = 131072,
	IANJUTA_SYMBOL_TYPE_MACRO_WITH_ARG = 262144,
	IANJUTA_SYMBOL_TYPE_FILE = 524288,
	IANJUTA_SYMBOL_TYPE_OTHER = 1048576,
	IANJUTA_SYMBOL_TYPE_SCOPE_CONTAINER = IANJUTA_SYMBOL_TYPE_CLASS | IANJUTA_SYMBOL_TYPE_ENUM | IANJUTA_SYMBOL_TYPE_INTERFACE | IANJUTA_SYMBOL_TYPE_NAMESPACE | IANJUTA_SYMBOL_TYPE_PACKAGE | IANJUTA_SYMBOL_TYPE_STRUCT | IANJUTA_SYMBOL_TYPE_UNION,
	IANJUTA_SYMBOL_TYPE_MAX = 2097151
} IAnjutaSymbolType;


struct _IAnjutaSymbolIface {
	GTypeInterface g_iface;
	

	const gchar * (*get_args) (IAnjutaSymbol *obj, GError **err);
	const gchar * (*get_extra_info_string) (IAnjutaSymbol *obj, IAnjutaSymbolField sym_info, GError **err);
	GFile * (*get_file) (IAnjutaSymbol *obj, GError **err);
	const GdkPixbuf * (*get_icon) (IAnjutaSymbol *obj, GError **err);
	gint (*get_id) (IAnjutaSymbol *obj, GError **err);
	gulong (*get_line) (IAnjutaSymbol *obj, GError **err);
	const gchar * (*get_name) (IAnjutaSymbol *obj, GError **err);
	const gchar * (*get_returntype) (IAnjutaSymbol *obj, GError **err);
	IAnjutaSymbolType (*get_sym_type) (IAnjutaSymbol *obj, GError **err);
	gboolean (*is_local) (IAnjutaSymbol *obj, GError **err);

};

GType ianjuta_symbol_field_get_type (void);
GType ianjuta_symbol_type_get_type (void);

GQuark ianjuta_symbol_error_quark     (void);
GType  ianjuta_symbol_get_type        (void);

const gchar * ianjuta_symbol_get_args (IAnjutaSymbol *obj, GError **err);

const gchar * ianjuta_symbol_get_extra_info_string (IAnjutaSymbol *obj, IAnjutaSymbolField sym_info, GError **err);

GFile * ianjuta_symbol_get_file (IAnjutaSymbol *obj, GError **err);

const GdkPixbuf * ianjuta_symbol_get_icon (IAnjutaSymbol *obj, GError **err);

gint ianjuta_symbol_get_id (IAnjutaSymbol *obj, GError **err);

gulong ianjuta_symbol_get_line (IAnjutaSymbol *obj, GError **err);

const gchar * ianjuta_symbol_get_name (IAnjutaSymbol *obj, GError **err);

const gchar * ianjuta_symbol_get_returntype (IAnjutaSymbol *obj, GError **err);

IAnjutaSymbolType ianjuta_symbol_get_sym_type (IAnjutaSymbol *obj, GError **err);

gboolean ianjuta_symbol_is_local (IAnjutaSymbol *obj, GError **err);


G_END_DECLS

#endif
