/* This is -*- C -*- */
/* $Id: guppi-boxplot-state.h,v 1.8 2000/10/27 18:22:45 trow Exp $ */

/*
 * guppi-boxplot-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_BOXPLOT_STATE_H
#define _INC_GUPPI_BOXPLOT_STATE_H

#include <gnome.h>
#include <guppi-defs.h>
#include <guppi-seq-scalar.h>
#include <guppi-element-state.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiBoxplotState GuppiBoxplotState;
typedef struct _GuppiBoxplotStateClass GuppiBoxplotStateClass;

struct _GuppiBoxplotState {
  GuppiElementState parent;

  gboolean ready;
  gboolean horizontal;

  double q1, md, q3, whisker_lower, whisker_upper, iqr;

  double iqr_factor;
  guint32 frame_color;
  double line_thickness;
  gboolean fill_box;
  guint32 box_color;
  double box_size;
  double tick_size;		/* size of hash marks on the end of the "whiskers" */
};

struct _GuppiBoxplotStateClass {
  GuppiElementStateClass parent_class;
};

#define GUPPI_TYPE_BOXPLOT_STATE (guppi_boxplot_state_get_type())
#define GUPPI_BOXPLOT_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_BOXPLOT_STATE,GuppiBoxplotState))
#define GUPPI_BOXPLOT_STATE0(obj) ((obj) ? (GUPPI_BOXPLOT_STATE(obj)) : NULL)
#define GUPPI_BOXPLOT_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_BOXPLOT_STATE,GuppiBoxplotStateClass))
#define GUPPI_IS_BOXPLOT_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_BOXPLOT_STATE))
#define GUPPI_IS_BOXPLOT_STATE0(obj) (((obj) == NULL) || (GUPPI_IS_BOXPLOT_STATE(obj)))
#define GUPPI_IS_BOXPLOT_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_BOXPLOT_STATE))

GtkType guppi_boxplot_state_get_type (void);

GuppiElementState *guppi_boxplot_state_new (void);

GuppiSeqScalar *guppi_boxplot_state_data (GuppiBoxplotState *);

#define guppi_boxplot_state_horizontal(x) ((x)->horizontal)
#define guppi_boxplot_state_vertical(x) (!(x)->horizontal)
#define guppi_boxplot_state_iqr_factor(x) ((x)->iqr_factor)
#define guppi_boxplot_state_frame_color(x) ((x)->frame_color)
#define guppi_boxplot_state_line_thickness(x) ((x)->line_thickness)
#define guppi_boxplot_state_fill_box(x) ((x)->fill_box)
#define guppi_boxplot_state_box_color(x) ((x)->box_color)
#define guppi_boxplot_state_box_size(x) ((x)->box_size)
#define guppi_boxplot_state_tick_size(x) ((x)->tick_size)


void guppi_boxplot_state_set_data (GuppiBoxplotState *, GuppiSeqScalar *);

void guppi_boxplot_state_set_horizontal (GuppiBoxplotState *, gboolean);
void guppi_boxplot_state_set_vertical (GuppiBoxplotState *, gboolean);
void guppi_boxplot_state_set_iqr_factor (GuppiBoxplotState *, double);
void guppi_boxplot_state_set_frame_color (GuppiBoxplotState *, guint32);
void guppi_boxplot_state_set_line_thickness (GuppiBoxplotState *, double);
void guppi_boxplot_state_set_fill_box (GuppiBoxplotState *, gboolean);
void guppi_boxplot_state_set_box_color (GuppiBoxplotState *, guint32);
void guppi_boxplot_state_set_box_size (GuppiBoxplotState *, double);
void guppi_boxplot_state_set_tick_size (GuppiBoxplotState *, double);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_BOXPLOT_STATE_H */

/* $Id: guppi-boxplot-state.h,v 1.8 2000/10/27 18:22:45 trow Exp $ */
