/* This is -*- C -*- */
/* $Id: guppi-text-item.c,v 1.12 2000/12/12 23:11:57 trow Exp $ */

/*
 * guppi-text-item.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-convenient.h>
#include <guppi-useful.h>
#include "guppi-text-state.h"
#include "guppi-text-view.h"
#include "guppi-text-item.h"

static GtkObjectClass *parent_class = NULL;

static void
guppi_text_item_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_text_item_finalize (GtkObject * obj)
{
  GuppiTextItem *item = GUPPI_TEXT_ITEM (obj);

  guppi_unref (item->template);
  item->template = NULL;

  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/*****************************************************************************/

static void
set_template (GuppiTextItem * gti)
{
  GuppiCanvasItem *item;
  GuppiTextState *state;
  GnomeFont *font;
  double sc;

  g_return_if_fail (gti != NULL);

  item = GUPPI_CANVAS_ITEM (gti);
  state = GUPPI_TEXT_STATE (guppi_canvas_item_state (item));
  sc = guppi_canvas_item_scale (item);

  guppi_unref0 (gti->template);

  font = guppi_text_state_font (state);

  if (font != NULL && guppi_text_state_text (state) != NULL) {
    gti->template =
      guppi_alpha_template_text_general (font, sc,
					 guppi_text_state_text (state),
					 guppi_text_state_rot_angle (state),
					 guppi_text_state_filled (state),
					 guppi_text_state_outline_width
					 (state));
  }
}

static void
update (GuppiCanvasItem * gci, double aff[6], ArtSVP * svp, gint flags)
{
  GuppiTextItem *gti = GUPPI_TEXT_ITEM (gci);
  set_template (gti);
}

static void
render (GuppiCanvasItem * gci, GnomeCanvasBuf * buf)
{
  GuppiTextItem *gti;
  GuppiTextState *state;
  gint cx, cy, cx0, cy0, cx1, cy1;
  guint r, g, b, a;

  gti = GUPPI_TEXT_ITEM (gci);
  state = GUPPI_TEXT_STATE (guppi_canvas_item_state (gci));

  guppi_canvas_item_get_bbox_c (gci, &cx0, &cy0, &cx1, &cy1);

  if (gti->template != NULL) {
    cx = (cx0 + cx1 - gti->template->width) / 2;
    cy = (cy0 + cy1 - gti->template->height) / 2;

    cx += guppi_x_pt2px (guppi_text_state_left_margin (state) -
			 guppi_text_state_right_margin (state)) / 2;

    cy += guppi_y_pt2px (guppi_text_state_top_margin (state) -
			 guppi_text_state_bottom_margin (state)) / 2;

    UINT_TO_RGBA (guppi_text_state_color (state), &r, &g, &b, &a);
    guppi_alpha_template_print (gti->template, cx, cy, r, g, b, a, buf);
  }
}

static void
state_changed (GuppiCanvasItem * gci)
{
  guppi_canvas_item_request_update (gci);
}

static void
view_changed (GuppiCanvasItem * gci)
{
  guppi_canvas_item_request_update (gci);
}

/*****************************************************************************/

static void
guppi_text_item_class_init (GuppiTextItemClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiCanvasItemClass *gci_class = GUPPI_CANVAS_ITEM_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_CANVAS_ITEM);

  object_class->destroy = guppi_text_item_destroy;
  object_class->finalize = guppi_text_item_finalize;

  gci_class->state_changed = state_changed;
  gci_class->view_changed = view_changed;
  gci_class->guppi_update = update;
  gci_class->guppi_render = render;

}

static void
guppi_text_item_init (GuppiTextItem * obj)
{

}

GtkType guppi_text_item_get_type (void)
{
  static GtkType guppi_text_item_type = 0;
  if (!guppi_text_item_type) {
    static const GtkTypeInfo guppi_text_item_info = {
      "GuppiTextItem",
      sizeof (GuppiTextItem),
      sizeof (GuppiTextItemClass),
      (GtkClassInitFunc) guppi_text_item_class_init,
      (GtkObjectInitFunc) guppi_text_item_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_text_item_type =
      gtk_type_unique (GUPPI_TYPE_CANVAS_ITEM, &guppi_text_item_info);
  }
  return guppi_text_item_type;
}




/* $Id: guppi-text-item.c,v 1.12 2000/12/12 23:11:57 trow Exp $ */
