/* This is auto-generated code.  Edit at your own peril! */

#include <config.h>
#include <guppi-convenient.h>
#include "guppi-scm-data.h"

static long guppi_data_type_tag;
#define SCM_TO_GUPPI_DATA(x) (GUPPI_DATA(SCM_CDR(x)))
#define SCM_GUPPI_DATA_P(x) (SCM_NIMP(x) && SCM_CAR(x) == guppi_data_type_tag)

gboolean
scm_guppi_data_p(SCM x)
{
    return SCM_GUPPI_DATA_P(x);
} 

SCM
guppi_data2scm(GuppiData* x)
{
    SCM smob;
    if (x == NULL || !GUPPI_IS_DATA(x))
	return SCM_UNSPECIFIED;
    SCM_DEFER_INTS;
#ifdef USING_GUILE_1_3_X
    SCM_NEWCELL(smob);
    SCM_SETCAR(smob, guppi_data_type_tag);
    SCM_SETCDR(smob, x);
#else
    SCM_NEWSMOB(smob, guppi_data_type_tag, x);
#endif
    guppi_ref(x);
    guppi_sink(x);
    SCM_ALLOW_INTS;

    return smob;
}

GuppiData*
scm2guppi_data(SCM x)
{
    g_return_val_if_fail(SCM_GUPPI_DATA_P(x), NULL);
    return SCM_TO_GUPPI_DATA(x);
}

static SCM
mark_guppi_data(SCM x)
{
    return SCM_BOOL_F;
}

static scm_sizet
free_guppi_data(SCM x)
{
    GuppiData* y = SCM_TO_GUPPI_DATA(x);
    SCM_DEFER_INTS;
    guppi_unref(y);
    SCM_ALLOW_INTS;

    return 0;
}

static int
print_guppi_data(SCM x, SCM port, scm_print_state* state)
{
    scm_puts("<GuppiData>", port);
    return 1;
}

#ifdef USING_GUILE_1_3_X
static struct scm_smobfuns guppi_data_smob_fns = {
    mark_guppi_data, free_guppi_data, print_guppi_data, NULL
};
#endif

static SCM
fn_scm_guppi_data_p(SCM x)
{
    return gh_bool2scm(SCM_GUPPI_DATA_P(x));
}


static const gchar* s_scm_guppi_data_get_type_name = "guppi-data-get-type-name";
static SCM
fn_scm_guppi_data_get_type_name(SCM s_data)
{
  GuppiData* c_data;
  const gchar* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG1, (gchar*)s_scm_guppi_data_get_type_name);
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  c_retval = guppi_data_get_type_name(c_data);
  s_retval = gh_str02scm((gchar*)c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_data_get_impl_name = "guppi-data-get-impl-name";
static SCM
fn_scm_guppi_data_get_impl_name(SCM s_data)
{
  GuppiData* c_data;
  const gchar* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG1, (gchar*)s_scm_guppi_data_get_impl_name);
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  c_retval = guppi_data_get_impl_name(c_data);
  s_retval = gh_str02scm((gchar*)c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_data_get_label = "guppi-data-get-label";
static SCM
fn_scm_guppi_data_get_label(SCM s_data)
{
  GuppiData* c_data;
  const gchar* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG1, (gchar*)s_scm_guppi_data_get_label);
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  c_retval = guppi_data_get_label(c_data);
  s_retval = gh_str02scm((gchar*)c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_data_set_label = "guppi-data-set-label";
static SCM
fn_scm_guppi_data_set_label(SCM s_data, SCM s_label)
{
  GuppiData* c_data;
  gchar* c_label;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG1, (gchar*)s_scm_guppi_data_set_label);
  SCM_ASSERT(gh_string_p(s_label), s_label, SCM_ARG2, (gchar*)s_scm_guppi_data_set_label);
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  c_label = gh_scm2newstr(s_label, NULL);
  guppi_data_set_label(c_data, c_label);
  free((gpointer)c_label);
  return s_retval;
}

static const gchar* s_scm_guppi_data_is_read_only = "guppi-data-is-read-only";
static SCM
fn_scm_guppi_data_is_read_only(SCM s_data)
{
  GuppiData* c_data;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG1, (gchar*)s_scm_guppi_data_is_read_only);
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  c_retval = guppi_data_is_read_only(c_data);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_data_copy = "guppi-data-copy";
static SCM
fn_scm_guppi_data_copy(SCM s_data)
{
  GuppiData* c_data;
  GuppiData* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG1, (gchar*)s_scm_guppi_data_copy);
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  c_retval = guppi_data_copy(c_data);
  s_retval = guppi_data2scm(GUPPI_DATA(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_data_get_size_in_bytes = "guppi-data-get-size-in-bytes";
static SCM
fn_scm_guppi_data_get_size_in_bytes(SCM s_data)
{
  GuppiData* c_data;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG1, (gchar*)s_scm_guppi_data_get_size_in_bytes);
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  c_retval = guppi_data_get_size_in_bytes(c_data);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_data_spew_xml = "guppi-data-spew-xml";
static SCM
fn_scm_guppi_data_spew_xml(SCM s_data)
{
  GuppiData* c_data;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG1, (gchar*)s_scm_guppi_data_spew_xml);
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  guppi_data_spew_xml(c_data);
  return s_retval;
}


gboolean
scm_guppi_struct_p(SCM x)
{
  GuppiData* foo;
  if (scm_guppi_data_p(x)) {
    foo = GUPPI_DATA(scm2guppi_data(x));
    if (foo != NULL && GUPPI_IS_STRUCT(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_struct2scm(GuppiStruct* x)
{
  return guppi_data2scm(GUPPI_DATA(x));
}

GuppiStruct*
scm2guppi_struct(SCM x)
{
  return GUPPI_STRUCT(scm2guppi_data(x));    
}

static SCM
fn_scm_guppi_struct_p(SCM x)
{
  return gh_bool2scm(scm_guppi_struct_p(x));
}


static const gchar* s_scm_guppi_struct_new = "guppi-struct-new";
static SCM
fn_scm_guppi_struct_new()
{
  GuppiData* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_struct_new();
  s_retval = guppi_data2scm(GUPPI_DATA(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_struct_get_field_names = "guppi-struct-get-field-names";
static SCM
fn_scm_guppi_struct_get_field_names(SCM s_str)
{
  GuppiStruct* c_str;
  gchar** c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_struct_p(s_str), s_str, SCM_ARG1, (gchar*)s_scm_guppi_struct_get_field_names);
  c_str = GUPPI_STRUCT(scm2guppi_struct(s_str));
  c_retval = guppi_struct_get_field_names(c_str);
  s_retval = stringv2scm(c_retval);
  guppi_strfreev(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_struct_size = "guppi-struct-size";
static SCM
fn_scm_guppi_struct_size(SCM s_str)
{
  GuppiStruct* c_str;
  gsize c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_struct_p(s_str), s_str, SCM_ARG1, (gchar*)s_scm_guppi_struct_size);
  c_str = GUPPI_STRUCT(scm2guppi_struct(s_str));
  c_retval = guppi_struct_size(c_str);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_struct_get = "guppi-struct-get";
static SCM
fn_scm_guppi_struct_get(SCM s_str, SCM s_field)
{
  GuppiStruct* c_str;
  gchar* c_field;
  GuppiData* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_struct_p(s_str), s_str, SCM_ARG1, (gchar*)s_scm_guppi_struct_get);
  SCM_ASSERT(gh_string_p(s_field), s_field, SCM_ARG2, (gchar*)s_scm_guppi_struct_get);
  c_str = GUPPI_STRUCT(scm2guppi_struct(s_str));
  c_field = gh_scm2newstr(s_field, NULL);
  c_retval = guppi_struct_get(c_str, c_field);
  s_retval = guppi_data2scm(GUPPI_DATA(c_retval));
  free((gpointer)c_field);
  return s_retval;
}

static const gchar* s_scm_guppi_struct_set = "guppi-struct-set";
static SCM
fn_scm_guppi_struct_set(SCM s_str, SCM s_field, SCM s_data)
{
  GuppiStruct* c_str;
  gchar* c_field;
  GuppiData* c_data;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_struct_p(s_str), s_str, SCM_ARG1, (gchar*)s_scm_guppi_struct_set);
  SCM_ASSERT(gh_string_p(s_field), s_field, SCM_ARG2, (gchar*)s_scm_guppi_struct_set);
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG3, (gchar*)s_scm_guppi_struct_set);
  c_str = GUPPI_STRUCT(scm2guppi_struct(s_str));
  c_field = gh_scm2newstr(s_field, NULL);
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  guppi_struct_set(c_str, c_field, c_data);
  free((gpointer)c_field);
  return s_retval;
}

static const gchar* s_scm_guppi_struct_add_free_field = "guppi-struct-add-free-field";
static SCM
fn_scm_guppi_struct_add_free_field(SCM s_str, SCM s_field)
{
  GuppiStruct* c_str;
  gchar* c_field;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_struct_p(s_str), s_str, SCM_ARG1, (gchar*)s_scm_guppi_struct_add_free_field);
  SCM_ASSERT(gh_string_p(s_field), s_field, SCM_ARG2, (gchar*)s_scm_guppi_struct_add_free_field);
  c_str = GUPPI_STRUCT(scm2guppi_struct(s_str));
  c_field = gh_scm2newstr(s_field, NULL);
  guppi_struct_add_free_field(c_str, c_field);
  free((gpointer)c_field);
  return s_retval;
}


gboolean
scm_guppi_category_p(SCM x)
{
  GuppiData* foo;
  if (scm_guppi_data_p(x)) {
    foo = GUPPI_DATA(scm2guppi_data(x));
    if (foo != NULL && GUPPI_IS_CATEGORY(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_category2scm(GuppiCategory* x)
{
  return guppi_data2scm(GUPPI_DATA(x));
}

GuppiCategory*
scm2guppi_category(SCM x)
{
  return GUPPI_CATEGORY(scm2guppi_data(x));    
}

static SCM
fn_scm_guppi_category_p(SCM x)
{
  return gh_bool2scm(scm_guppi_category_p(x));
}


static const gchar* s_scm_guppi_category_new = "guppi-category-new";
static SCM
fn_scm_guppi_category_new()
{
  GuppiData* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_category_new();
  s_retval = guppi_data2scm(GUPPI_DATA(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_category_size = "guppi-category-size";
static SCM
fn_scm_guppi_category_size(SCM s_cat)
{
  GuppiCategory* c_cat;
  gsize c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_category_p(s_cat), s_cat, SCM_ARG1, (gchar*)s_scm_guppi_category_size);
  c_cat = GUPPI_CATEGORY(scm2guppi_category(s_cat));
  c_retval = guppi_category_size(c_cat);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_category_min_code = "guppi-category-min-code";
static SCM
fn_scm_guppi_category_min_code(SCM s_cat)
{
  GuppiCategory* c_cat;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_category_p(s_cat), s_cat, SCM_ARG1, (gchar*)s_scm_guppi_category_min_code);
  c_cat = GUPPI_CATEGORY(scm2guppi_category(s_cat));
  c_retval = guppi_category_min_code(c_cat);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_category_max_code = "guppi-category-max-code";
static SCM
fn_scm_guppi_category_max_code(SCM s_cat)
{
  GuppiCategory* c_cat;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_category_p(s_cat), s_cat, SCM_ARG1, (gchar*)s_scm_guppi_category_max_code);
  c_cat = GUPPI_CATEGORY(scm2guppi_category(s_cat));
  c_retval = guppi_category_max_code(c_cat);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_category_unused_code = "guppi-category-unused-code";
static SCM
fn_scm_guppi_category_unused_code(SCM s_cat)
{
  GuppiCategory* c_cat;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_category_p(s_cat), s_cat, SCM_ARG1, (gchar*)s_scm_guppi_category_unused_code);
  c_cat = GUPPI_CATEGORY(scm2guppi_category(s_cat));
  c_retval = guppi_category_unused_code(c_cat);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_category_define = "guppi-category-define";
static SCM
fn_scm_guppi_category_define(SCM s_cat, SCM s_str, SCM s_code)
{
  GuppiCategory* c_cat;
  gchar* c_str;
  gint c_code;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_category_p(s_cat), s_cat, SCM_ARG1, (gchar*)s_scm_guppi_category_define);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG2, (gchar*)s_scm_guppi_category_define);
  SCM_ASSERT(gh_exact_p(s_code), s_code, SCM_ARG3, (gchar*)s_scm_guppi_category_define);
  c_cat = GUPPI_CATEGORY(scm2guppi_category(s_cat));
  c_str = gh_scm2newstr(s_str, NULL);
  c_code = gh_scm2int(s_code);
  c_retval = guppi_category_define(c_cat, c_str, c_code);
  s_retval = gh_bool2scm(c_retval);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_category_add_by_name = "guppi-category-add-by-name";
static SCM
fn_scm_guppi_category_add_by_name(SCM s_cat, SCM s_str)
{
  GuppiCategory* c_cat;
  gchar* c_str;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_category_p(s_cat), s_cat, SCM_ARG1, (gchar*)s_scm_guppi_category_add_by_name);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG2, (gchar*)s_scm_guppi_category_add_by_name);
  c_cat = GUPPI_CATEGORY(scm2guppi_category(s_cat));
  c_str = gh_scm2newstr(s_str, NULL);
  c_retval = guppi_category_add_by_name(c_cat, c_str);
  s_retval = gh_int2scm(c_retval);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_category_contains = "guppi-category-contains";
static SCM
fn_scm_guppi_category_contains(SCM s_cat, SCM s_str)
{
  GuppiCategory* c_cat;
  gchar* c_str;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_category_p(s_cat), s_cat, SCM_ARG1, (gchar*)s_scm_guppi_category_contains);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG2, (gchar*)s_scm_guppi_category_contains);
  c_cat = GUPPI_CATEGORY(scm2guppi_category(s_cat));
  c_str = gh_scm2newstr(s_str, NULL);
  c_retval = guppi_category_contains(c_cat, c_str);
  s_retval = gh_bool2scm(c_retval);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_category_contains_code = "guppi-category-contains-code";
static SCM
fn_scm_guppi_category_contains_code(SCM s_cat, SCM s_code)
{
  GuppiCategory* c_cat;
  gint c_code;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_category_p(s_cat), s_cat, SCM_ARG1, (gchar*)s_scm_guppi_category_contains_code);
  SCM_ASSERT(gh_exact_p(s_code), s_code, SCM_ARG2, (gchar*)s_scm_guppi_category_contains_code);
  c_cat = GUPPI_CATEGORY(scm2guppi_category(s_cat));
  c_code = gh_scm2int(s_code);
  c_retval = guppi_category_contains_code(c_cat, c_code);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_category_find_by_name = "guppi-category-find-by-name";
static SCM
fn_scm_guppi_category_find_by_name(SCM s_cat, SCM s_str)
{
  GuppiCategory* c_cat;
  gchar* c_str;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_category_p(s_cat), s_cat, SCM_ARG1, (gchar*)s_scm_guppi_category_find_by_name);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG2, (gchar*)s_scm_guppi_category_find_by_name);
  c_cat = GUPPI_CATEGORY(scm2guppi_category(s_cat));
  c_str = gh_scm2newstr(s_str, NULL);
  c_retval = guppi_category_find_by_name(c_cat, c_str);
  s_retval = gh_int2scm(c_retval);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_category_find_by_code = "guppi-category-find-by-code";
static SCM
fn_scm_guppi_category_find_by_code(SCM s_cat, SCM s_code)
{
  GuppiCategory* c_cat;
  gint c_code;
  const gchar* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_category_p(s_cat), s_cat, SCM_ARG1, (gchar*)s_scm_guppi_category_find_by_code);
  SCM_ASSERT(gh_exact_p(s_code), s_code, SCM_ARG2, (gchar*)s_scm_guppi_category_find_by_code);
  c_cat = GUPPI_CATEGORY(scm2guppi_category(s_cat));
  c_code = gh_scm2int(s_code);
  c_retval = guppi_category_find_by_code(c_cat, c_code);
  s_retval = gh_str02scm((gchar*)c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_category_rename = "guppi-category-rename";
static SCM
fn_scm_guppi_category_rename(SCM s_cat, SCM s_code, SCM s_str)
{
  GuppiCategory* c_cat;
  gint c_code;
  gchar* c_str;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_category_p(s_cat), s_cat, SCM_ARG1, (gchar*)s_scm_guppi_category_rename);
  SCM_ASSERT(gh_exact_p(s_code), s_code, SCM_ARG2, (gchar*)s_scm_guppi_category_rename);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG3, (gchar*)s_scm_guppi_category_rename);
  c_cat = GUPPI_CATEGORY(scm2guppi_category(s_cat));
  c_code = gh_scm2int(s_code);
  c_str = gh_scm2newstr(s_str, NULL);
  c_retval = guppi_category_rename(c_cat, c_code, c_str);
  s_retval = gh_bool2scm(c_retval);
  free((gpointer)c_str);
  return s_retval;
}


gboolean
scm_guppi_seq_p(SCM x)
{
  GuppiData* foo;
  if (scm_guppi_data_p(x)) {
    foo = GUPPI_DATA(scm2guppi_data(x));
    if (foo != NULL && GUPPI_IS_SEQ(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_seq2scm(GuppiSeq* x)
{
  return guppi_data2scm(GUPPI_DATA(x));
}

GuppiSeq*
scm2guppi_seq(SCM x)
{
  return GUPPI_SEQ(scm2guppi_data(x));    
}

static SCM
fn_scm_guppi_seq_p(SCM x)
{
  return gh_bool2scm(scm_guppi_seq_p(x));
}


static const gchar* s_scm_guppi_seq_size_hint = "guppi-seq-size-hint";
static SCM
fn_scm_guppi_seq_size_hint(SCM s_seq, SCM s_size)
{
  GuppiSeq* c_seq;
  gsize c_size;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_size_hint);
  SCM_ASSERT((gh_exact_p(s_size) && gh_scm2int(s_size)>=0), s_size, SCM_ARG2, (gchar*)s_scm_guppi_seq_size_hint);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_size = (gsize)gh_scm2int(s_size);
  guppi_seq_size_hint(c_seq, c_size);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_min_index = "guppi-seq-min-index";
static SCM
fn_scm_guppi_seq_min_index(SCM s_seq)
{
  GuppiSeq* c_seq;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_min_index);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_retval = guppi_seq_min_index(c_seq);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_max_index = "guppi-seq-max-index";
static SCM
fn_scm_guppi_seq_max_index(SCM s_seq)
{
  GuppiSeq* c_seq;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_max_index);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_retval = guppi_seq_max_index(c_seq);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_size = "guppi-seq-size";
static SCM
fn_scm_guppi_seq_size(SCM s_seq)
{
  GuppiSeq* c_seq;
  gsize c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_size);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_retval = guppi_seq_size(c_seq);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_count = "guppi-seq-count";
static SCM
fn_scm_guppi_seq_count(SCM s_seq)
{
  GuppiSeq* c_seq;
  gsize c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_count);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_retval = guppi_seq_count(c_seq);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_empty = "guppi-seq-empty";
static SCM
fn_scm_guppi_seq_empty(SCM s_seq)
{
  GuppiSeq* c_seq;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_empty);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_retval = guppi_seq_empty(c_seq);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_nonempty = "guppi-seq-nonempty";
static SCM
fn_scm_guppi_seq_nonempty(SCM s_seq)
{
  GuppiSeq* c_seq;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_nonempty);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_retval = guppi_seq_nonempty(c_seq);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_absent = "guppi-seq-absent";
static SCM
fn_scm_guppi_seq_absent(SCM s_seq)
{
  GuppiSeq* c_seq;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_absent);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_retval = guppi_seq_absent(c_seq);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_present = "guppi-seq-present";
static SCM
fn_scm_guppi_seq_present(SCM s_seq)
{
  GuppiSeq* c_seq;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_present);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_retval = guppi_seq_present(c_seq);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_in_bounds = "guppi-seq-in-bounds";
static SCM
fn_scm_guppi_seq_in_bounds(SCM s_seq, SCM s_index)
{
  GuppiSeq* c_seq;
  gint c_index;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_in_bounds);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_in_bounds);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_index = gh_scm2int(s_index);
  c_retval = guppi_seq_in_bounds(c_seq, c_index);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_contains_bounds = "guppi-seq-contains-bounds";
static SCM
fn_scm_guppi_seq_contains_bounds(SCM s_seq1, SCM s_seq2)
{
  GuppiSeq* c_seq1;
  GuppiSeq* c_seq2;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq1), s_seq1, SCM_ARG1, (gchar*)s_scm_guppi_seq_contains_bounds);
  SCM_ASSERT(scm_guppi_seq_p(s_seq2), s_seq2, SCM_ARG2, (gchar*)s_scm_guppi_seq_contains_bounds);
  c_seq1 = GUPPI_SEQ(scm2guppi_seq(s_seq1));
  c_seq2 = GUPPI_SEQ(scm2guppi_seq(s_seq2));
  c_retval = guppi_seq_contains_bounds(c_seq1, c_seq2);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_equal_bounds = "guppi-seq-equal-bounds";
static SCM
fn_scm_guppi_seq_equal_bounds(SCM s_seq1, SCM s_seq2)
{
  GuppiSeq* c_seq1;
  GuppiSeq* c_seq2;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq1), s_seq1, SCM_ARG1, (gchar*)s_scm_guppi_seq_equal_bounds);
  SCM_ASSERT(scm_guppi_seq_p(s_seq2), s_seq2, SCM_ARG2, (gchar*)s_scm_guppi_seq_equal_bounds);
  c_seq1 = GUPPI_SEQ(scm2guppi_seq(s_seq1));
  c_seq2 = GUPPI_SEQ(scm2guppi_seq(s_seq2));
  c_retval = guppi_seq_equal_bounds(c_seq1, c_seq2);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_shift_indices = "guppi-seq-shift-indices";
static SCM
fn_scm_guppi_seq_shift_indices(SCM s_seq, SCM s_delta)
{
  GuppiSeq* c_seq;
  gint c_delta;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_shift_indices);
  SCM_ASSERT(gh_exact_p(s_delta), s_delta, SCM_ARG2, (gchar*)s_scm_guppi_seq_shift_indices);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_delta = gh_scm2int(s_delta);
  guppi_seq_shift_indices(c_seq, c_delta);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_set_min_index = "guppi-seq-set-min-index";
static SCM
fn_scm_guppi_seq_set_min_index(SCM s_seq, SCM s_new_min)
{
  GuppiSeq* c_seq;
  gint c_new_min;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_set_min_index);
  SCM_ASSERT(gh_exact_p(s_new_min), s_new_min, SCM_ARG2, (gchar*)s_scm_guppi_seq_set_min_index);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_new_min = gh_scm2int(s_new_min);
  guppi_seq_set_min_index(c_seq, c_new_min);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_set_max_index = "guppi-seq-set-max-index";
static SCM
fn_scm_guppi_seq_set_max_index(SCM s_seq, SCM s_new_max)
{
  GuppiSeq* c_seq;
  gint c_new_max;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_set_max_index);
  SCM_ASSERT(gh_exact_p(s_new_max), s_new_max, SCM_ARG2, (gchar*)s_scm_guppi_seq_set_max_index);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_new_max = gh_scm2int(s_new_max);
  guppi_seq_set_max_index(c_seq, c_new_max);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_validate = "guppi-seq-validate";
static SCM
fn_scm_guppi_seq_validate(SCM s_seq, SCM s_str)
{
  GuppiSeq* c_seq;
  gchar* c_str;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_validate);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG2, (gchar*)s_scm_guppi_seq_validate);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_str = gh_scm2newstr(s_str, NULL);
  c_retval = guppi_seq_validate(c_seq, c_str);
  s_retval = gh_bool2scm(c_retval);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_get_string = "guppi-seq-get-string";
static SCM
fn_scm_guppi_seq_get_string(SCM s_seq, SCM s_index)
{
  GuppiSeq* c_seq;
  gint c_index;
  gchar* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_get_string);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_get_string);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_index = gh_scm2int(s_index);
  c_retval = guppi_seq_get_string(c_seq, c_index);
  s_retval = gh_str02scm(c_retval);
  free((gpointer)c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_set_from_string = "guppi-seq-set-from-string";
static SCM
fn_scm_guppi_seq_set_from_string(SCM s_seq, SCM s_index, SCM s_str)
{
  GuppiSeq* c_seq;
  gint c_index;
  gchar* c_str;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_set_from_string);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_set_from_string);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG3, (gchar*)s_scm_guppi_seq_set_from_string);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_index = gh_scm2int(s_index);
  c_str = gh_scm2newstr(s_str, NULL);
  guppi_seq_set_from_string(c_seq, c_index, c_str);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_insert_from_string = "guppi-seq-insert-from-string";
static SCM
fn_scm_guppi_seq_insert_from_string(SCM s_seq, SCM s_index, SCM s_str)
{
  GuppiSeq* c_seq;
  gint c_index;
  gchar* c_str;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_insert_from_string);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_insert_from_string);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG3, (gchar*)s_scm_guppi_seq_insert_from_string);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_index = gh_scm2int(s_index);
  c_str = gh_scm2newstr(s_str, NULL);
  guppi_seq_insert_from_string(c_seq, c_index, c_str);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_delete = "guppi-seq-delete";
static SCM
fn_scm_guppi_seq_delete(SCM s_seq, SCM s_index)
{
  GuppiSeq* c_seq;
  gint c_index;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_delete);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_delete);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_index = gh_scm2int(s_index);
  guppi_seq_delete(c_seq, c_index);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_delete_many = "guppi-seq-delete-many";
static SCM
fn_scm_guppi_seq_delete_many(SCM s_seq, SCM s_index, SCM s_count)
{
  GuppiSeq* c_seq;
  gint c_index;
  gsize c_count;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_delete_many);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_delete_many);
  SCM_ASSERT((gh_exact_p(s_count) && gh_scm2int(s_count)>=0), s_count, SCM_ARG3, (gchar*)s_scm_guppi_seq_delete_many);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_index = gh_scm2int(s_index);
  c_count = (gsize)gh_scm2int(s_count);
  guppi_seq_delete_many(c_seq, c_index, c_count);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_delete_range = "guppi-seq-delete-range";
static SCM
fn_scm_guppi_seq_delete_range(SCM s_seq, SCM s_i0, SCM s_i1)
{
  GuppiSeq* c_seq;
  gint c_i0;
  gint c_i1;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_delete_range);
  SCM_ASSERT(gh_exact_p(s_i0), s_i0, SCM_ARG2, (gchar*)s_scm_guppi_seq_delete_range);
  SCM_ASSERT(gh_exact_p(s_i1), s_i1, SCM_ARG3, (gchar*)s_scm_guppi_seq_delete_range);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_i0 = gh_scm2int(s_i0);
  c_i1 = gh_scm2int(s_i1);
  guppi_seq_delete_range(c_seq, c_i0, c_i1);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_grow_to_include = "guppi-seq-grow-to-include";
static SCM
fn_scm_guppi_seq_grow_to_include(SCM s_seq, SCM s_index)
{
  GuppiSeq* c_seq;
  gint c_index;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_grow_to_include);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_grow_to_include);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_index = gh_scm2int(s_index);
  guppi_seq_grow_to_include(c_seq, c_index);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_grow_to_include_range = "guppi-seq-grow-to-include-range";
static SCM
fn_scm_guppi_seq_grow_to_include_range(SCM s_seq, SCM s_i0, SCM s_i1)
{
  GuppiSeq* c_seq;
  gint c_i0;
  gint c_i1;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_grow_to_include_range);
  SCM_ASSERT(gh_exact_p(s_i0), s_i0, SCM_ARG2, (gchar*)s_scm_guppi_seq_grow_to_include_range);
  SCM_ASSERT(gh_exact_p(s_i1), s_i1, SCM_ARG3, (gchar*)s_scm_guppi_seq_grow_to_include_range);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_i0 = gh_scm2int(s_i0);
  c_i1 = gh_scm2int(s_i1);
  guppi_seq_grow_to_include_range(c_seq, c_i0, c_i1);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_grow_to_overlap = "guppi-seq-grow-to-overlap";
static SCM
fn_scm_guppi_seq_grow_to_overlap(SCM s_seq, SCM s_other_seq)
{
  GuppiSeq* c_seq;
  GuppiSeq* c_other_seq;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_grow_to_overlap);
  SCM_ASSERT(scm_guppi_seq_p(s_other_seq), s_other_seq, SCM_ARG2, (gchar*)s_scm_guppi_seq_grow_to_overlap);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_other_seq = GUPPI_SEQ(scm2guppi_seq(s_other_seq));
  guppi_seq_grow_to_overlap(c_seq, c_other_seq);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_has_missing = "guppi-seq-has-missing";
static SCM
fn_scm_guppi_seq_has_missing(SCM s_seq)
{
  GuppiSeq* c_seq;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_has_missing);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_retval = guppi_seq_has_missing(c_seq);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_missing_count = "guppi-seq-missing-count";
static SCM
fn_scm_guppi_seq_missing_count(SCM s_seq)
{
  GuppiSeq* c_seq;
  gsize c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_missing_count);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_retval = guppi_seq_missing_count(c_seq);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_missing = "guppi-seq-missing";
static SCM
fn_scm_guppi_seq_missing(SCM s_seq, SCM s_i)
{
  GuppiSeq* c_seq;
  gint c_i;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_missing);
  SCM_ASSERT(gh_exact_p(s_i), s_i, SCM_ARG2, (gchar*)s_scm_guppi_seq_missing);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_i = gh_scm2int(s_i);
  c_retval = guppi_seq_missing(c_seq, c_i);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_set_missing = "guppi-seq-set-missing";
static SCM
fn_scm_guppi_seq_set_missing(SCM s_seq, SCM s_i)
{
  GuppiSeq* c_seq;
  gint c_i;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_set_missing);
  SCM_ASSERT(gh_exact_p(s_i), s_i, SCM_ARG2, (gchar*)s_scm_guppi_seq_set_missing);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_i = gh_scm2int(s_i);
  guppi_seq_set_missing(c_seq, c_i);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_insert_missing = "guppi-seq-insert-missing";
static SCM
fn_scm_guppi_seq_insert_missing(SCM s_seq, SCM s_i)
{
  GuppiSeq* c_seq;
  gint c_i;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_insert_missing);
  SCM_ASSERT(gh_exact_p(s_i), s_i, SCM_ARG2, (gchar*)s_scm_guppi_seq_insert_missing);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  c_i = gh_scm2int(s_i);
  guppi_seq_insert_missing(c_seq, c_i);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_prepend_missing = "guppi-seq-prepend-missing";
static SCM
fn_scm_guppi_seq_prepend_missing(SCM s_seq)
{
  GuppiSeq* c_seq;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_prepend_missing);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  guppi_seq_prepend_missing(c_seq);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_append_missing = "guppi-seq-append-missing";
static SCM
fn_scm_guppi_seq_append_missing(SCM s_seq)
{
  GuppiSeq* c_seq;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_append_missing);
  c_seq = GUPPI_SEQ(scm2guppi_seq(s_seq));
  guppi_seq_append_missing(c_seq);
  return s_retval;
}


gboolean
scm_guppi_seq_scalar_p(SCM x)
{
  GuppiSeq* foo;
  if (scm_guppi_seq_p(x)) {
    foo = GUPPI_SEQ(scm2guppi_seq(x));
    if (foo != NULL && GUPPI_IS_SEQ_SCALAR(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_seq_scalar2scm(GuppiSeqScalar* x)
{
  return guppi_seq2scm(GUPPI_SEQ(x));
}

GuppiSeqScalar*
scm2guppi_seq_scalar(SCM x)
{
  return GUPPI_SEQ_SCALAR(scm2guppi_seq(x));    
}

static SCM
fn_scm_guppi_seq_scalar_p(SCM x)
{
  return gh_bool2scm(scm_guppi_seq_scalar_p(x));
}


static const gchar* s_scm_guppi_seq_scalar_new = "guppi-seq-scalar-new";
static SCM
fn_scm_guppi_seq_scalar_new()
{
  GuppiData* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_seq_scalar_new();
  s_retval = guppi_data2scm(GUPPI_DATA(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_get = "guppi-seq-scalar-get";
static SCM
fn_scm_guppi_seq_scalar_get(SCM s_seq, SCM s_index)
{
  GuppiSeqScalar* c_seq;
  gint c_index;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_get);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_scalar_get);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_index = gh_scm2int(s_index);
  c_retval = guppi_seq_scalar_get(c_seq, c_index);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_set = "guppi-seq-scalar-set";
static SCM
fn_scm_guppi_seq_scalar_set(SCM s_seq, SCM s_index, SCM s_value)
{
  GuppiSeqScalar* c_seq;
  gint c_index;
  double c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_set);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_scalar_set);
  SCM_ASSERT(gh_number_p(s_value), s_value, SCM_ARG3, (gchar*)s_scm_guppi_seq_scalar_set);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_index = gh_scm2int(s_index);
  c_value = gh_scm2double(s_value);
  guppi_seq_scalar_set(c_seq, c_index, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_prepend = "guppi-seq-scalar-prepend";
static SCM
fn_scm_guppi_seq_scalar_prepend(SCM s_seq, SCM s_value)
{
  GuppiSeqScalar* c_seq;
  double c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_prepend);
  SCM_ASSERT(gh_number_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_scalar_prepend);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_value = gh_scm2double(s_value);
  guppi_seq_scalar_prepend(c_seq, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_prepend_repeating = "guppi-seq-scalar-prepend-repeating";
static SCM
fn_scm_guppi_seq_scalar_prepend_repeating(SCM s_seq, SCM s_value, SCM s_count)
{
  GuppiSeqScalar* c_seq;
  double c_value;
  gsize c_count;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_prepend_repeating);
  SCM_ASSERT(gh_number_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_scalar_prepend_repeating);
  SCM_ASSERT((gh_exact_p(s_count) && gh_scm2int(s_count)>=0), s_count, SCM_ARG3, (gchar*)s_scm_guppi_seq_scalar_prepend_repeating);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_value = gh_scm2double(s_value);
  c_count = (gsize)gh_scm2int(s_count);
  guppi_seq_scalar_prepend_repeating(c_seq, c_value, c_count);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_append = "guppi-seq-scalar-append";
static SCM
fn_scm_guppi_seq_scalar_append(SCM s_seq, SCM s_value)
{
  GuppiSeqScalar* c_seq;
  double c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_append);
  SCM_ASSERT(gh_number_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_scalar_append);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_value = gh_scm2double(s_value);
  guppi_seq_scalar_append(c_seq, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_append_repeating = "guppi-seq-scalar-append-repeating";
static SCM
fn_scm_guppi_seq_scalar_append_repeating(SCM s_seq, SCM s_value, SCM s_count)
{
  GuppiSeqScalar* c_seq;
  double c_value;
  gsize c_count;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_append_repeating);
  SCM_ASSERT(gh_number_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_scalar_append_repeating);
  SCM_ASSERT((gh_exact_p(s_count) && gh_scm2int(s_count)>=0), s_count, SCM_ARG3, (gchar*)s_scm_guppi_seq_scalar_append_repeating);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_value = gh_scm2double(s_value);
  c_count = (gsize)gh_scm2int(s_count);
  guppi_seq_scalar_append_repeating(c_seq, c_value, c_count);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_insert = "guppi-seq-scalar-insert";
static SCM
fn_scm_guppi_seq_scalar_insert(SCM s_seq, SCM s_index, SCM s_value)
{
  GuppiSeqScalar* c_seq;
  gint c_index;
  double c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_insert);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_scalar_insert);
  SCM_ASSERT(gh_number_p(s_value), s_value, SCM_ARG3, (gchar*)s_scm_guppi_seq_scalar_insert);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_index = gh_scm2int(s_index);
  c_value = gh_scm2double(s_value);
  guppi_seq_scalar_insert(c_seq, c_index, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_insert_repeating = "guppi-seq-scalar-insert-repeating";
static SCM
fn_scm_guppi_seq_scalar_insert_repeating(SCM s_seq, SCM s_index, SCM s_value, SCM s_count)
{
  GuppiSeqScalar* c_seq;
  gint c_index;
  double c_value;
  gsize c_count;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_insert_repeating);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_scalar_insert_repeating);
  SCM_ASSERT(gh_number_p(s_value), s_value, SCM_ARG3, (gchar*)s_scm_guppi_seq_scalar_insert_repeating);
  SCM_ASSERT((gh_exact_p(s_count) && gh_scm2int(s_count)>=0), s_count, SCM_ARG4, (gchar*)s_scm_guppi_seq_scalar_insert_repeating);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_index = gh_scm2int(s_index);
  c_value = gh_scm2double(s_value);
  c_count = (gsize)gh_scm2int(s_count);
  guppi_seq_scalar_insert_repeating(c_seq, c_index, c_value, c_count);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_min = "guppi-seq-scalar-min";
static SCM
fn_scm_guppi_seq_scalar_min(SCM s_seq)
{
  GuppiSeqScalar* c_seq;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_min);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_retval = guppi_seq_scalar_min(c_seq);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_max = "guppi-seq-scalar-max";
static SCM
fn_scm_guppi_seq_scalar_max(SCM s_seq)
{
  GuppiSeqScalar* c_seq;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_max);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_retval = guppi_seq_scalar_max(c_seq);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_sum = "guppi-seq-scalar-sum";
static SCM
fn_scm_guppi_seq_scalar_sum(SCM s_seq)
{
  GuppiSeqScalar* c_seq;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_sum);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_retval = guppi_seq_scalar_sum(c_seq);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_sum_abs = "guppi-seq-scalar-sum-abs";
static SCM
fn_scm_guppi_seq_scalar_sum_abs(SCM s_seq)
{
  GuppiSeqScalar* c_seq;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_sum_abs);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_retval = guppi_seq_scalar_sum_abs(c_seq);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_mean = "guppi-seq-scalar-mean";
static SCM
fn_scm_guppi_seq_scalar_mean(SCM s_seq)
{
  GuppiSeqScalar* c_seq;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_mean);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_retval = guppi_seq_scalar_mean(c_seq);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_var = "guppi-seq-scalar-var";
static SCM
fn_scm_guppi_seq_scalar_var(SCM s_seq)
{
  GuppiSeqScalar* c_seq;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_var);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_retval = guppi_seq_scalar_var(c_seq);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_vars = "guppi-seq-scalar-vars";
static SCM
fn_scm_guppi_seq_scalar_vars(SCM s_seq)
{
  GuppiSeqScalar* c_seq;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_vars);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_retval = guppi_seq_scalar_vars(c_seq);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_sdev = "guppi-seq-scalar-sdev";
static SCM
fn_scm_guppi_seq_scalar_sdev(SCM s_seq)
{
  GuppiSeqScalar* c_seq;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_sdev);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_retval = guppi_seq_scalar_sdev(c_seq);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_sdevs = "guppi-seq-scalar-sdevs";
static SCM
fn_scm_guppi_seq_scalar_sdevs(SCM s_seq)
{
  GuppiSeqScalar* c_seq;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_sdevs);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_retval = guppi_seq_scalar_sdevs(c_seq);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_q1 = "guppi-seq-scalar-q1";
static SCM
fn_scm_guppi_seq_scalar_q1(SCM s_seq)
{
  GuppiSeqScalar* c_seq;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_q1);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_retval = guppi_seq_scalar_q1(c_seq);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_median = "guppi-seq-scalar-median";
static SCM
fn_scm_guppi_seq_scalar_median(SCM s_seq)
{
  GuppiSeqScalar* c_seq;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_median);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_retval = guppi_seq_scalar_median(c_seq);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_q3 = "guppi-seq-scalar-q3";
static SCM
fn_scm_guppi_seq_scalar_q3(SCM s_seq)
{
  GuppiSeqScalar* c_seq;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_q3);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_retval = guppi_seq_scalar_q3(c_seq);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_scalar_percentile = "guppi-seq-scalar-percentile";
static SCM
fn_scm_guppi_seq_scalar_percentile(SCM s_seq, SCM s_p)
{
  GuppiSeqScalar* c_seq;
  double c_p;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_scalar_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_scalar_percentile);
  SCM_ASSERT(gh_number_p(s_p), s_p, SCM_ARG2, (gchar*)s_scm_guppi_seq_scalar_percentile);
  c_seq = GUPPI_SEQ_SCALAR(scm2guppi_seq_scalar(s_seq));
  c_p = gh_scm2double(s_p);
  c_retval = guppi_seq_scalar_percentile(c_seq, c_p);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}


gboolean
scm_guppi_seq_integer_p(SCM x)
{
  GuppiSeq* foo;
  if (scm_guppi_seq_p(x)) {
    foo = GUPPI_SEQ(scm2guppi_seq(x));
    if (foo != NULL && GUPPI_IS_SEQ_INTEGER(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_seq_integer2scm(GuppiSeqInteger* x)
{
  return guppi_seq2scm(GUPPI_SEQ(x));
}

GuppiSeqInteger*
scm2guppi_seq_integer(SCM x)
{
  return GUPPI_SEQ_INTEGER(scm2guppi_seq(x));    
}

static SCM
fn_scm_guppi_seq_integer_p(SCM x)
{
  return gh_bool2scm(scm_guppi_seq_integer_p(x));
}


static const gchar* s_scm_guppi_seq_integer_new = "guppi-seq-integer-new";
static SCM
fn_scm_guppi_seq_integer_new()
{
  GuppiData* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_seq_integer_new();
  s_retval = guppi_data2scm(GUPPI_DATA(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_seq_integer_get = "guppi-seq-integer-get";
static SCM
fn_scm_guppi_seq_integer_get(SCM s_seq, SCM s_index)
{
  GuppiSeqInteger* c_seq;
  gint c_index;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_integer_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_integer_get);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_integer_get);
  c_seq = GUPPI_SEQ_INTEGER(scm2guppi_seq_integer(s_seq));
  c_index = gh_scm2int(s_index);
  c_retval = guppi_seq_integer_get(c_seq, c_index);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_integer_set = "guppi-seq-integer-set";
static SCM
fn_scm_guppi_seq_integer_set(SCM s_seq, SCM s_index, SCM s_value)
{
  GuppiSeqInteger* c_seq;
  gint c_index;
  gint c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_integer_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_integer_set);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_integer_set);
  SCM_ASSERT(gh_exact_p(s_value), s_value, SCM_ARG3, (gchar*)s_scm_guppi_seq_integer_set);
  c_seq = GUPPI_SEQ_INTEGER(scm2guppi_seq_integer(s_seq));
  c_index = gh_scm2int(s_index);
  c_value = gh_scm2int(s_value);
  guppi_seq_integer_set(c_seq, c_index, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_integer_set_many_dup = "guppi-seq-integer-set-many-dup";
static SCM
fn_scm_guppi_seq_integer_set_many_dup(SCM s_seq, SCM s_i0, SCM s_i1, SCM s_value)
{
  GuppiSeqInteger* c_seq;
  gint c_i0;
  gint c_i1;
  gint c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_integer_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_integer_set_many_dup);
  SCM_ASSERT(gh_exact_p(s_i0), s_i0, SCM_ARG2, (gchar*)s_scm_guppi_seq_integer_set_many_dup);
  SCM_ASSERT(gh_exact_p(s_i1), s_i1, SCM_ARG3, (gchar*)s_scm_guppi_seq_integer_set_many_dup);
  SCM_ASSERT(gh_exact_p(s_value), s_value, SCM_ARG4, (gchar*)s_scm_guppi_seq_integer_set_many_dup);
  c_seq = GUPPI_SEQ_INTEGER(scm2guppi_seq_integer(s_seq));
  c_i0 = gh_scm2int(s_i0);
  c_i1 = gh_scm2int(s_i1);
  c_value = gh_scm2int(s_value);
  guppi_seq_integer_set_many_dup(c_seq, c_i0, c_i1, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_integer_set_all = "guppi-seq-integer-set-all";
static SCM
fn_scm_guppi_seq_integer_set_all(SCM s_seq, SCM s_value)
{
  GuppiSeqInteger* c_seq;
  gint c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_integer_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_integer_set_all);
  SCM_ASSERT(gh_exact_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_integer_set_all);
  c_seq = GUPPI_SEQ_INTEGER(scm2guppi_seq_integer(s_seq));
  c_value = gh_scm2int(s_value);
  guppi_seq_integer_set_all(c_seq, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_integer_prepend = "guppi-seq-integer-prepend";
static SCM
fn_scm_guppi_seq_integer_prepend(SCM s_seq, SCM s_value)
{
  GuppiSeqInteger* c_seq;
  gint c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_integer_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_integer_prepend);
  SCM_ASSERT(gh_exact_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_integer_prepend);
  c_seq = GUPPI_SEQ_INTEGER(scm2guppi_seq_integer(s_seq));
  c_value = gh_scm2int(s_value);
  guppi_seq_integer_prepend(c_seq, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_integer_append = "guppi-seq-integer-append";
static SCM
fn_scm_guppi_seq_integer_append(SCM s_seq, SCM s_value)
{
  GuppiSeqInteger* c_seq;
  gint c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_integer_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_integer_append);
  SCM_ASSERT(gh_exact_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_integer_append);
  c_seq = GUPPI_SEQ_INTEGER(scm2guppi_seq_integer(s_seq));
  c_value = gh_scm2int(s_value);
  guppi_seq_integer_append(c_seq, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_integer_insert = "guppi-seq-integer-insert";
static SCM
fn_scm_guppi_seq_integer_insert(SCM s_seq, SCM s_index, SCM s_value)
{
  GuppiSeqInteger* c_seq;
  gint c_index;
  gint c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_integer_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_integer_insert);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_integer_insert);
  SCM_ASSERT(gh_exact_p(s_value), s_value, SCM_ARG3, (gchar*)s_scm_guppi_seq_integer_insert);
  c_seq = GUPPI_SEQ_INTEGER(scm2guppi_seq_integer(s_seq));
  c_index = gh_scm2int(s_index);
  c_value = gh_scm2int(s_value);
  guppi_seq_integer_insert(c_seq, c_index, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_integer_min = "guppi-seq-integer-min";
static SCM
fn_scm_guppi_seq_integer_min(SCM s_seq)
{
  GuppiSeqInteger* c_seq;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_integer_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_integer_min);
  c_seq = GUPPI_SEQ_INTEGER(scm2guppi_seq_integer(s_seq));
  c_retval = guppi_seq_integer_min(c_seq);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_integer_max = "guppi-seq-integer-max";
static SCM
fn_scm_guppi_seq_integer_max(SCM s_seq)
{
  GuppiSeqInteger* c_seq;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_integer_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_integer_max);
  c_seq = GUPPI_SEQ_INTEGER(scm2guppi_seq_integer(s_seq));
  c_retval = guppi_seq_integer_max(c_seq);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_integer_frequency = "guppi-seq-integer-frequency";
static SCM
fn_scm_guppi_seq_integer_frequency(SCM s_seq, SCM s_value)
{
  GuppiSeqInteger* c_seq;
  gint c_value;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_integer_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_integer_frequency);
  SCM_ASSERT(gh_exact_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_integer_frequency);
  c_seq = GUPPI_SEQ_INTEGER(scm2guppi_seq_integer(s_seq));
  c_value = gh_scm2int(s_value);
  c_retval = guppi_seq_integer_frequency(c_seq, c_value);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}


gboolean
scm_guppi_seq_categorical_p(SCM x)
{
  GuppiSeqInteger* foo;
  if (scm_guppi_seq_integer_p(x)) {
    foo = GUPPI_SEQ_INTEGER(scm2guppi_seq_integer(x));
    if (foo != NULL && GUPPI_IS_SEQ_CATEGORICAL(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_seq_categorical2scm(GuppiSeqCategorical* x)
{
  return guppi_seq_integer2scm(GUPPI_SEQ_INTEGER(x));
}

GuppiSeqCategorical*
scm2guppi_seq_categorical(SCM x)
{
  return GUPPI_SEQ_CATEGORICAL(scm2guppi_seq_integer(x));    
}

static SCM
fn_scm_guppi_seq_categorical_p(SCM x)
{
  return gh_bool2scm(scm_guppi_seq_categorical_p(x));
}


static const gchar* s_scm_guppi_seq_categorical_new = "guppi-seq-categorical-new";
static SCM
fn_scm_guppi_seq_categorical_new()
{
  GuppiData* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_seq_categorical_new();
  s_retval = guppi_data2scm(GUPPI_DATA(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_seq_categorical_category = "guppi-seq-categorical-category";
static SCM
fn_scm_guppi_seq_categorical_category(SCM s_seq)
{
  GuppiSeqCategorical* c_seq;
  GuppiCategory* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_categorical_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_categorical_category);
  c_seq = GUPPI_SEQ_CATEGORICAL(scm2guppi_seq_categorical(s_seq));
  c_retval = guppi_seq_categorical_category(c_seq);
  s_retval = guppi_category2scm(GUPPI_CATEGORY(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_seq_categorical_set_category = "guppi-seq-categorical-set-category";
static SCM
fn_scm_guppi_seq_categorical_set_category(SCM s_seq, SCM s_cat)
{
  GuppiSeqCategorical* c_seq;
  GuppiCategory* c_cat;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_categorical_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_categorical_set_category);
  SCM_ASSERT(scm_guppi_category_p(s_cat), s_cat, SCM_ARG2, (gchar*)s_scm_guppi_seq_categorical_set_category);
  c_seq = GUPPI_SEQ_CATEGORICAL(scm2guppi_seq_categorical(s_seq));
  c_cat = GUPPI_CATEGORY(scm2guppi_category(s_cat));
  guppi_seq_categorical_set_category(c_seq, c_cat);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_categorical_get = "guppi-seq-categorical-get";
static SCM
fn_scm_guppi_seq_categorical_get(SCM s_seq, SCM s_i)
{
  GuppiSeqCategorical* c_seq;
  gint c_i;
  const gchar* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_categorical_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_categorical_get);
  SCM_ASSERT(gh_exact_p(s_i), s_i, SCM_ARG2, (gchar*)s_scm_guppi_seq_categorical_get);
  c_seq = GUPPI_SEQ_CATEGORICAL(scm2guppi_seq_categorical(s_seq));
  c_i = gh_scm2int(s_i);
  c_retval = guppi_seq_categorical_get(c_seq, c_i);
  s_retval = gh_str02scm((gchar*)c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_categorical_set = "guppi-seq-categorical-set";
static SCM
fn_scm_guppi_seq_categorical_set(SCM s_seq, SCM s_i, SCM s_s)
{
  GuppiSeqCategorical* c_seq;
  gint c_i;
  gchar* c_s;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_categorical_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_categorical_set);
  SCM_ASSERT(gh_exact_p(s_i), s_i, SCM_ARG2, (gchar*)s_scm_guppi_seq_categorical_set);
  SCM_ASSERT(gh_string_p(s_s), s_s, SCM_ARG3, (gchar*)s_scm_guppi_seq_categorical_set);
  c_seq = GUPPI_SEQ_CATEGORICAL(scm2guppi_seq_categorical(s_seq));
  c_i = gh_scm2int(s_i);
  c_s = gh_scm2newstr(s_s, NULL);
  c_retval = guppi_seq_categorical_set(c_seq, c_i, c_s);
  s_retval = gh_bool2scm(c_retval);
  free((gpointer)c_s);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_categorical_prepend = "guppi-seq-categorical-prepend";
static SCM
fn_scm_guppi_seq_categorical_prepend(SCM s_seq, SCM s_s)
{
  GuppiSeqCategorical* c_seq;
  gchar* c_s;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_categorical_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_categorical_prepend);
  SCM_ASSERT(gh_string_p(s_s), s_s, SCM_ARG2, (gchar*)s_scm_guppi_seq_categorical_prepend);
  c_seq = GUPPI_SEQ_CATEGORICAL(scm2guppi_seq_categorical(s_seq));
  c_s = gh_scm2newstr(s_s, NULL);
  c_retval = guppi_seq_categorical_prepend(c_seq, c_s);
  s_retval = gh_bool2scm(c_retval);
  free((gpointer)c_s);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_categorical_append = "guppi-seq-categorical-append";
static SCM
fn_scm_guppi_seq_categorical_append(SCM s_seq, SCM s_s)
{
  GuppiSeqCategorical* c_seq;
  gchar* c_s;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_categorical_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_categorical_append);
  SCM_ASSERT(gh_string_p(s_s), s_s, SCM_ARG2, (gchar*)s_scm_guppi_seq_categorical_append);
  c_seq = GUPPI_SEQ_CATEGORICAL(scm2guppi_seq_categorical(s_seq));
  c_s = gh_scm2newstr(s_s, NULL);
  c_retval = guppi_seq_categorical_append(c_seq, c_s);
  s_retval = gh_bool2scm(c_retval);
  free((gpointer)c_s);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_categorical_insert = "guppi-seq-categorical-insert";
static SCM
fn_scm_guppi_seq_categorical_insert(SCM s_seq, SCM s_i, SCM s_s)
{
  GuppiSeqCategorical* c_seq;
  gint c_i;
  gchar* c_s;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_categorical_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_categorical_insert);
  SCM_ASSERT(gh_exact_p(s_i), s_i, SCM_ARG2, (gchar*)s_scm_guppi_seq_categorical_insert);
  SCM_ASSERT(gh_string_p(s_s), s_s, SCM_ARG3, (gchar*)s_scm_guppi_seq_categorical_insert);
  c_seq = GUPPI_SEQ_CATEGORICAL(scm2guppi_seq_categorical(s_seq));
  c_i = gh_scm2int(s_i);
  c_s = gh_scm2newstr(s_s, NULL);
  c_retval = guppi_seq_categorical_insert(c_seq, c_i, c_s);
  s_retval = gh_bool2scm(c_retval);
  free((gpointer)c_s);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_categorical_frequency = "guppi-seq-categorical-frequency";
static SCM
fn_scm_guppi_seq_categorical_frequency(SCM s_seq, SCM s_s)
{
  GuppiSeqCategorical* c_seq;
  gchar* c_s;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_categorical_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_categorical_frequency);
  SCM_ASSERT(gh_string_p(s_s), s_s, SCM_ARG2, (gchar*)s_scm_guppi_seq_categorical_frequency);
  c_seq = GUPPI_SEQ_CATEGORICAL(scm2guppi_seq_categorical(s_seq));
  c_s = gh_scm2newstr(s_s, NULL);
  c_retval = guppi_seq_categorical_frequency(c_seq, c_s);
  s_retval = gh_int2scm(c_retval);
  free((gpointer)c_s);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_categorical_percentage = "guppi-seq-categorical-percentage";
static SCM
fn_scm_guppi_seq_categorical_percentage(SCM s_seq, SCM s_s)
{
  GuppiSeqCategorical* c_seq;
  gchar* c_s;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_categorical_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_categorical_percentage);
  SCM_ASSERT(gh_string_p(s_s), s_s, SCM_ARG2, (gchar*)s_scm_guppi_seq_categorical_percentage);
  c_seq = GUPPI_SEQ_CATEGORICAL(scm2guppi_seq_categorical(s_seq));
  c_s = gh_scm2newstr(s_s, NULL);
  c_retval = guppi_seq_categorical_percentage(c_seq, c_s);
  s_retval = gh_double2scm(c_retval);
  free((gpointer)c_s);
  return s_retval;
}


gboolean
scm_guppi_seq_string_p(SCM x)
{
  GuppiSeq* foo;
  if (scm_guppi_seq_p(x)) {
    foo = GUPPI_SEQ(scm2guppi_seq(x));
    if (foo != NULL && GUPPI_IS_SEQ_STRING(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_seq_string2scm(GuppiSeqString* x)
{
  return guppi_seq2scm(GUPPI_SEQ(x));
}

GuppiSeqString*
scm2guppi_seq_string(SCM x)
{
  return GUPPI_SEQ_STRING(scm2guppi_seq(x));    
}

static SCM
fn_scm_guppi_seq_string_p(SCM x)
{
  return gh_bool2scm(scm_guppi_seq_string_p(x));
}


static const gchar* s_scm_guppi_seq_string_new = "guppi-seq-string-new";
static SCM
fn_scm_guppi_seq_string_new()
{
  GuppiData* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_seq_string_new();
  s_retval = guppi_data2scm(GUPPI_DATA(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_seq_string_get = "guppi-seq-string-get";
static SCM
fn_scm_guppi_seq_string_get(SCM s_seq, SCM s_index)
{
  GuppiSeqString* c_seq;
  gint c_index;
  const gchar* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_string_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_string_get);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_string_get);
  c_seq = GUPPI_SEQ_STRING(scm2guppi_seq_string(s_seq));
  c_index = gh_scm2int(s_index);
  c_retval = guppi_seq_string_get(c_seq, c_index);
  s_retval = gh_str02scm((gchar*)c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_string_set = "guppi-seq-string-set";
static SCM
fn_scm_guppi_seq_string_set(SCM s_seq, SCM s_index, SCM s_str)
{
  GuppiSeqString* c_seq;
  gint c_index;
  gchar* c_str;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_string_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_string_set);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_string_set);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG3, (gchar*)s_scm_guppi_seq_string_set);
  c_seq = GUPPI_SEQ_STRING(scm2guppi_seq_string(s_seq));
  c_index = gh_scm2int(s_index);
  c_str = gh_scm2newstr(s_str, NULL);
  guppi_seq_string_set(c_seq, c_index, c_str);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_string_prepend = "guppi-seq-string-prepend";
static SCM
fn_scm_guppi_seq_string_prepend(SCM s_seq, SCM s_str)
{
  GuppiSeqString* c_seq;
  gchar* c_str;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_string_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_string_prepend);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG2, (gchar*)s_scm_guppi_seq_string_prepend);
  c_seq = GUPPI_SEQ_STRING(scm2guppi_seq_string(s_seq));
  c_str = gh_scm2newstr(s_str, NULL);
  guppi_seq_string_prepend(c_seq, c_str);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_string_append = "guppi-seq-string-append";
static SCM
fn_scm_guppi_seq_string_append(SCM s_seq, SCM s_str)
{
  GuppiSeqString* c_seq;
  gchar* c_str;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_string_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_string_append);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG2, (gchar*)s_scm_guppi_seq_string_append);
  c_seq = GUPPI_SEQ_STRING(scm2guppi_seq_string(s_seq));
  c_str = gh_scm2newstr(s_str, NULL);
  guppi_seq_string_append(c_seq, c_str);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_string_insert = "guppi-seq-string-insert";
static SCM
fn_scm_guppi_seq_string_insert(SCM s_seq, SCM s_index, SCM s_str)
{
  GuppiSeqString* c_seq;
  gint c_index;
  gchar* c_str;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_string_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_string_insert);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_string_insert);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG3, (gchar*)s_scm_guppi_seq_string_insert);
  c_seq = GUPPI_SEQ_STRING(scm2guppi_seq_string(s_seq));
  c_index = gh_scm2int(s_index);
  c_str = gh_scm2newstr(s_str, NULL);
  guppi_seq_string_insert(c_seq, c_index, c_str);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_string_lookup = "guppi-seq-string-lookup";
static SCM
fn_scm_guppi_seq_string_lookup(SCM s_seq, SCM s_str)
{
  GuppiSeqString* c_seq;
  gchar* c_str;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_string_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_string_lookup);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG2, (gchar*)s_scm_guppi_seq_string_lookup);
  c_seq = GUPPI_SEQ_STRING(scm2guppi_seq_string(s_seq));
  c_str = gh_scm2newstr(s_str, NULL);
  c_retval = guppi_seq_string_lookup(c_seq, c_str);
  s_retval = gh_int2scm(c_retval);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_string_contains = "guppi-seq-string-contains";
static SCM
fn_scm_guppi_seq_string_contains(SCM s_seq, SCM s_str)
{
  GuppiSeqString* c_seq;
  gchar* c_str;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_string_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_string_contains);
  SCM_ASSERT(gh_string_p(s_str), s_str, SCM_ARG2, (gchar*)s_scm_guppi_seq_string_contains);
  c_seq = GUPPI_SEQ_STRING(scm2guppi_seq_string(s_seq));
  c_str = gh_scm2newstr(s_str, NULL);
  c_retval = guppi_seq_string_contains(c_seq, c_str);
  s_retval = gh_bool2scm(c_retval);
  free((gpointer)c_str);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_string_distinct_values = "guppi-seq-string-distinct-values";
static SCM
fn_scm_guppi_seq_string_distinct_values(SCM s_seq)
{
  GuppiSeqString* c_seq;
  gsize c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_string_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_string_distinct_values);
  c_seq = GUPPI_SEQ_STRING(scm2guppi_seq_string(s_seq));
  c_retval = guppi_seq_string_distinct_values(c_seq);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}


gboolean
scm_guppi_seq_boolean_p(SCM x)
{
  GuppiSeq* foo;
  if (scm_guppi_seq_p(x)) {
    foo = GUPPI_SEQ(scm2guppi_seq(x));
    if (foo != NULL && GUPPI_IS_SEQ_BOOLEAN(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_seq_boolean2scm(GuppiSeqBoolean* x)
{
  return guppi_seq2scm(GUPPI_SEQ(x));
}

GuppiSeqBoolean*
scm2guppi_seq_boolean(SCM x)
{
  return GUPPI_SEQ_BOOLEAN(scm2guppi_seq(x));    
}

static SCM
fn_scm_guppi_seq_boolean_p(SCM x)
{
  return gh_bool2scm(scm_guppi_seq_boolean_p(x));
}


static const gchar* s_scm_guppi_seq_boolean_new = "guppi-seq-boolean-new";
static SCM
fn_scm_guppi_seq_boolean_new()
{
  GuppiData* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_seq_boolean_new();
  s_retval = guppi_data2scm(GUPPI_DATA(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_get = "guppi-seq-boolean-get";
static SCM
fn_scm_guppi_seq_boolean_get(SCM s_seq, SCM s_index)
{
  GuppiSeqBoolean* c_seq;
  gint c_index;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_get);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_get);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_index = gh_scm2int(s_index);
  c_retval = guppi_seq_boolean_get(c_seq, c_index);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_set = "guppi-seq-boolean-set";
static SCM
fn_scm_guppi_seq_boolean_set(SCM s_seq, SCM s_index, SCM s_value)
{
  GuppiSeqBoolean* c_seq;
  gint c_index;
  gboolean c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_set);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_set);
  SCM_ASSERT(gh_boolean_p(s_value), s_value, SCM_ARG3, (gchar*)s_scm_guppi_seq_boolean_set);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_index = gh_scm2int(s_index);
  c_value = gh_scm2bool(s_value);
  guppi_seq_boolean_set(c_seq, c_index, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_set_all = "guppi-seq-boolean-set-all";
static SCM
fn_scm_guppi_seq_boolean_set_all(SCM s_seq, SCM s_value)
{
  GuppiSeqBoolean* c_seq;
  gboolean c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_set_all);
  SCM_ASSERT(gh_boolean_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_set_all);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_value = gh_scm2bool(s_value);
  guppi_seq_boolean_set_all(c_seq, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_clear = "guppi-seq-boolean-clear";
static SCM
fn_scm_guppi_seq_boolean_clear(SCM s_seq)
{
  GuppiSeqBoolean* c_seq;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_clear);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  guppi_seq_boolean_clear(c_seq);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_prepend = "guppi-seq-boolean-prepend";
static SCM
fn_scm_guppi_seq_boolean_prepend(SCM s_seq, SCM s_value)
{
  GuppiSeqBoolean* c_seq;
  gboolean c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_prepend);
  SCM_ASSERT(gh_boolean_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_prepend);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_value = gh_scm2bool(s_value);
  guppi_seq_boolean_prepend(c_seq, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_prepend_many = "guppi-seq-boolean-prepend-many";
static SCM
fn_scm_guppi_seq_boolean_prepend_many(SCM s_seq, SCM s_value, SCM s_count)
{
  GuppiSeqBoolean* c_seq;
  gboolean c_value;
  gsize c_count;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_prepend_many);
  SCM_ASSERT(gh_boolean_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_prepend_many);
  SCM_ASSERT((gh_exact_p(s_count) && gh_scm2int(s_count)>=0), s_count, SCM_ARG3, (gchar*)s_scm_guppi_seq_boolean_prepend_many);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_value = gh_scm2bool(s_value);
  c_count = (gsize)gh_scm2int(s_count);
  guppi_seq_boolean_prepend_many(c_seq, c_value, c_count);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_append = "guppi-seq-boolean-append";
static SCM
fn_scm_guppi_seq_boolean_append(SCM s_seq, SCM s_value)
{
  GuppiSeqBoolean* c_seq;
  gboolean c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_append);
  SCM_ASSERT(gh_boolean_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_append);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_value = gh_scm2bool(s_value);
  guppi_seq_boolean_append(c_seq, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_append_many = "guppi-seq-boolean-append-many";
static SCM
fn_scm_guppi_seq_boolean_append_many(SCM s_seq, SCM s_value, SCM s_count)
{
  GuppiSeqBoolean* c_seq;
  gboolean c_value;
  gsize c_count;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_append_many);
  SCM_ASSERT(gh_boolean_p(s_value), s_value, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_append_many);
  SCM_ASSERT((gh_exact_p(s_count) && gh_scm2int(s_count)>=0), s_count, SCM_ARG3, (gchar*)s_scm_guppi_seq_boolean_append_many);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_value = gh_scm2bool(s_value);
  c_count = (gsize)gh_scm2int(s_count);
  guppi_seq_boolean_append_many(c_seq, c_value, c_count);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_insert = "guppi-seq-boolean-insert";
static SCM
fn_scm_guppi_seq_boolean_insert(SCM s_seq, SCM s_index, SCM s_value)
{
  GuppiSeqBoolean* c_seq;
  gint c_index;
  gboolean c_value;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_insert);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_insert);
  SCM_ASSERT(gh_boolean_p(s_value), s_value, SCM_ARG3, (gchar*)s_scm_guppi_seq_boolean_insert);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_index = gh_scm2int(s_index);
  c_value = gh_scm2bool(s_value);
  guppi_seq_boolean_insert(c_seq, c_index, c_value);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_insert_many = "guppi-seq-boolean-insert-many";
static SCM
fn_scm_guppi_seq_boolean_insert_many(SCM s_seq, SCM s_index, SCM s_value, SCM s_count)
{
  GuppiSeqBoolean* c_seq;
  gint c_index;
  gboolean c_value;
  gsize c_count;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_insert_many);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_insert_many);
  SCM_ASSERT(gh_boolean_p(s_value), s_value, SCM_ARG3, (gchar*)s_scm_guppi_seq_boolean_insert_many);
  SCM_ASSERT((gh_exact_p(s_count) && gh_scm2int(s_count)>=0), s_count, SCM_ARG4, (gchar*)s_scm_guppi_seq_boolean_insert_many);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_index = gh_scm2int(s_index);
  c_value = gh_scm2bool(s_value);
  c_count = (gsize)gh_scm2int(s_count);
  guppi_seq_boolean_insert_many(c_seq, c_index, c_value, c_count);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_bitwise_and = "guppi-seq-boolean-bitwise-and";
static SCM
fn_scm_guppi_seq_boolean_bitwise_and(SCM s_seq, SCM s_other_seq)
{
  GuppiSeqBoolean* c_seq;
  GuppiSeqBoolean* c_other_seq;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_bitwise_and);
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_other_seq), s_other_seq, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_bitwise_and);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_other_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_other_seq));
  guppi_seq_boolean_bitwise_and(c_seq, c_other_seq);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_bitwise_or = "guppi-seq-boolean-bitwise-or";
static SCM
fn_scm_guppi_seq_boolean_bitwise_or(SCM s_seq, SCM s_other_seq)
{
  GuppiSeqBoolean* c_seq;
  GuppiSeqBoolean* c_other_seq;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_bitwise_or);
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_other_seq), s_other_seq, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_bitwise_or);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_other_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_other_seq));
  guppi_seq_boolean_bitwise_or(c_seq, c_other_seq);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_bitwise_xor = "guppi-seq-boolean-bitwise-xor";
static SCM
fn_scm_guppi_seq_boolean_bitwise_xor(SCM s_seq, SCM s_other_seq)
{
  GuppiSeqBoolean* c_seq;
  GuppiSeqBoolean* c_other_seq;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_bitwise_xor);
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_other_seq), s_other_seq, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_bitwise_xor);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_other_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_other_seq));
  guppi_seq_boolean_bitwise_xor(c_seq, c_other_seq);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_bitwise_not = "guppi-seq-boolean-bitwise-not";
static SCM
fn_scm_guppi_seq_boolean_bitwise_not(SCM s_seq)
{
  GuppiSeqBoolean* c_seq;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_bitwise_not);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  guppi_seq_boolean_bitwise_not(c_seq);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_first_true = "guppi-seq-boolean-first-true";
static SCM
fn_scm_guppi_seq_boolean_first_true(SCM s_seq)
{
  GuppiSeqBoolean* c_seq;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_first_true);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_retval = guppi_seq_boolean_first_true(c_seq);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_next_true = "guppi-seq-boolean-next-true";
static SCM
fn_scm_guppi_seq_boolean_next_true(SCM s_seq, SCM s_index)
{
  GuppiSeqBoolean* c_seq;
  gint c_index;
  gint c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_next_true);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_boolean_next_true);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_index = gh_scm2int(s_index);
  c_retval = guppi_seq_boolean_next_true(c_seq, c_index);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_boolean_true_count = "guppi-seq-boolean-true-count";
static SCM
fn_scm_guppi_seq_boolean_true_count(SCM s_seq)
{
  GuppiSeqBoolean* c_seq;
  gsize c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_boolean_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_boolean_true_count);
  c_seq = GUPPI_SEQ_BOOLEAN(scm2guppi_seq_boolean(s_seq));
  c_retval = guppi_seq_boolean_true_count(c_seq);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}


gboolean
scm_guppi_seq_data_p(SCM x)
{
  GuppiData* foo;
  if (scm_guppi_data_p(x)) {
    foo = GUPPI_DATA(scm2guppi_data(x));
    if (foo != NULL && GUPPI_IS_SEQ_DATA(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_seq_data2scm(GuppiSeqData* x)
{
  return guppi_data2scm(GUPPI_DATA(x));
}

GuppiSeqData*
scm2guppi_seq_data(SCM x)
{
  return GUPPI_SEQ_DATA(scm2guppi_data(x));    
}

static SCM
fn_scm_guppi_seq_data_p(SCM x)
{
  return gh_bool2scm(scm_guppi_seq_data_p(x));
}


static const gchar* s_scm_guppi_seq_data_new = "guppi-seq-data-new";
static SCM
fn_scm_guppi_seq_data_new()
{
  GuppiData* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_seq_data_new();
  s_retval = guppi_data2scm(GUPPI_DATA(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_seq_data_get = "guppi-seq-data-get";
static SCM
fn_scm_guppi_seq_data_get(SCM s_sd, SCM s_index)
{
  GuppiSeqData* c_sd;
  gint c_index;
  GuppiData* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_data_p(s_sd), s_sd, SCM_ARG1, (gchar*)s_scm_guppi_seq_data_get);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_data_get);
  c_sd = GUPPI_SEQ_DATA(scm2guppi_seq_data(s_sd));
  c_index = gh_scm2int(s_index);
  c_retval = guppi_seq_data_get(c_sd, c_index);
  s_retval = guppi_data2scm(GUPPI_DATA(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_seq_data_set = "guppi-seq-data-set";
static SCM
fn_scm_guppi_seq_data_set(SCM s_sd, SCM s_index, SCM s_data)
{
  GuppiSeqData* c_sd;
  gint c_index;
  GuppiData* c_data;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_data_p(s_sd), s_sd, SCM_ARG1, (gchar*)s_scm_guppi_seq_data_set);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_data_set);
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG3, (gchar*)s_scm_guppi_seq_data_set);
  c_sd = GUPPI_SEQ_DATA(scm2guppi_seq_data(s_sd));
  c_index = gh_scm2int(s_index);
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  guppi_seq_data_set(c_sd, c_index, c_data);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_data_prepend = "guppi-seq-data-prepend";
static SCM
fn_scm_guppi_seq_data_prepend(SCM s_sd, SCM s_data)
{
  GuppiSeqData* c_sd;
  GuppiData* c_data;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_data_p(s_sd), s_sd, SCM_ARG1, (gchar*)s_scm_guppi_seq_data_prepend);
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG2, (gchar*)s_scm_guppi_seq_data_prepend);
  c_sd = GUPPI_SEQ_DATA(scm2guppi_seq_data(s_sd));
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  guppi_seq_data_prepend(c_sd, c_data);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_data_append = "guppi-seq-data-append";
static SCM
fn_scm_guppi_seq_data_append(SCM s_sd, SCM s_data)
{
  GuppiSeqData* c_sd;
  GuppiData* c_data;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_data_p(s_sd), s_sd, SCM_ARG1, (gchar*)s_scm_guppi_seq_data_append);
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG2, (gchar*)s_scm_guppi_seq_data_append);
  c_sd = GUPPI_SEQ_DATA(scm2guppi_seq_data(s_sd));
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  guppi_seq_data_append(c_sd, c_data);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_data_insert = "guppi-seq-data-insert";
static SCM
fn_scm_guppi_seq_data_insert(SCM s_sd, SCM s_index, SCM s_data)
{
  GuppiSeqData* c_sd;
  gint c_index;
  GuppiData* c_data;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_data_p(s_sd), s_sd, SCM_ARG1, (gchar*)s_scm_guppi_seq_data_insert);
  SCM_ASSERT(gh_exact_p(s_index), s_index, SCM_ARG2, (gchar*)s_scm_guppi_seq_data_insert);
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG3, (gchar*)s_scm_guppi_seq_data_insert);
  c_sd = GUPPI_SEQ_DATA(scm2guppi_seq_data(s_sd));
  c_index = gh_scm2int(s_index);
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  guppi_seq_data_insert(c_sd, c_index, c_data);
  return s_retval;
}


gboolean
scm_guppi_curve_p(SCM x)
{
  GuppiData* foo;
  if (scm_guppi_data_p(x)) {
    foo = GUPPI_DATA(scm2guppi_data(x));
    if (foo != NULL && GUPPI_IS_CURVE(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_curve2scm(GuppiCurve* x)
{
  return guppi_data2scm(GUPPI_DATA(x));
}

GuppiCurve*
scm2guppi_curve(SCM x)
{
  return GUPPI_CURVE(scm2guppi_data(x));    
}

static SCM
fn_scm_guppi_curve_p(SCM x)
{
  return gh_bool2scm(scm_guppi_curve_p(x));
}


static const gchar* s_scm_guppi_curve_parameter_lower_bound = "guppi-curve-parameter-lower-bound";
static SCM
fn_scm_guppi_curve_parameter_lower_bound(SCM s_c)
{
  GuppiCurve* c_c;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_curve_p(s_c), s_c, SCM_ARG1, (gchar*)s_scm_guppi_curve_parameter_lower_bound);
  c_c = GUPPI_CURVE(scm2guppi_curve(s_c));
  c_retval = guppi_curve_parameter_lower_bound(c_c);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_curve_parameter_upper_bound = "guppi-curve-parameter-upper-bound";
static SCM
fn_scm_guppi_curve_parameter_upper_bound(SCM s_c)
{
  GuppiCurve* c_c;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_curve_p(s_c), s_c, SCM_ARG1, (gchar*)s_scm_guppi_curve_parameter_upper_bound);
  c_c = GUPPI_CURVE(scm2guppi_curve(s_c));
  c_retval = guppi_curve_parameter_upper_bound(c_c);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_curve_parameter_in_bounds = "guppi-curve-parameter-in-bounds";
static SCM
fn_scm_guppi_curve_parameter_in_bounds(SCM s_c, SCM s_t)
{
  GuppiCurve* c_c;
  double c_t;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_curve_p(s_c), s_c, SCM_ARG1, (gchar*)s_scm_guppi_curve_parameter_in_bounds);
  SCM_ASSERT(gh_number_p(s_t), s_t, SCM_ARG2, (gchar*)s_scm_guppi_curve_parameter_in_bounds);
  c_c = GUPPI_CURVE(scm2guppi_curve(s_c));
  c_t = gh_scm2double(s_t);
  c_retval = guppi_curve_parameter_in_bounds(c_c, c_t);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_curve_clamp_parameter = "guppi-curve-clamp-parameter";
static SCM
fn_scm_guppi_curve_clamp_parameter(SCM s_c, SCM s_t)
{
  GuppiCurve* c_c;
  double c_t;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_curve_p(s_c), s_c, SCM_ARG1, (gchar*)s_scm_guppi_curve_clamp_parameter);
  SCM_ASSERT(gh_number_p(s_t), s_t, SCM_ARG2, (gchar*)s_scm_guppi_curve_clamp_parameter);
  c_c = GUPPI_CURVE(scm2guppi_curve(s_c));
  c_t = gh_scm2double(s_t);
  c_retval = guppi_curve_clamp_parameter(c_c, c_t);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_curve_parameter_01 = "guppi-curve-parameter-01";
static SCM
fn_scm_guppi_curve_parameter_01(SCM s_c, SCM s_t)
{
  GuppiCurve* c_c;
  double c_t;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_curve_p(s_c), s_c, SCM_ARG1, (gchar*)s_scm_guppi_curve_parameter_01);
  SCM_ASSERT(gh_number_p(s_t), s_t, SCM_ARG2, (gchar*)s_scm_guppi_curve_parameter_01);
  c_c = GUPPI_CURVE(scm2guppi_curve(s_c));
  c_t = gh_scm2double(s_t);
  c_retval = guppi_curve_parameter_01(c_c, c_t);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_curve_get_x = "guppi-curve-get-x";
static SCM
fn_scm_guppi_curve_get_x(SCM s_c, SCM s_t)
{
  GuppiCurve* c_c;
  double c_t;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_curve_p(s_c), s_c, SCM_ARG1, (gchar*)s_scm_guppi_curve_get_x);
  SCM_ASSERT(gh_number_p(s_t), s_t, SCM_ARG2, (gchar*)s_scm_guppi_curve_get_x);
  c_c = GUPPI_CURVE(scm2guppi_curve(s_c));
  c_t = gh_scm2double(s_t);
  c_retval = guppi_curve_get_x(c_c, c_t);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_curve_get_y = "guppi-curve-get-y";
static SCM
fn_scm_guppi_curve_get_y(SCM s_c, SCM s_t)
{
  GuppiCurve* c_c;
  double c_t;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_curve_p(s_c), s_c, SCM_ARG1, (gchar*)s_scm_guppi_curve_get_y);
  SCM_ASSERT(gh_number_p(s_t), s_t, SCM_ARG2, (gchar*)s_scm_guppi_curve_get_y);
  c_c = GUPPI_CURVE(scm2guppi_curve(s_c));
  c_t = gh_scm2double(s_t);
  c_retval = guppi_curve_get_y(c_c, c_t);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_curve_get_x_01 = "guppi-curve-get-x-01";
static SCM
fn_scm_guppi_curve_get_x_01(SCM s_c, SCM s_t)
{
  GuppiCurve* c_c;
  double c_t;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_curve_p(s_c), s_c, SCM_ARG1, (gchar*)s_scm_guppi_curve_get_x_01);
  SCM_ASSERT(gh_number_p(s_t), s_t, SCM_ARG2, (gchar*)s_scm_guppi_curve_get_x_01);
  c_c = GUPPI_CURVE(scm2guppi_curve(s_c));
  c_t = gh_scm2double(s_t);
  c_retval = guppi_curve_get_x_01(c_c, c_t);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_curve_get_y_01 = "guppi-curve-get-y-01";
static SCM
fn_scm_guppi_curve_get_y_01(SCM s_c, SCM s_t)
{
  GuppiCurve* c_c;
  double c_t;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_curve_p(s_c), s_c, SCM_ARG1, (gchar*)s_scm_guppi_curve_get_y_01);
  SCM_ASSERT(gh_number_p(s_t), s_t, SCM_ARG2, (gchar*)s_scm_guppi_curve_get_y_01);
  c_c = GUPPI_CURVE(scm2guppi_curve(s_c));
  c_t = gh_scm2double(s_t);
  c_retval = guppi_curve_get_y_01(c_c, c_t);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}


gboolean
scm_guppi_date_indexed_p(SCM x)
{
  GuppiData* foo;
  if (scm_guppi_data_p(x)) {
    foo = GUPPI_DATA(scm2guppi_data(x));
    if (foo != NULL && GUPPI_IS_DATE_INDEXED(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_date_indexed2scm(GuppiDateIndexed* x)
{
  return guppi_data2scm(GUPPI_DATA(x));
}

GuppiDateIndexed*
scm2guppi_date_indexed(SCM x)
{
  return GUPPI_DATE_INDEXED(scm2guppi_data(x));    
}

static SCM
fn_scm_guppi_date_indexed_p(SCM x)
{
  return gh_bool2scm(scm_guppi_date_indexed_p(x));
}



gboolean
scm_guppi_price_series_p(SCM x)
{
  GuppiDateIndexed* foo;
  if (scm_guppi_date_indexed_p(x)) {
    foo = GUPPI_DATE_INDEXED(scm2guppi_date_indexed(x));
    if (foo != NULL && GUPPI_IS_PRICE_SERIES(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_price_series2scm(GuppiPriceSeries* x)
{
  return guppi_date_indexed2scm(GUPPI_DATE_INDEXED(x));
}

GuppiPriceSeries*
scm2guppi_price_series(SCM x)
{
  return GUPPI_PRICE_SERIES(scm2guppi_date_indexed(x));    
}

static SCM
fn_scm_guppi_price_series_p(SCM x)
{
  return gh_bool2scm(scm_guppi_price_series_p(x));
}


static long guppi_data_tree_type_tag;
#define SCM_TO_GUPPI_DATA_TREE(x) (GUPPI_DATA_TREE(SCM_CDR(x)))
#define SCM_GUPPI_DATA_TREE_P(x) (SCM_NIMP(x) && SCM_CAR(x) == guppi_data_tree_type_tag)

gboolean
scm_guppi_data_tree_p(SCM x)
{
    return SCM_GUPPI_DATA_TREE_P(x);
} 

SCM
guppi_data_tree2scm(GuppiDataTree* x)
{
    SCM smob;
    if (x == NULL || !GUPPI_IS_DATA_TREE(x))
	return SCM_UNSPECIFIED;
    SCM_DEFER_INTS;
#ifdef USING_GUILE_1_3_X
    SCM_NEWCELL(smob);
    SCM_SETCAR(smob, guppi_data_tree_type_tag);
    SCM_SETCDR(smob, x);
#else
    SCM_NEWSMOB(smob, guppi_data_tree_type_tag, x);
#endif
    guppi_ref(x);
    guppi_sink(x);
    SCM_ALLOW_INTS;

    return smob;
}

GuppiDataTree*
scm2guppi_data_tree(SCM x)
{
    g_return_val_if_fail(SCM_GUPPI_DATA_TREE_P(x), NULL);
    return SCM_TO_GUPPI_DATA_TREE(x);
}

static SCM
mark_guppi_data_tree(SCM x)
{
    return SCM_BOOL_F;
}

static scm_sizet
free_guppi_data_tree(SCM x)
{
    GuppiDataTree* y = SCM_TO_GUPPI_DATA_TREE(x);
    SCM_DEFER_INTS;
    guppi_unref(y);
    SCM_ALLOW_INTS;

    return 0;
}

static int
print_guppi_data_tree(SCM x, SCM port, scm_print_state* state)
{
    scm_puts("<GuppiDataTree>", port);
    return 1;
}

#ifdef USING_GUILE_1_3_X
static struct scm_smobfuns guppi_data_tree_smob_fns = {
    mark_guppi_data_tree, free_guppi_data_tree, print_guppi_data_tree, NULL
};
#endif

static SCM
fn_scm_guppi_data_tree_p(SCM x)
{
    return gh_bool2scm(SCM_GUPPI_DATA_TREE_P(x));
}


static const gchar* s_scm_guppi_data_tree_new = "guppi-data-tree-new";
static SCM
fn_scm_guppi_data_tree_new()
{
  GuppiDataTree* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_data_tree_new();
  s_retval = guppi_data_tree2scm(GUPPI_DATA_TREE(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_data_tree_add = "guppi-data-tree-add";
static SCM
fn_scm_guppi_data_tree_add(SCM s_tree, SCM s_data)
{
  GuppiDataTree* c_tree;
  GuppiData* c_data;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_tree_p(s_tree), s_tree, SCM_ARG1, (gchar*)s_scm_guppi_data_tree_add);
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG2, (gchar*)s_scm_guppi_data_tree_add);
  c_tree = GUPPI_DATA_TREE(scm2guppi_data_tree(s_tree));
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  guppi_data_tree_add(c_tree, c_data);
  return s_retval;
}

static const gchar* s_scm_guppi_data_tree_add_beside = "guppi-data-tree-add-beside";
static SCM
fn_scm_guppi_data_tree_add_beside(SCM s_tree, SCM s_data, SCM s_data_to_add)
{
  GuppiDataTree* c_tree;
  GuppiData* c_data;
  GuppiData* c_data_to_add;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_tree_p(s_tree), s_tree, SCM_ARG1, (gchar*)s_scm_guppi_data_tree_add_beside);
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG2, (gchar*)s_scm_guppi_data_tree_add_beside);
  SCM_ASSERT(scm_guppi_data_p(s_data_to_add), s_data_to_add, SCM_ARG3, (gchar*)s_scm_guppi_data_tree_add_beside);
  c_tree = GUPPI_DATA_TREE(scm2guppi_data_tree(s_tree));
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  c_data_to_add = GUPPI_DATA(scm2guppi_data(s_data_to_add));
  guppi_data_tree_add_beside(c_tree, c_data, c_data_to_add);
  return s_retval;
}

static const gchar* s_scm_guppi_data_tree_add_below = "guppi-data-tree-add-below";
static SCM
fn_scm_guppi_data_tree_add_below(SCM s_tree, SCM s_data, SCM s_data_to_add)
{
  GuppiDataTree* c_tree;
  GuppiData* c_data;
  GuppiData* c_data_to_add;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_tree_p(s_tree), s_tree, SCM_ARG1, (gchar*)s_scm_guppi_data_tree_add_below);
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG2, (gchar*)s_scm_guppi_data_tree_add_below);
  SCM_ASSERT(scm_guppi_data_p(s_data_to_add), s_data_to_add, SCM_ARG3, (gchar*)s_scm_guppi_data_tree_add_below);
  c_tree = GUPPI_DATA_TREE(scm2guppi_data_tree(s_tree));
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  c_data_to_add = GUPPI_DATA(scm2guppi_data(s_data_to_add));
  guppi_data_tree_add_below(c_tree, c_data, c_data_to_add);
  return s_retval;
}

static const gchar* s_scm_guppi_data_tree_remove = "guppi-data-tree-remove";
static SCM
fn_scm_guppi_data_tree_remove(SCM s_tree, SCM s_data)
{
  GuppiDataTree* c_tree;
  GuppiData* c_data;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_tree_p(s_tree), s_tree, SCM_ARG1, (gchar*)s_scm_guppi_data_tree_remove);
  SCM_ASSERT(scm_guppi_data_p(s_data), s_data, SCM_ARG2, (gchar*)s_scm_guppi_data_tree_remove);
  c_tree = GUPPI_DATA_TREE(scm2guppi_data_tree(s_tree));
  c_data = GUPPI_DATA(scm2guppi_data(s_data));
  guppi_data_tree_remove(c_tree, c_data);
  return s_retval;
}

static const gchar* s_scm_guppi_data_tree_size = "guppi-data-tree-size";
static SCM
fn_scm_guppi_data_tree_size(SCM s_tree)
{
  GuppiDataTree* c_tree;
  gsize c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_tree_p(s_tree), s_tree, SCM_ARG1, (gchar*)s_scm_guppi_data_tree_size);
  c_tree = GUPPI_DATA_TREE(scm2guppi_data_tree(s_tree));
  c_retval = guppi_data_tree_size(c_tree);
  s_retval = gh_int2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_data_tree_main = "guppi-data-tree-main";
static SCM
fn_scm_guppi_data_tree_main()
{
  GuppiDataTree* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_data_tree_main();
  s_retval = guppi_data_tree2scm(GUPPI_DATA_TREE(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_data_tree_spew = "guppi-data-tree-spew";
static SCM
fn_scm_guppi_data_tree_spew(SCM s_tree)
{
  GuppiDataTree* c_tree;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_data_tree_p(s_tree), s_tree, SCM_ARG1, (gchar*)s_scm_guppi_data_tree_spew);
  c_tree = GUPPI_DATA_TREE(scm2guppi_data_tree(s_tree));
  guppi_data_tree_spew(c_tree);
  return s_retval;
}


void
guppi_scm_data_init(void)
{
  static gboolean init = FALSE;

  if (!guppi_guile_is_active())
    return;

  g_return_if_fail(init == FALSE);
  init = TRUE; /* brace matching hack } */

#ifdef USING_GUILE_1_3_X
  guppi_data_type_tag = scm_newsmob(&guppi_data_smob_fns);
#else
  guppi_data_type_tag = scm_make_smob_type("GuppiData", 1);
  scm_set_smob_mark(guppi_data_type_tag, mark_guppi_data);
  scm_set_smob_free(guppi_data_type_tag, free_guppi_data);
  scm_set_smob_print(guppi_data_type_tag, print_guppi_data);
#endif

  scm_make_gsubr("guppi-data?", 1, 0, 0, fn_scm_guppi_data_p);
  scm_make_gsubr((gchar*)s_scm_guppi_data_get_type_name, 1, 0, 0, fn_scm_guppi_data_get_type_name);
  scm_make_gsubr((gchar*)s_scm_guppi_data_get_impl_name, 1, 0, 0, fn_scm_guppi_data_get_impl_name);
  scm_make_gsubr((gchar*)s_scm_guppi_data_get_label, 1, 0, 0, fn_scm_guppi_data_get_label);
  scm_make_gsubr((gchar*)s_scm_guppi_data_set_label, 2, 0, 0, fn_scm_guppi_data_set_label);
  scm_make_gsubr((gchar*)s_scm_guppi_data_is_read_only, 1, 0, 0, fn_scm_guppi_data_is_read_only);
  scm_make_gsubr((gchar*)s_scm_guppi_data_copy, 1, 0, 0, fn_scm_guppi_data_copy);
  scm_make_gsubr((gchar*)s_scm_guppi_data_get_size_in_bytes, 1, 0, 0, fn_scm_guppi_data_get_size_in_bytes);
  scm_make_gsubr((gchar*)s_scm_guppi_data_spew_xml, 1, 0, 0, fn_scm_guppi_data_spew_xml);
  scm_make_gsubr("guppi-struct?", 1, 0, 0, fn_scm_guppi_struct_p);
  scm_make_gsubr((gchar*)s_scm_guppi_struct_new, 0, 0, 0, fn_scm_guppi_struct_new);
  scm_make_gsubr((gchar*)s_scm_guppi_struct_get_field_names, 1, 0, 0, fn_scm_guppi_struct_get_field_names);
  scm_make_gsubr((gchar*)s_scm_guppi_struct_size, 1, 0, 0, fn_scm_guppi_struct_size);
  scm_make_gsubr((gchar*)s_scm_guppi_struct_get, 2, 0, 0, fn_scm_guppi_struct_get);
  scm_make_gsubr((gchar*)s_scm_guppi_struct_set, 3, 0, 0, fn_scm_guppi_struct_set);
  scm_make_gsubr((gchar*)s_scm_guppi_struct_add_free_field, 2, 0, 0, fn_scm_guppi_struct_add_free_field);
  scm_make_gsubr("guppi-category?", 1, 0, 0, fn_scm_guppi_category_p);
  scm_make_gsubr((gchar*)s_scm_guppi_category_new, 0, 0, 0, fn_scm_guppi_category_new);
  scm_make_gsubr((gchar*)s_scm_guppi_category_size, 1, 0, 0, fn_scm_guppi_category_size);
  scm_make_gsubr((gchar*)s_scm_guppi_category_min_code, 1, 0, 0, fn_scm_guppi_category_min_code);
  scm_make_gsubr((gchar*)s_scm_guppi_category_max_code, 1, 0, 0, fn_scm_guppi_category_max_code);
  scm_make_gsubr((gchar*)s_scm_guppi_category_unused_code, 1, 0, 0, fn_scm_guppi_category_unused_code);
  scm_make_gsubr((gchar*)s_scm_guppi_category_define, 3, 0, 0, fn_scm_guppi_category_define);
  scm_make_gsubr((gchar*)s_scm_guppi_category_add_by_name, 2, 0, 0, fn_scm_guppi_category_add_by_name);
  scm_make_gsubr((gchar*)s_scm_guppi_category_contains, 2, 0, 0, fn_scm_guppi_category_contains);
  scm_make_gsubr((gchar*)s_scm_guppi_category_contains_code, 2, 0, 0, fn_scm_guppi_category_contains_code);
  scm_make_gsubr((gchar*)s_scm_guppi_category_find_by_name, 2, 0, 0, fn_scm_guppi_category_find_by_name);
  scm_make_gsubr((gchar*)s_scm_guppi_category_find_by_code, 2, 0, 0, fn_scm_guppi_category_find_by_code);
  scm_make_gsubr((gchar*)s_scm_guppi_category_rename, 3, 0, 0, fn_scm_guppi_category_rename);
  scm_make_gsubr("guppi-seq?", 1, 0, 0, fn_scm_guppi_seq_p);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_size_hint, 2, 0, 0, fn_scm_guppi_seq_size_hint);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_min_index, 1, 0, 0, fn_scm_guppi_seq_min_index);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_max_index, 1, 0, 0, fn_scm_guppi_seq_max_index);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_size, 1, 0, 0, fn_scm_guppi_seq_size);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_count, 1, 0, 0, fn_scm_guppi_seq_count);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_empty, 1, 0, 0, fn_scm_guppi_seq_empty);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_nonempty, 1, 0, 0, fn_scm_guppi_seq_nonempty);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_absent, 1, 0, 0, fn_scm_guppi_seq_absent);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_present, 1, 0, 0, fn_scm_guppi_seq_present);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_in_bounds, 2, 0, 0, fn_scm_guppi_seq_in_bounds);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_contains_bounds, 2, 0, 0, fn_scm_guppi_seq_contains_bounds);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_equal_bounds, 2, 0, 0, fn_scm_guppi_seq_equal_bounds);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_shift_indices, 2, 0, 0, fn_scm_guppi_seq_shift_indices);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_set_min_index, 2, 0, 0, fn_scm_guppi_seq_set_min_index);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_set_max_index, 2, 0, 0, fn_scm_guppi_seq_set_max_index);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_validate, 2, 0, 0, fn_scm_guppi_seq_validate);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_get_string, 2, 0, 0, fn_scm_guppi_seq_get_string);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_set_from_string, 3, 0, 0, fn_scm_guppi_seq_set_from_string);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_insert_from_string, 3, 0, 0, fn_scm_guppi_seq_insert_from_string);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_delete, 2, 0, 0, fn_scm_guppi_seq_delete);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_delete_many, 3, 0, 0, fn_scm_guppi_seq_delete_many);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_delete_range, 3, 0, 0, fn_scm_guppi_seq_delete_range);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_grow_to_include, 2, 0, 0, fn_scm_guppi_seq_grow_to_include);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_grow_to_include_range, 3, 0, 0, fn_scm_guppi_seq_grow_to_include_range);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_grow_to_overlap, 2, 0, 0, fn_scm_guppi_seq_grow_to_overlap);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_has_missing, 1, 0, 0, fn_scm_guppi_seq_has_missing);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_missing_count, 1, 0, 0, fn_scm_guppi_seq_missing_count);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_missing, 2, 0, 0, fn_scm_guppi_seq_missing);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_set_missing, 2, 0, 0, fn_scm_guppi_seq_set_missing);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_insert_missing, 2, 0, 0, fn_scm_guppi_seq_insert_missing);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_prepend_missing, 1, 0, 0, fn_scm_guppi_seq_prepend_missing);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_append_missing, 1, 0, 0, fn_scm_guppi_seq_append_missing);
  scm_make_gsubr("guppi-seq-scalar?", 1, 0, 0, fn_scm_guppi_seq_scalar_p);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_new, 0, 0, 0, fn_scm_guppi_seq_scalar_new);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_get, 2, 0, 0, fn_scm_guppi_seq_scalar_get);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_set, 3, 0, 0, fn_scm_guppi_seq_scalar_set);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_prepend, 2, 0, 0, fn_scm_guppi_seq_scalar_prepend);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_prepend_repeating, 3, 0, 0, fn_scm_guppi_seq_scalar_prepend_repeating);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_append, 2, 0, 0, fn_scm_guppi_seq_scalar_append);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_append_repeating, 3, 0, 0, fn_scm_guppi_seq_scalar_append_repeating);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_insert, 3, 0, 0, fn_scm_guppi_seq_scalar_insert);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_insert_repeating, 4, 0, 0, fn_scm_guppi_seq_scalar_insert_repeating);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_min, 1, 0, 0, fn_scm_guppi_seq_scalar_min);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_max, 1, 0, 0, fn_scm_guppi_seq_scalar_max);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_sum, 1, 0, 0, fn_scm_guppi_seq_scalar_sum);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_sum_abs, 1, 0, 0, fn_scm_guppi_seq_scalar_sum_abs);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_mean, 1, 0, 0, fn_scm_guppi_seq_scalar_mean);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_var, 1, 0, 0, fn_scm_guppi_seq_scalar_var);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_vars, 1, 0, 0, fn_scm_guppi_seq_scalar_vars);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_sdev, 1, 0, 0, fn_scm_guppi_seq_scalar_sdev);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_sdevs, 1, 0, 0, fn_scm_guppi_seq_scalar_sdevs);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_q1, 1, 0, 0, fn_scm_guppi_seq_scalar_q1);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_median, 1, 0, 0, fn_scm_guppi_seq_scalar_median);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_q3, 1, 0, 0, fn_scm_guppi_seq_scalar_q3);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_scalar_percentile, 2, 0, 0, fn_scm_guppi_seq_scalar_percentile);
  scm_make_gsubr("guppi-seq-integer?", 1, 0, 0, fn_scm_guppi_seq_integer_p);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_integer_new, 0, 0, 0, fn_scm_guppi_seq_integer_new);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_integer_get, 2, 0, 0, fn_scm_guppi_seq_integer_get);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_integer_set, 3, 0, 0, fn_scm_guppi_seq_integer_set);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_integer_set_many_dup, 4, 0, 0, fn_scm_guppi_seq_integer_set_many_dup);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_integer_set_all, 2, 0, 0, fn_scm_guppi_seq_integer_set_all);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_integer_prepend, 2, 0, 0, fn_scm_guppi_seq_integer_prepend);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_integer_append, 2, 0, 0, fn_scm_guppi_seq_integer_append);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_integer_insert, 3, 0, 0, fn_scm_guppi_seq_integer_insert);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_integer_min, 1, 0, 0, fn_scm_guppi_seq_integer_min);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_integer_max, 1, 0, 0, fn_scm_guppi_seq_integer_max);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_integer_frequency, 2, 0, 0, fn_scm_guppi_seq_integer_frequency);
  scm_make_gsubr("guppi-seq-categorical?", 1, 0, 0, fn_scm_guppi_seq_categorical_p);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_categorical_new, 0, 0, 0, fn_scm_guppi_seq_categorical_new);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_categorical_category, 1, 0, 0, fn_scm_guppi_seq_categorical_category);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_categorical_set_category, 2, 0, 0, fn_scm_guppi_seq_categorical_set_category);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_categorical_get, 2, 0, 0, fn_scm_guppi_seq_categorical_get);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_categorical_set, 3, 0, 0, fn_scm_guppi_seq_categorical_set);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_categorical_prepend, 2, 0, 0, fn_scm_guppi_seq_categorical_prepend);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_categorical_append, 2, 0, 0, fn_scm_guppi_seq_categorical_append);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_categorical_insert, 3, 0, 0, fn_scm_guppi_seq_categorical_insert);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_categorical_frequency, 2, 0, 0, fn_scm_guppi_seq_categorical_frequency);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_categorical_percentage, 2, 0, 0, fn_scm_guppi_seq_categorical_percentage);
  scm_make_gsubr("guppi-seq-string?", 1, 0, 0, fn_scm_guppi_seq_string_p);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_string_new, 0, 0, 0, fn_scm_guppi_seq_string_new);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_string_get, 2, 0, 0, fn_scm_guppi_seq_string_get);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_string_set, 3, 0, 0, fn_scm_guppi_seq_string_set);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_string_prepend, 2, 0, 0, fn_scm_guppi_seq_string_prepend);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_string_append, 2, 0, 0, fn_scm_guppi_seq_string_append);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_string_insert, 3, 0, 0, fn_scm_guppi_seq_string_insert);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_string_lookup, 2, 0, 0, fn_scm_guppi_seq_string_lookup);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_string_contains, 2, 0, 0, fn_scm_guppi_seq_string_contains);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_string_distinct_values, 1, 0, 0, fn_scm_guppi_seq_string_distinct_values);
  scm_make_gsubr("guppi-seq-boolean?", 1, 0, 0, fn_scm_guppi_seq_boolean_p);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_new, 0, 0, 0, fn_scm_guppi_seq_boolean_new);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_get, 2, 0, 0, fn_scm_guppi_seq_boolean_get);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_set, 3, 0, 0, fn_scm_guppi_seq_boolean_set);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_set_all, 2, 0, 0, fn_scm_guppi_seq_boolean_set_all);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_clear, 1, 0, 0, fn_scm_guppi_seq_boolean_clear);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_prepend, 2, 0, 0, fn_scm_guppi_seq_boolean_prepend);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_prepend_many, 3, 0, 0, fn_scm_guppi_seq_boolean_prepend_many);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_append, 2, 0, 0, fn_scm_guppi_seq_boolean_append);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_append_many, 3, 0, 0, fn_scm_guppi_seq_boolean_append_many);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_insert, 3, 0, 0, fn_scm_guppi_seq_boolean_insert);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_insert_many, 4, 0, 0, fn_scm_guppi_seq_boolean_insert_many);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_bitwise_and, 2, 0, 0, fn_scm_guppi_seq_boolean_bitwise_and);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_bitwise_or, 2, 0, 0, fn_scm_guppi_seq_boolean_bitwise_or);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_bitwise_xor, 2, 0, 0, fn_scm_guppi_seq_boolean_bitwise_xor);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_bitwise_not, 1, 0, 0, fn_scm_guppi_seq_boolean_bitwise_not);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_first_true, 1, 0, 0, fn_scm_guppi_seq_boolean_first_true);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_next_true, 2, 0, 0, fn_scm_guppi_seq_boolean_next_true);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_boolean_true_count, 1, 0, 0, fn_scm_guppi_seq_boolean_true_count);
  scm_make_gsubr("guppi-seq-data?", 1, 0, 0, fn_scm_guppi_seq_data_p);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_data_new, 0, 0, 0, fn_scm_guppi_seq_data_new);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_data_get, 2, 0, 0, fn_scm_guppi_seq_data_get);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_data_set, 3, 0, 0, fn_scm_guppi_seq_data_set);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_data_prepend, 2, 0, 0, fn_scm_guppi_seq_data_prepend);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_data_append, 2, 0, 0, fn_scm_guppi_seq_data_append);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_data_insert, 3, 0, 0, fn_scm_guppi_seq_data_insert);
  scm_make_gsubr("guppi-curve?", 1, 0, 0, fn_scm_guppi_curve_p);
  scm_make_gsubr((gchar*)s_scm_guppi_curve_parameter_lower_bound, 1, 0, 0, fn_scm_guppi_curve_parameter_lower_bound);
  scm_make_gsubr((gchar*)s_scm_guppi_curve_parameter_upper_bound, 1, 0, 0, fn_scm_guppi_curve_parameter_upper_bound);
  scm_make_gsubr((gchar*)s_scm_guppi_curve_parameter_in_bounds, 2, 0, 0, fn_scm_guppi_curve_parameter_in_bounds);
  scm_make_gsubr((gchar*)s_scm_guppi_curve_clamp_parameter, 2, 0, 0, fn_scm_guppi_curve_clamp_parameter);
  scm_make_gsubr((gchar*)s_scm_guppi_curve_parameter_01, 2, 0, 0, fn_scm_guppi_curve_parameter_01);
  scm_make_gsubr((gchar*)s_scm_guppi_curve_get_x, 2, 0, 0, fn_scm_guppi_curve_get_x);
  scm_make_gsubr((gchar*)s_scm_guppi_curve_get_y, 2, 0, 0, fn_scm_guppi_curve_get_y);
  scm_make_gsubr((gchar*)s_scm_guppi_curve_get_x_01, 2, 0, 0, fn_scm_guppi_curve_get_x_01);
  scm_make_gsubr((gchar*)s_scm_guppi_curve_get_y_01, 2, 0, 0, fn_scm_guppi_curve_get_y_01);
  scm_make_gsubr("guppi-date-indexed?", 1, 0, 0, fn_scm_guppi_date_indexed_p);
  scm_make_gsubr("guppi-price-series?", 1, 0, 0, fn_scm_guppi_price_series_p);
#ifdef USING_GUILE_1_3_X
  guppi_data_tree_type_tag = scm_newsmob(&guppi_data_tree_smob_fns);
#else
  guppi_data_tree_type_tag = scm_make_smob_type("GuppiDataTree", 1);
  scm_set_smob_mark(guppi_data_tree_type_tag, mark_guppi_data_tree);
  scm_set_smob_free(guppi_data_tree_type_tag, free_guppi_data_tree);
  scm_set_smob_print(guppi_data_tree_type_tag, print_guppi_data_tree);
#endif

  scm_make_gsubr("guppi-data-tree?", 1, 0, 0, fn_scm_guppi_data_tree_p);
  scm_make_gsubr((gchar*)s_scm_guppi_data_tree_new, 0, 0, 0, fn_scm_guppi_data_tree_new);
  scm_make_gsubr((gchar*)s_scm_guppi_data_tree_add, 2, 0, 0, fn_scm_guppi_data_tree_add);
  scm_make_gsubr((gchar*)s_scm_guppi_data_tree_add_beside, 3, 0, 0, fn_scm_guppi_data_tree_add_beside);
  scm_make_gsubr((gchar*)s_scm_guppi_data_tree_add_below, 3, 0, 0, fn_scm_guppi_data_tree_add_below);
  scm_make_gsubr((gchar*)s_scm_guppi_data_tree_remove, 2, 0, 0, fn_scm_guppi_data_tree_remove);
  scm_make_gsubr((gchar*)s_scm_guppi_data_tree_size, 1, 0, 0, fn_scm_guppi_data_tree_size);
  scm_make_gsubr((gchar*)s_scm_guppi_data_tree_main, 0, 0, 0, fn_scm_guppi_data_tree_main);
  scm_make_gsubr((gchar*)s_scm_guppi_data_tree_spew, 1, 0, 0, fn_scm_guppi_data_tree_spew);
}
