/* This is -*- C -*- */
/* $Id: guppi-seq-scalar-impl.h,v 1.15 2000/10/27 18:22:58 trow Exp $ */

/*
 * guppi-seq-scalar-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SEQ_SCALAR_IMPL_H
#define _INC_GUPPI_SEQ_SCALAR_IMPL_H

#include <gtk/gtk.h>

#include "guppi-seq-impl.h"
#include "guppi-seq-boolean.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

typedef struct _GuppiSeqScalarImpl GuppiSeqScalarImpl;

struct _GuppiSeqScalarImpl {
  GuppiSeqImpl parent;
};

typedef struct {
  GuppiSeqImplClass parent_class;

  /* Virtual functions */

  void (*range) (const GuppiSeqScalarImpl *, double *min, double *max);
  double (*sum) (const GuppiSeqScalarImpl *);
  double (*var) (const GuppiSeqScalarImpl *);
  gboolean (*quartiles) (const GuppiSeqScalarImpl *,
			 double *q1, double *med, double *q3);
  gboolean (*percentile) (const GuppiSeqScalarImpl *, double p, double *x);

  double (*get) (const GuppiSeqScalarImpl *, gint);
  void (*set) (GuppiSeqScalarImpl *, gint, double);
  void (*set_many) (GuppiSeqScalarImpl *, gint start,
		    gconstpointer, gint stride, gsize N);
  void (*insert) (GuppiSeqScalarImpl *, gint, double);
  void (*insert_many) (GuppiSeqScalarImpl *, gint,
		       gconstpointer, gint stride, gsize N);

    gint (*range_query) (const GuppiSeqScalarImpl *, GuppiSeqBoolean *,
			 double min, double max, gboolean do_and);

    gconstpointer (*raw_access) (const GuppiSeqScalarImpl *, gint *);

} GuppiSeqScalarImplClass;

#define GUPPI_TYPE_SEQ_SCALAR_IMPL (guppi_seq_scalar_impl_get_type())
#define GUPPI_SEQ_SCALAR_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ_SCALAR_IMPL,GuppiSeqScalarImpl))
#define GUPPI_SEQ_SCALAR_IMPL0(obj) ((obj) ? (GUPPI_SEQ_SCALAR_IMPL(obj)) : NULL)
#define GUPPI_SEQ_SCALAR_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ_SCALAR_IMPL,GuppiSeqScalarImplClass))
#define GUPPI_IS_SEQ_SCALAR_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ_SCALAR_IMPL))
#define GUPPI_IS_SEQ_SCALAR_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ_SCALAR_IMPL(obj)))
#define GUPPI_IS_SEQ_SCALAR_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ_SCALAR_IMPL))

GtkType guppi_seq_scalar_impl_get_type (void);

GtkObject *guppi_seq_scalar_impl_new (void);



END_GUPPI_DECLS

#endif /* _INC_GUPPI_SEQ_SCALAR_IMPL_H */

/* $Id: guppi-seq-scalar-impl.h,v 1.15 2000/10/27 18:22:58 trow Exp $ */
