/* This is -*- C -*- */
/* $Id: guppi-layout.h,v 1.12 2000/10/27 18:23:00 trow Exp $ */

/*
 * guppi-layout.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_LAYOUT_H
#define _INC_GUPPI_LAYOUT_H

#include <gnome.h>
#include "guppi-geometry.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

typedef struct _GuppiLayout GuppiLayout;
typedef struct _GuppiLayoutClass GuppiLayoutClass;

struct _GuppiLayout {
  GtkObject parent;
  gpointer opaque_internals;
};

struct _GuppiLayoutClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_LAYOUT (guppi_layout_get_type())
#define GUPPI_LAYOUT(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_LAYOUT,GuppiLayout))
#define GUPPI_LAYOUT0(obj) ((obj) ? (GUPPI_LAYOUT(obj)) : NULL)
#define GUPPI_LAYOUT_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_LAYOUT,GuppiLayoutClass))
#define GUPPI_IS_LAYOUT(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_LAYOUT))
#define GUPPI_IS_LAYOUT0(obj) (((obj) == NULL) || (GUPPI_IS_LAYOUT(obj)))
#define GUPPI_IS_LAYOUT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_LAYOUT))

GtkType guppi_layout_get_type (void);

GuppiLayout *guppi_layout_new (void);
GuppiLayout *guppi_layout_copy (GuppiLayout *);

GuppiLayout *guppi_layout_clone_converted (GuppiLayout *,
					   GHashTable * conversion_table);

void guppi_layout_connect_geometry (GuppiLayout *, GuppiGeometry *);

/* Various rules */

/***** Size objects according to self-computed values *****/

void guppi_layout_natural_width (GuppiLayout *, GuppiGeometry *);
void guppi_layout_natural_height (GuppiLayout *, GuppiGeometry *);

/***** Position objects relative to total area *****/

/* Align our edges relative to the total size of our area, on a
   percentage basis. */
void guppi_layout_left_edge_relative (GuppiLayout *, GuppiGeometry *,
				      double p);
void guppi_layout_right_edge_relative (GuppiLayout *, GuppiGeometry *,
				       double p);
void guppi_layout_top_edge_relative (GuppiLayout *, GuppiGeometry *,
				     double p);
void guppi_layout_bottom_edge_relative (GuppiLayout *, GuppiGeometry *,
					double p);

/* Align along the edges of the area. */
void guppi_layout_flush_left (GuppiLayout *, GuppiGeometry *, double margin);
void guppi_layout_flush_right (GuppiLayout *, GuppiGeometry *, double margin);
void guppi_layout_flush_top (GuppiLayout *, GuppiGeometry *, double margin);
void guppi_layout_flush_bottom (GuppiLayout *, GuppiGeometry *,
				double margin);

/* Set width/height as % of total area's width/height. */
void guppi_layout_width_relative (GuppiLayout *, GuppiGeometry *,
				  double perc);
void guppi_layout_height_relative (GuppiLayout *, GuppiGeometry *,
				   double perc);

/* Center relative to the total area. */
void guppi_layout_center_horizontally (GuppiLayout *, GuppiGeometry *);
void guppi_layout_center_vertically (GuppiLayout *, GuppiGeometry *);


void guppi_layout_horizontal_fill (GuppiLayout *, GuppiGeometry *,
				   double l_margin, double r_margin);
void guppi_layout_vertical_fill (GuppiLayout *, GuppiGeometry *,
				 double t_margin, double b_margin);

/***** Position objects relative to one another *****/

void guppi_layout_aligned_left_edge (GuppiLayout *,
				     GuppiGeometry *, GuppiGeometry *);

void guppi_layout_aligned_right_edge (GuppiLayout *,
				      GuppiGeometry *, GuppiGeometry *);

void guppi_layout_aligned_top_edge (GuppiLayout *,
				    GuppiGeometry *, GuppiGeometry *);

void guppi_layout_aligned_bottom_edge (GuppiLayout *,
				       GuppiGeometry *, GuppiGeometry *);

void guppi_layout_horizontally_adjacent (GuppiLayout *,
					 GuppiGeometry * left,
					 GuppiGeometry * right, double gap);

void guppi_layout_vertically_adjacent (GuppiLayout *,
				       GuppiGeometry * upper,
				       GuppiGeometry * lower, double gap);

/* horiz adjacency + aligned top & bottom edges */
void guppi_layout_hbox2 (GuppiLayout *,
			 GuppiGeometry * left,
			 GuppiGeometry * right, double gap);

void guppi_layout_hbox3 (GuppiLayout *,
			 GuppiGeometry * left,
			 GuppiGeometry * center,
			 GuppiGeometry * right, double gap);

/* vert adjacency + aligned left & right edges */
void guppi_layout_vbox2 (GuppiLayout *,
			 GuppiGeometry * upper,
			 GuppiGeometry * lower, double gap);

void guppi_layout_vbox3 (GuppiLayout *,
			 GuppiGeometry * upper,
			 GuppiGeometry * center,
			 GuppiGeometry * lower, double gap);


/* width(a) / width(b) = ratio */
void guppi_layout_width_ratio (GuppiLayout *,
			       GuppiGeometry * a, GuppiGeometry * b,
			       double ratio);

/* height(a) / height(b) = ratio */
void guppi_layout_height_ratio (GuppiLayout *,
				GuppiGeometry * a, GuppiGeometry * b,
				double ratio);

/* width(a) / height(a) = aspect_ratio */
void guppi_layout_aspect_ratio (GuppiLayout *, GuppiGeometry * a,
				double ratio);

#define guppi_layout_same_width(lay, a, b) \
  guppi_layout_width_ratio((lay), (a), (b), 1.0)

#define guppi_layout_same_height(lay, a, b) \
  guppi_layout_height_ratio((lay), (a), (b), 1.0)

void guppi_layout_width_equals_height (GuppiLayout *,
				       GuppiGeometry * make_this_ones_width,
				       GuppiGeometry *
				       equal_this_ones_height);

#define guppi_layout_same_size(lay, a, b) \
{ guppi_layout_same_width((lay),(a),(b)); \
  guppi_layout_same_height((lay),(a),(b)); }

#define guppi_layout_same_place(lay, a, b) \
{ guppi_layout_same_size((lay), (a), (b)); \
  guppi_layout_aligned_left_edge((lay), (a), (b)); \
  guppi_layout_aligned_top_edge((lay), (a), (b)); }

void guppi_layout_same_x_center (GuppiLayout *, GuppiGeometry *,
				 GuppiGeometry *);

void guppi_layout_same_y_center (GuppiLayout *, GuppiGeometry *,
				 GuppiGeometry *);


/* Removal methods */

void guppi_layout_remove (GuppiLayout *, GuppiGeometry *);
void guppi_layout_replace (GuppiLayout *,
			   GuppiGeometry * old, GuppiGeometry * nuevo);

/* Do layout according to rules. */

void guppi_layout_bounds (GuppiLayout *,
			  double *x0, double *y0, double *x1, double *y1);

void guppi_layout_set_bounds (GuppiLayout *,
			      double x0, double y0, double x1, double y1);
void guppi_layout_set_bounds_from_geometry (GuppiLayout *, GuppiGeometry *);

void guppi_layout_calc (GuppiLayout *);
void guppi_layout_calc_delayed (GuppiLayout *);
void guppi_layout_calc_flush (GuppiLayout *);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_LAYOUT_H */

/* $Id: guppi-layout.h,v 1.12 2000/10/27 18:23:00 trow Exp $ */
