/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-attributes-xml.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_ATTRIBUTES_XML_H
#define _INC_GUPPI_ATTRIBUTES_XML_H

#include <gtk/gtk.h>
#include <guppi-defs.h>
#include "guppi-context-xml.h"

BEGIN_GUPPI_DECLS

enum {
  GUPPI_AX_INVALID = 0,
  GUPPI_AX_INT,
  GUPPI_AX_UINT32,
  GUPPI_AX_DOUBLE,
  GUPPI_AX_STRING,
  GUPPI_AX_BOOLEAN,
  GUPPI_AX_DATE,
  GUPPI_AX_POINTER,
  GUPPI_AX_LAST_TYPE
};

typedef struct _GuppiAttributesXML GuppiAttributesXML;
typedef struct _GuppiAttributesXMLClass GuppiAttributesXMLClass;

struct _GuppiAttributesXML {
  GtkObject parent;

  GHashTable *attr_table;
};

struct _GuppiAttributesXMLClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_ATTRIBUTES_XML (guppi_attributes_xml_get_type ())
#define GUPPI_ATTRIBUTES_XML(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_ATTRIBUTES_XML,GuppiAttributesXML))
#define GUPPI_ATTRIBUTES_XML0(obj) ((obj) ? (GUPPI_ATTRIBUTES_XML(obj)) : NULL)
#define GUPPI_ATTRIBUTES_XML_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_ATTRIBUTES_XML,GuppiAttributesXMLClass))
#define GUPPI_IS_ATTRIBUTES_XML(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_ATTRIBUTES_XML))
#define GUPPI_IS_ATTRIBUTES_XML0(obj) (((obj) == NULL) || (GUPPI_IS_ATTRIBUTES_XML(obj)))
#define GUPPI_IS_ATTRIBUTES_XML_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_ATTRIBUTES_XML))

GtkType guppi_attributes_xml_get_type (void);

GuppiAttributesXML *guppi_attributes_xml_new (void);


gboolean guppi_attributes_xml_declare (GuppiAttributesXML *,
				       const gchar *name,
				       gint type);
gboolean guppi_attributes_xml_declared (GuppiAttributesXML *,
					const gchar *name);
gint guppi_attributes_xml_declared_type (GuppiAttributesXML *,
					 const gchar *name);
void guppi_attributes_xml_undeclare (GuppiAttributesXML *,
				     const gchar *name);

gboolean guppi_attributes_xml_defined (GuppiAttributesXML *,
				       const gchar *name);
void guppi_attributes_xml_undef (GuppiAttributesXML *,
				 const gchar *name);

void guppi_attributes_xml_set_special_import_context (GuppiAttributesXML *,
						      const gchar *name,
						      GuppiContextXML *);

void guppi_attributes_xml_declare_string (GuppiAttributesXML *,
					  const gchar *name);
const gchar *guppi_attributes_xml_get_string (GuppiAttributesXML *,
					      const gchar* name);
void guppi_attributes_xml_set_string (GuppiAttributesXML *,
				      const gchar *name,
				      const gchar *str);

void guppi_attributes_xml_declare_int (GuppiAttributesXML *,
				       const gchar* name);
gint guppi_attributes_xml_get_int (GuppiAttributesXML *,
				   const gchar *name);
void guppi_attributes_xml_set_int (GuppiAttributesXML *,
				   const gchar *name,
				   gint n);

void guppi_attributes_xml_declare_uint32 (GuppiAttributesXML *,
					  const gchar* name);
guint32 guppi_attributes_xml_get_uint32 (GuppiAttributesXML *,
					 const gchar *name);
void guppi_attributes_xml_set_uint32 (GuppiAttributesXML *,
				      const gchar *name,
				      guint32 n);

void guppi_attributes_xml_declare_double (GuppiAttributesXML *,
					  const gchar *name);
double guppi_attributes_xml_get_double (GuppiAttributesXML *,
					const gchar *name);
void guppi_attributes_xml_set_double (GuppiAttributesXML *,
				      const gchar *name,
				      double x);

void guppi_attributes_xml_declare_boolean (GuppiAttributesXML *,
					   const gchar *name);
gboolean guppi_attributes_xml_get_boolean (GuppiAttributesXML *,
					   const gchar *name);
void guppi_attributes_xml_set_boolean (GuppiAttributesXML *,
				       const gchar *name,
				       gboolean);

void guppi_attributes_xml_declare_date (GuppiAttributesXML *,
					const gchar *name);
const GDate *guppi_attributes_xml_get_date (GuppiAttributesXML *,
					    const gchar *name);
void guppi_attributes_xml_set_date (GuppiAttributesXML *,
				    const gchar *name,
				    const GDate *dt);

void guppi_attributes_xml_declare_pointer (GuppiAttributesXML *,
					   const gchar *name);
gpointer guppi_attributes_xml_get_pointer (GuppiAttributesXML *,
					   const gchar *name);
void guppi_attributes_xml_set_pointer (GuppiAttributesXML *,
				       const gchar *name,
				       gpointer ptr);
void guppi_attributes_xml_set_pointer_free (GuppiAttributesXML *,
					    const gchar *name,
					    gpointer ptr);
void guppi_attributes_xml_set_pointer_unref (GuppiAttributesXML *,
					     const gchar *name,
					     gpointer ptr);
void guppi_attributes_xml_set_pointer_destroy_fn (GuppiAttributesXML *,
						  const gchar *name,
						  gpointer ptr,
						  void (*dest_fn) (gpointer));

GuppiContextXML *guppi_attributes_xml_build_context (GuppiAttributesXML *);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_ATTRIBUTES_XML_H */

/* $Id: guppi-attributes-xml.h,v 1.3 2000/11/22 21:42:51 trow Exp $ */
