/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-category-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CATEGORY_IMPL_H
#define _INC_GUPPI_CATEGORY_IMPL_H

#include <gtk/gtk.h>
#include <guppi-defs.h>
#include "guppi-category.h"	/* We need the def of code_t from here */
#include "guppi-data-impl.h"

BEGIN_GUPPI_DECLS 

typedef struct _GuppiCategoryImpl GuppiCategoryImpl;
typedef struct _GuppiCategoryImplClass GuppiCategoryImplClass;

struct _GuppiCategoryImpl {
  GuppiDataImpl parent;
};

struct _GuppiCategoryImplClass {
  GuppiDataImplClass parent_class;

    gsize (*size) (GuppiCategoryImpl *);
  void (*codes) (GuppiCategoryImpl *, code_t * min, code_t * max,
		 code_t * unused);
  void (*define) (GuppiCategoryImpl *, gchar *, code_t);
  const gchar *(*code2name) (GuppiCategoryImpl *, code_t);
    code_t (*name2code) (GuppiCategoryImpl *, const gchar *);
  void (*foreach) (GuppiCategoryImpl *, GuppiCategoryFn, gpointer);
};

#define GUPPI_TYPE_CATEGORY_IMPL (guppi_category_impl_get_type ())
#define GUPPI_CATEGORY_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_CATEGORY_IMPL,GuppiCategoryImpl))
#define GUPPI_CATEGORY_IMPL0(obj) ((obj) ? (GUPPI_CATEGORY_IMPL(obj)) : NULL)
#define GUPPI_CATEGORY_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_CATEGORY_IMPL,GuppiCategoryImplClass))
#define GUPPI_IS_CATEGORY_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_CATEGORY_IMPL))
#define GUPPI_IS_CATEGORY_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_CATEGORY_IMPL(obj)))
#define GUPPI_IS_CATEGORY_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_CATEGORY_IMPL))

GtkType guppi_category_impl_get_type (void);

GtkObject *guppi_category_impl_new (void);



END_GUPPI_DECLS

#endif /* _INC_GUPPI_CATEGORY_IMPL_H */

/* $Id: guppi-category-impl.h,v 1.4 2000/11/12 04:26:46 trow Exp $ */
