/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-date-indexed-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_DATE_INDEXED_IMPL_H
#define _INC_GUPPI_DATE_INDEXED_IMPL_H

#include <gtk/gtk.h>
#include <guppi-defs.h>
#include "guppi-data-impl.h"

BEGIN_GUPPI_DECLS

typedef struct _GuppiDateIndexedImpl GuppiDateIndexedImpl;
typedef struct _GuppiDateIndexedImplClass GuppiDateIndexedImplClass;

struct _GuppiDateIndexedImpl {
  GuppiDataImpl parent;
};

struct _GuppiDateIndexedImplClass {
  GuppiDataImplClass parent_class;

  void (*bounds) (GuppiDateIndexedImpl *impl, GDate *start, GDate *end);
  gboolean (*valid) (GuppiDateIndexedImpl *impl, const GDate *dt);
  gboolean (*step) (GuppiDateIndexedImpl *impl, const GDate *orig,
		    gint delta, GDate *modified);
  gint (*size) (GuppiDateIndexedImpl *impl);

  void (*bounds_hint) (GuppiDateIndexedImpl *impl,
		       const GDate *start, const GDate *end);
};

#define GUPPI_TYPE_DATE_INDEXED_IMPL (guppi_date_indexed_impl_get_type ())
#define GUPPI_DATE_INDEXED_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_DATE_INDEXED_IMPL,GuppiDateIndexedImpl))
#define GUPPI_DATE_INDEXED_IMPL0(obj) ((obj) ? (GUPPI_DATE_INDEXED_IMPL(obj)) : NULL)
#define GUPPI_DATE_INDEXED_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_DATE_INDEXED_IMPL,GuppiDateIndexedImplClass))
#define GUPPI_IS_DATE_INDEXED_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_DATE_INDEXED_IMPL))
#define GUPPI_IS_DATE_INDEXED_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_DATE_INDEXED_IMPL(obj)))
#define GUPPI_IS_DATE_INDEXED_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_DATE_INDEXED_IMPL))

GtkType guppi_date_indexed_impl_get_type (void);


END_GUPPI_DECLS

#endif /* _INC_GUPPI_DATE_INDEXED_IMPL_H */

/* $Id: guppi-date-indexed-impl.h,v 1.2 2000/11/12 04:26:47 trow Exp $ */
