/* This is -*- C -*- */
/* $Id: guppi-seq-scalar.h,v 1.18 2000/10/27 18:22:59 trow Exp $ */

/*
 * guppi-seq-scalar.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SEQ_SCALAR_H
#define _INC_GUPPI_SEQ_SCALAR_H

#include <gtk/gtk.h>
#include "guppi-seq.h"
#include "guppi-seq-boolean.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiSeqScalar GuppiSeqScalar;
typedef struct _GuppiSeqScalarClass GuppiSeqScalarClass;

struct _GuppiSeqScalar {
  GuppiSeq parent;
  gpointer opaque_internals;
};

struct _GuppiSeqScalarClass {
  GuppiSeqClass parent_class;
};

#define GUPPI_TYPE_SEQ_SCALAR (guppi_seq_scalar_get_type())
#define GUPPI_SEQ_SCALAR(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ_SCALAR,GuppiSeqScalar))
#define GUPPI_SEQ_SCALAR0(obj) ((obj) ? (GUPPI_SEQ_SCALAR(obj)) : NULL)
#define GUPPI_SEQ_SCALAR_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ_SCALAR,GuppiSeqScalarClass))
#define GUPPI_IS_SEQ_SCALAR(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ_SCALAR))
#define GUPPI_IS_SEQ_SCALAR0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ_SCALAR(obj)))
#define GUPPI_IS_SEQ_SCALAR_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ_SCALAR))

GtkType guppi_seq_scalar_get_type (void);

GuppiData *guppi_seq_scalar_new (void);

double guppi_seq_scalar_get (const GuppiSeqScalar *, gint);
void guppi_seq_scalar_set (GuppiSeqScalar *, gint, double);
void guppi_seq_scalar_set_many (GuppiSeqScalar *, gint start,
				const double *vals, gint stride, gsize);

void guppi_seq_scalar_prepend (GuppiSeqScalar *, double);
void guppi_seq_scalar_prepend_many (GuppiSeqScalar *,
				    gconstpointer, gint stride, gsize);
void guppi_seq_scalar_prepend_repeating (GuppiSeqScalar *, double, gsize);

void guppi_seq_scalar_append (GuppiSeqScalar *, double);
void guppi_seq_scalar_append_many (GuppiSeqScalar *,
				   gconstpointer, gint stride, gsize);
void guppi_seq_scalar_append_repeating (GuppiSeqScalar *, double, gsize);

void guppi_seq_scalar_insert (GuppiSeqScalar *, gint, double);
void guppi_seq_scalar_insert_many (GuppiSeqScalar *, gint i,
				   gconstpointer, gint stride, gsize N);
void guppi_seq_scalar_insert_repeating (GuppiSeqScalar *, gint i,
					double x, gsize N);

GuppiSeqBoolean *guppi_seq_scalar_range_query (GuppiSeqScalar *,
					       double min, double max);
gint guppi_seq_scalar_in_place_range_query (GuppiSeqScalar *,
					    GuppiSeqBoolean *,
					    double min, double max);
gint guppi_seq_scalar_bitwise_and_range_query (GuppiSeqScalar *,
					       GuppiSeqBoolean *,
					       double min, double max);

double guppi_seq_scalar_min (GuppiSeqScalar *);
double guppi_seq_scalar_max (GuppiSeqScalar *);
double guppi_seq_scalar_sum (GuppiSeqScalar *);
double guppi_seq_scalar_sum_abs (GuppiSeqScalar *);
double guppi_seq_scalar_mean (GuppiSeqScalar *);
double guppi_seq_scalar_var (GuppiSeqScalar *);
double guppi_seq_scalar_vars (GuppiSeqScalar *);
double guppi_seq_scalar_sdev (GuppiSeqScalar *);
double guppi_seq_scalar_sdevs (GuppiSeqScalar *);
double guppi_seq_scalar_q1 (GuppiSeqScalar *);
double guppi_seq_scalar_median (GuppiSeqScalar *);
double guppi_seq_scalar_q3 (GuppiSeqScalar *);
double guppi_seq_scalar_percentile (GuppiSeqScalar *, double p);

gconstpointer guppi_seq_scalar_raw (const GuppiSeqScalar *, gint *stride);

#define guppi_seq_scalar_raw_get(ptr, str, i) \
(*(const double *)(((gchar *)ptr)+(str)*(i)))


END_GUPPI_DECLS

#endif /* _INC_GUPPI_SEQ_SCALAR_H */

/* $Id: guppi-seq-scalar.h,v 1.18 2000/10/27 18:22:59 trow Exp $ */
