/* This is -*- C -*- */
/* $Id: guppi-struct-impl.h,v 1.8 2000/11/18 02:53:21 trow Exp $ */

/*
 * guppi-struct-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_STRUCT_IMPL_H
#define _INC_GUPPI_STRUCT_IMPL_H

#include <gtk/gtk.h>

#include "guppi-struct.h"
#include "guppi-data-impl.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

typedef struct _GuppiStructImpl GuppiStructImpl;

struct _GuppiStructImpl {
  GuppiDataImpl parent;
};

typedef struct {
  GuppiDataImplClass parent_class;
  
  gboolean (*add_field) (GuppiStructImpl *, const gchar *, GtkType);
  gchar **(*get_names) (const GuppiStructImpl *);
  gsize (*get_size) (const GuppiStructImpl *);
  GtkType (*field_type) (const GuppiStructImpl *, const gchar *);
  
  GuppiData *(*get) (const GuppiStructImpl *, const gchar *);
  gboolean (*set) (GuppiStructImpl *, const gchar *, GuppiData *);

  void (*foreach) (GuppiStructImpl *,
		   void (*fn) (const gchar *name, GuppiData *, gpointer),
		   gpointer);
		   

} GuppiStructImplClass;

#define GUPPI_TYPE_STRUCT_IMPL (guppi_struct_impl_get_type())
#define GUPPI_STRUCT_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_STRUCT_IMPL,GuppiStructImpl))
#define GUPPI_STRUCT_IMPL0(obj) ((obj) ? (GUPPI_STRUCT_IMPL(obj)) : NULL)
#define GUPPI_STRUCT_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_STRUCT_IMPL,GuppiStructImplClass))
#define GUPPI_IS_STRUCT_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_STRUCT_IMPL))
#define GUPPI_IS_STRUCT_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_STRUCT_IMPL(obj)))
#define GUPPI_IS_STRUCT_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_STRUCT_IMPL))

GtkType guppi_struct_impl_get_type (void);

GtkObject *guppi_struct_impl_new (void);



END_GUPPI_DECLS

#endif /* _INC_GUPPI_STRUCT_IMPL_H */

/* $Id: guppi-struct-impl.h,v 1.8 2000/11/18 02:53:21 trow Exp $ */
