/* This is -*- C -*- */
/* $Id: guppi-seq-style.c,v 1.5 2000/10/20 01:21:48 trow Exp $ */

/*
 * guppi-seq-object.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <gnome.h>
#include <guppi-useful.h>
#include "guppi-seq-style.h"
#include <guppi-seq-object.h>
#include <guppi-seq-object-impl.h>

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_seq_style_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_style_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_style_finalize (GtkObject * obj)
{
  GuppiStyle *sty;
  gint i, i0, i1;

  guppi_seq_indices (GUPPI_SEQ (obj), &i0, &i1);
  for (i = i0; i <= i1; ++i) {
    sty = guppi_seq_style_get (GUPPI_SEQ_STYLE (obj), i);
    if (sty)
      gtk_signal_disconnect_by_func (GTK_OBJECT (sty), guppi_data_touch, obj);
  }

  if (parent_class->finalize)
    parent_class->finalize (obj);
}

static void
changed_delete (GuppiSeq * seq, gint i, gsize N)
{
  GuppiStyle *sty;
  gint j;

  for (j = 0; j < N; ++j) {
    sty = guppi_seq_style_get (GUPPI_SEQ_STYLE (seq), i + j);
    if (sty != NULL)
      gtk_signal_disconnect_by_func (GTK_OBJECT (sty), guppi_data_touch, seq);
  }

  if (GUPPI_SEQ_CLASS (parent_class)->changed_delete)
    GUPPI_SEQ_CLASS (parent_class)->changed_delete (seq, i, N);
}

static void
guppi_seq_style_class_init (GuppiSeqObjectClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiDataClass *data_class = GUPPI_DATA_CLASS (klass);
  GuppiSeqClass *seq_class = GUPPI_SEQ_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_SEQ);

  seq_class->changed_delete = changed_delete;

  data_class->type_name = _("GuppiStyle Sequence");
  data_class->type_name_for_impl_lookup = "GuppiSeqObject";

  object_class->get_arg = guppi_seq_style_get_arg;
  object_class->set_arg = guppi_seq_style_set_arg;
  object_class->finalize = guppi_seq_style_finalize;
}

static void
guppi_seq_style_init (GuppiSeqObject * obj)
{

}

GtkType guppi_seq_style_get_type (void)
{
  static GtkType guppi_seq_style_type = 0;
  if (!guppi_seq_style_type) {
    static const GtkTypeInfo guppi_seq_style_info = {
      "GuppiSeqStyle",
      sizeof (GuppiSeqStyle),
      sizeof (GuppiSeqStyleClass),
      (GtkClassInitFunc) guppi_seq_style_class_init,
      (GtkObjectInitFunc) guppi_seq_style_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_seq_style_type = gtk_type_unique (GUPPI_TYPE_SEQ,
					    &guppi_seq_style_info);
  }
  return guppi_seq_style_type;
}

GuppiData *
guppi_seq_style_new (void)
{
  return guppi_data_newv (GUPPI_TYPE_SEQ_STYLE, NULL, 0, NULL);
}

/****************************************************************************/
typedef struct _GuppiDataOp_Style GuppiDataOp_Style;
struct _GuppiDataOp_Style {
  GuppiDataOp op;
  gint i;
  gsize N;
  GuppiStyle *style;
};

static void
op_set (GuppiData * d, GuppiDataOp * in_op)
{
  GuppiDataOp_Style *op = (GuppiDataOp_Style *) in_op;

  GuppiSeqObjectImpl *impl;
  GuppiSeqObjectImplClass *impl_class;
  GuppiStyle *old;

  impl = GUPPI_SEQ_OBJECT_IMPL (guppi_data_impl (d));
  impl_class = GUPPI_SEQ_OBJECT_IMPL_CLASS (GTK_OBJECT (impl)->klass);

  old = guppi_seq_style_get (GUPPI_SEQ_STYLE (d), op->i);

  g_assert (impl_class->set);
  impl_class->set (impl, op->i, GTK_OBJECT (op->style));

  if (old)
    gtk_signal_disconnect_by_func (GTK_OBJECT (old),
				   GTK_SIGNAL_FUNC (guppi_data_touch), d);

  if (op->style)
    gtk_signal_connect_object (GTK_OBJECT (op->style),
			       "changed",
			       GTK_SIGNAL_FUNC (guppi_data_touch),
			       GTK_OBJECT (d));

  guppi_unref (old);
  guppi_ref (op->style);
}

static void
op_insert (GuppiData * d, GuppiDataOp * in_op)
{
  GuppiDataOp_Style *op = (GuppiDataOp_Style *) in_op;

  GuppiSeqObjectImpl *impl;
  GuppiSeqObjectImplClass *impl_class;

  impl = GUPPI_SEQ_OBJECT_IMPL (guppi_data_impl (d));
  impl_class = GUPPI_SEQ_OBJECT_IMPL_CLASS (GTK_OBJECT (impl)->klass);

  g_assert (impl_class->insert);
  impl_class->insert (impl, op->i, op->style ? GTK_OBJECT (op->style) : NULL);

  if (op->style) {
    guppi_ref (op->style);
    gtk_signal_connect_object (GTK_OBJECT (op->style),
			       "changed",
			       GTK_SIGNAL_FUNC (guppi_data_touch),
			       GTK_OBJECT (d));
  }
}

/*****************************************************************************/

GuppiStyle *
guppi_seq_style_get (const GuppiSeqStyle * seq, gint i)
{
  const GuppiSeqObjectImpl *impl;
  GuppiSeqObjectImplClass *impl_class;

  g_return_val_if_fail (seq != NULL, NULL);
  g_return_val_if_fail (GUPPI_IS_SEQ_STYLE (seq), NULL);
  g_return_val_if_fail (guppi_seq_in_bounds (GUPPI_SEQ (seq), i), NULL);

  impl = GUPPI_SEQ_OBJECT_IMPL (guppi_data_impl (GUPPI_DATA (seq)));
  impl_class = GUPPI_SEQ_OBJECT_IMPL_CLASS (GTK_OBJECT (impl)->klass);

  g_assert (impl_class->get);
  return GUPPI_STYLE0 (impl_class->get (impl, i));
}

void
guppi_seq_style_set (GuppiSeqStyle * seq, gint i, GuppiStyle * sty)
{
  GuppiDataOp_Style op;

  g_return_if_fail (seq != NULL && GUPPI_IS_SEQ_STYLE (seq));
  g_return_if_fail (guppi_data_can_change (GUPPI_DATA (seq)));
  g_return_if_fail (guppi_seq_in_bounds (GUPPI_SEQ (seq), i));
  g_return_if_fail (sty == NULL || GUPPI_IS_STYLE (sty));

  if (guppi_seq_style_get (seq, i) != sty) {
    op.op.op = op_set;
    op.i = i;
    op.style = sty;
    guppi_seq_changed_set (GUPPI_SEQ (seq), i, i, (GuppiDataOp *) & op);
  }
}

void
guppi_seq_style_prepend (GuppiSeqStyle * seq, GuppiStyle * sty)
{
  gint first;

  g_return_if_fail (seq != NULL);
  g_return_if_fail (GUPPI_IS_SEQ_STYLE (seq));
  g_return_if_fail (guppi_data_can_change (GUPPI_DATA (seq)));
  g_return_if_fail (sty == NULL || GUPPI_IS_STYLE (sty));

  first = guppi_seq_min_index (GUPPI_SEQ (seq));
  guppi_seq_style_insert (seq, first, sty);
}

void
guppi_seq_style_append (GuppiSeqStyle * seq, GuppiStyle * sty)
{
  gint last;

  g_return_if_fail (seq != NULL);
  g_return_if_fail (GUPPI_IS_SEQ_STYLE (seq));
  g_return_if_fail (guppi_data_can_change (GUPPI_DATA (seq)));
  g_return_if_fail (sty == NULL || GUPPI_IS_STYLE (sty));

  last = guppi_seq_max_index (GUPPI_SEQ (seq));
  guppi_seq_style_insert (seq, last + 1, sty);
}

void
guppi_seq_style_insert (GuppiSeqStyle * seq, gint i, GuppiStyle * sty)
{
  GuppiDataOp_Style op;

  g_return_if_fail (seq != NULL && GUPPI_IS_SEQ_STYLE (seq));
  g_return_if_fail (guppi_data_can_change (GUPPI_DATA (seq)));
  g_return_if_fail (sty == NULL || GUPPI_IS_STYLE (sty));

  op.op.op = op_insert;
  op.i = i;
  op.style = sty;

  guppi_seq_changed_insert (GUPPI_SEQ (seq), i, 1, (GuppiDataOp *) & op);
}

/* $Id: guppi-seq-style.c,v 1.5 2000/10/20 01:21:48 trow Exp $ */
