/* $Id: demo-silly.c,v 1.1 2000/12/01 22:44:01 trow Exp $ */

/*
 * demo-silly.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <gnome.h>

int
main (gint argc, gchar * argv[])
{
  GtkWidget *win;
  GtkWidget *canv;

  gnome_init ("silly_demo", "0.0", argc, argv);

  gtk_widget_push_visual(gdk_rgb_get_visual());
  gtk_widget_push_colormap(gdk_rgb_get_cmap());
  canv = gnome_canvas_new_aa();
  gtk_widget_pop_colormap();
  gtk_widget_pop_visual();

  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (win, 400, 300);

  gnome_canvas_item_new (gnome_canvas_root (GNOME_CANVAS (canv)),
			 gnome_canvas_ellipse_get_type(),
			 "x1", 0.0,
			 "y1", 0.0,
			 "x2", 200.0,
			 "y2", 100.0,
			 "fill_color_rgba", 0x5f9ea080,
			 "outline_color", "black",
			 "width_pixels", 0,
			 NULL);



  gtk_container_add (GTK_CONTAINER (win), canv);
  gtk_widget_show_all (win);

  

  gtk_signal_connect (GTK_OBJECT (win),
		      "delete_event",
		      GTK_SIGNAL_FUNC (exit), NULL);

  gtk_main ();

  return 0;
}



/* $Id: demo-silly.c,v 1.1 2000/12/01 22:44:01 trow Exp $ */
