/* This is -*- C -*- */
/* $Id: ggraph.h,v 1.5 2000/12/16 03:42:50 trow Exp $ */

/*
 * ggraph.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GGRAPH_H
#define _INC_GGRAPH_H

#include <glib.h>

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

typedef struct _GGraph GGraph;
typedef struct _GVertex GVertex;

struct _GVertex {
  GList *edges;
  gpointer data;
};

struct _GGraph {
  GList *vertices;
};

GGraph *g_graph_new (void);
void g_graph_free (GGraph *);

GVertex *g_graph_add_vertex (GGraph *, gpointer data);
void g_graph_add_edge (GGraph *, GVertex *, GVertex *);

GVertex *g_graph_find_vertex_by_data (GGraph *, gpointer data);

void g_graph_remove_vertex (GGraph *, GVertex *);
void g_graph_remove_vertex_and_relink (GGraph *, GVertex *);

void g_graph_foreach (GGraph *, GFunc, gpointer user_data);
void g_vertex_traverse_neighbors (GVertex *, GFunc, gpointer user_data);
void g_vertex_traverse_connected_component (GVertex *, GFunc,
					    gpointer user_data);



END_GUPPI_DECLS

#endif /* _INC_GGRAPH_H */

/* $Id: ggraph.h,v 1.5 2000/12/16 03:42:50 trow Exp $ */
