/* This is -*- C -*- */
/* $Id: guppi-seq-object-core-impl.c,v 1.6 2001/01/16 23:35:52 trow Exp $ */

/*
 * guppi-seq-object-core-impl.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
/* #include <gnome.h> */

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>
#include <libgnome/gnome-i18n.h>

#include <guppi-convenient.h>
#include <guppi-data-impl-plug-in.h>
#include "guppi-seq-object-core-impl.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_seq_object_core_impl_get_arg (GtkObject * obj, GtkArg * arg,
				    guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_object_core_impl_set_arg (GtkObject * obj, GtkArg * arg,
				    guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_object_core_impl_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_seq_object_core_impl_finalize (GtkObject * obj)
{
  GuppiSeqObjectCoreImpl *impl = GUPPI_SEQ_OBJECT_CORE_IMPL (obj);
  GtkObject **data;
  gint i;

  if (impl->garray) {

    data = (GtkObject **) guppi_garray_data (impl->garray);

    for (i = 0; i < impl->size; ++i)
      if (data[i])
	guppi_unref (data[i]);

    guppi_unref (impl->garray);

    impl->garray = NULL;
  }

  if (parent_class->finalize)
    parent_class->finalize (obj);

}

static GtkObject *
v_seq_object_get (const GuppiSeqObjectImpl * impl, gint i)
{
  GuppiSeqObjectCoreImpl *core = GUPPI_SEQ_OBJECT_CORE_IMPL (impl);
  GtkObject **data;

  data = (GtkObject **) guppi_garray_data (core->garray);
  i -= core->index_basis;
  return data[i];
}

static void
v_seq_object_set (GuppiSeqObjectImpl * impl, gint i, GtkObject * obj)
{
  GuppiSeqObjectCoreImpl *core = GUPPI_SEQ_OBJECT_CORE_IMPL (impl);
  GtkObject **data;

  data = (GtkObject **) guppi_garray_data (core->garray);
  i -= core->index_basis;
  data[i] = obj;
}

static void
v_seq_object_insert (GuppiSeqObjectImpl * impl, gint i, GtkObject * obj)
{
  GuppiSeqObjectCoreImpl *core = GUPPI_SEQ_OBJECT_CORE_IMPL (impl);
  GtkObject **data;
  gint j;

  i -= core->index_basis;

  if (guppi_garray_size (core->garray) <= core->size)
    guppi_garray_set_size (core->garray, MAX (20, 2 * core->size));

  data = (GtkObject **) guppi_garray_data (core->garray);
  for (j = core->size - 1; i <= j; --j)
    data[j + 1] = data[j];
  data[i] = obj;
  ++core->size;
}

static void
v_seq_object_insert_NULL (GuppiSeqObjectImpl * impl, gint i, gsize N)
{
  GuppiSeqObjectCoreImpl *core = GUPPI_SEQ_OBJECT_CORE_IMPL (impl);
  GtkObject **data;
  gint j;

  i -= core->index_basis;

  if (guppi_garray_size (core->garray) < core->size + N)
    guppi_garray_set_size (core->garray,
			   MAX (MAX (20, 2 * core->size),
				core->size + 2 * N));

  data = (GtkObject **) guppi_garray_data (core->garray);

  for (j = core->size - 1; i <= j; --j)
    data[j + N] = data[j];

  for (j = 0; j < N; ++j)
    data[i + j] = NULL;

  core->size += N;
}

static void
v_seq_size_hint (GuppiSeqImpl * impl, gsize n)
{
  GuppiSeqObjectCoreImpl *core = GUPPI_SEQ_OBJECT_CORE_IMPL (impl);

  if (guppi_garray_size (core->garray) < n)
    guppi_garray_set_size (core->garray, n);
}

static void
v_seq_get_bounds (const GuppiSeqImpl * impl, gint * min, gint * max)
{
  const GuppiSeqObjectCoreImpl *core = GUPPI_SEQ_OBJECT_CORE_IMPL (impl);

  if (min)
    *min = core->index_basis;

  if (max)
    *max = core->index_basis - 1 + core->size;

}

static void
v_seq_shift_indices (GuppiSeqImpl * impl, gint delta)
{
  GuppiSeqObjectCoreImpl *core = GUPPI_SEQ_OBJECT_CORE_IMPL (impl);
  core->index_basis += delta;
}

static gboolean
v_seq_validate (const GuppiSeqImpl * impl, const gchar * str,
		gchar * error_msg, gsize errlen)
{
  g_snprintf (error_msg, errlen, "Illegal String->Object Conversion Attempt");
  return FALSE;
}

static void
v_seq_get (const GuppiSeqImpl * impl, gint i, gchar * buf, gsize len)
{
  GtkObject *obj;
  obj = v_seq_object_get (GUPPI_SEQ_OBJECT_IMPL (impl), i);
  if (obj == NULL)
    g_snprintf (buf, len, "<GtkObject: NULL>");
  else
    g_snprintf (buf, len, "<%s: %p>",
		gtk_type_name (GTK_OBJECT_TYPE (obj)), (gpointer) obj);
}

static void
v_seq_set (GuppiSeqImpl * impl, gint i, const gchar * buf)
{
  g_assert_not_reached ();
}

static void
v_seq_insert (GuppiSeqImpl * impl, gint i, const gchar * buf)
{
  g_assert_not_reached ();
}

static void
v_seq_delete_many (GuppiSeqImpl * impl, gint i, gsize N)
{
  GuppiSeqObjectCoreImpl *core = GUPPI_SEQ_OBJECT_CORE_IMPL (impl);
  GtkObject **data;
  gint j;

  data = (GtkObject **) guppi_garray_data (core->garray);
  i -= core->index_basis;

  for (j = i; j + N < core->size; ++j) {
    if (data[j] != NULL)
      guppi_unref (data[j]);
    data[j] = data[j + N];
  }

  core->size -= N;
}

static void
v_seq_grow_to_include (GuppiSeqImpl * impl, gint j0, gint j1)
{
  GuppiSeqObjectCoreImpl *core = GUPPI_SEQ_OBJECT_CORE_IMPL (impl);

  if (core->size == 0) {
    v_seq_object_insert_NULL (GUPPI_SEQ_OBJECT_IMPL (impl), 0, j1 - j0 + 1);
    core->index_basis = j0;
    return;
  }

  /* Grow to the front */
  if (j0 < core->index_basis) {
    v_seq_object_insert_NULL (GUPPI_SEQ_OBJECT_IMPL (impl), core->index_basis,
			      core->index_basis - j0);
    core->index_basis = j0;
  }

  /* Grow the back */
  if (j1 >= core->index_basis + core->size) {
    v_seq_object_insert_NULL (GUPPI_SEQ_OBJECT_IMPL (impl),
			      core->index_basis + core->size,
			      core->size + core->index_basis - j1);
  }

}


static void
guppi_seq_object_core_impl_class_init (GuppiSeqObjectCoreImplClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiDataImplClass *data_class = GUPPI_DATA_IMPL_CLASS (klass);
  GuppiSeqImplClass *seq_class = GUPPI_SEQ_IMPL_CLASS (klass);
  GuppiSeqObjectImplClass *seq_obj_class =
    GUPPI_SEQ_OBJECT_IMPL_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_SEQ_OBJECT_IMPL);

  object_class->get_arg = guppi_seq_object_core_impl_get_arg;
  object_class->set_arg = guppi_seq_object_core_impl_set_arg;
  object_class->destroy = guppi_seq_object_core_impl_destroy;
  object_class->finalize = guppi_seq_object_core_impl_finalize;

  data_class->impl_name = _("Core GtkObject Sequence");

  seq_obj_class->get = v_seq_object_get;
  seq_obj_class->set = v_seq_object_set;
  seq_obj_class->insert = v_seq_object_insert;
  seq_obj_class->insert_NULL = v_seq_object_insert_NULL;

  seq_class->size_hint = v_seq_size_hint;
  seq_class->get_bounds = v_seq_get_bounds;
  seq_class->shift_indices = v_seq_shift_indices;

  seq_class->validate = v_seq_validate;
  seq_class->get = v_seq_get;
  seq_class->set = v_seq_set;
  seq_class->insert = v_seq_insert;
  seq_class->delete_many = v_seq_delete_many;
  seq_class->grow_to_include = v_seq_grow_to_include;


}

static void
guppi_seq_object_core_impl_init (GuppiSeqObjectCoreImpl * obj)
{
  obj->index_basis = 0;
  obj->size = 0;
  obj->garray = guppi_garray_new (sizeof (GtkObject *));
}

GtkType guppi_seq_object_core_impl_get_type (void)
{
  static GtkType guppi_seq_object_core_impl_type = 0;
  if (!guppi_seq_object_core_impl_type) {
    static const GtkTypeInfo guppi_seq_object_core_impl_info = {
      "GuppiSeqObjectCoreImpl",
      sizeof (GuppiSeqObjectCoreImpl),
      sizeof (GuppiSeqObjectCoreImplClass),
      (GtkClassInitFunc) guppi_seq_object_core_impl_class_init,
      (GtkObjectInitFunc) guppi_seq_object_core_impl_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_seq_object_core_impl_type =
      gtk_type_unique (GUPPI_TYPE_SEQ_OBJECT_IMPL,
		       &guppi_seq_object_core_impl_info);
  }
  return guppi_seq_object_core_impl_type;
}

/****************************************************************************/

static GuppiDataImpl *
make_impl (void)
{
  return
    GUPPI_DATA_IMPL (guppi_type_new (guppi_seq_object_core_impl_get_type ()));
}

GuppiPlugIn *guppi_plug_in (void);

GuppiPlugIn *
guppi_plug_in (void)
{
  GuppiPlugIn *pi;
  GuppiDataImplPlugIn *dimpi;

  pi = guppi_data_impl_plug_in_new ();
  dimpi = GUPPI_DATA_IMPL_PLUG_IN (pi);

  pi->magic_number = GUPPI_PLUG_IN_MAGIC_NUMBER;
  dimpi->impl_constructor = make_impl;

  return pi;
}


/* $Id: guppi-seq-object-core-impl.c,v 1.6 2001/01/16 23:35:52 trow Exp $ */
