/* This is -*- C -*- */
/* $Id: guppi-frame-state.c,v 1.8 2001/01/16 23:36:01 trow Exp $ */

/*
 * guppi-frame-state.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>
#include <libgnome/gnome-i18n.h>

#include <guppi-useful.h>
#include <guppi-rgb.h>
#include "guppi-frame-state.h"
#include "guppi-frame-view.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_SHOW_MAJOR_TICKS,
  ARG_MAJOR_TICK_COLOR,
  ARG_MAJOR_TICK_THICKNESS,
  ARG_MAJOR_TICK_LENGTH,
  ARG_SHOW_MINOR_TICKS,
  ARG_MINOR_TICK_COLOR,
  ARG_MINOR_TICK_THICKNESS,
  ARG_MINOR_TICK_LENGTH,
  ARG_SHOW_MICRO_TICKS,
  ARG_MICRO_TICK_COLOR,
  ARG_MICRO_TICK_THICKNESS,
  ARG_MICRO_TICK_LENGTH,
  ARG_SHOW_MAJOR_RULES,
  ARG_MAJOR_RULE_COLOR,
  ARG_MAJOR_RULE_THICKNESS,
  ARG_SHOW_MINOR_RULES,
  ARG_MINOR_RULE_COLOR,
  ARG_MINOR_RULE_THICKNESS,
  ARG_SHOW_MICRO_RULES,
  ARG_MICRO_RULE_COLOR,
  ARG_MICRO_RULE_THICKNESS,
  ARG_FRAME_NORTH,
  ARG_FRAME_SOUTH,
  ARG_FRAME_EAST,
  ARG_FRAME_WEST,
  ARG_FRAME_COLOR,
  ARG_FRAME_THICKNESS
};

static void
guppi_frame_state_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  GuppiFrameState *state = GUPPI_FRAME_STATE (obj);

  switch (arg_id) {

  case ARG_SHOW_MAJOR_TICKS:
    GTK_VALUE_BOOL (*arg) = guppi_frame_state_show_major_ticks (state);
    break;

  case ARG_MAJOR_TICK_COLOR:
    GTK_VALUE_UINT (*arg) = guppi_frame_state_major_tick_color (state);
    break;

  case ARG_MAJOR_TICK_THICKNESS:
    GTK_VALUE_DOUBLE (*arg) = guppi_frame_state_major_tick_thickness (state);
    break;

  case ARG_MAJOR_TICK_LENGTH:
    GTK_VALUE_DOUBLE (*arg) = guppi_frame_state_major_tick_length (state);
    break;

  case ARG_SHOW_MINOR_TICKS:
    GTK_VALUE_BOOL (*arg) = guppi_frame_state_show_minor_ticks (state);
    break;

  case ARG_MINOR_TICK_COLOR:
    GTK_VALUE_UINT (*arg) = guppi_frame_state_minor_tick_color (state);
    break;

  case ARG_MINOR_TICK_THICKNESS:
    GTK_VALUE_DOUBLE (*arg) = guppi_frame_state_minor_tick_thickness (state);
    break;

  case ARG_MINOR_TICK_LENGTH:
    GTK_VALUE_DOUBLE (*arg) = guppi_frame_state_minor_tick_length (state);
    break;

  case ARG_SHOW_MICRO_TICKS:
    GTK_VALUE_BOOL (*arg) = guppi_frame_state_show_micro_ticks (state);
    break;

  case ARG_MICRO_TICK_COLOR:
    GTK_VALUE_UINT (*arg) = guppi_frame_state_micro_tick_color (state);
    break;

  case ARG_MICRO_TICK_THICKNESS:
    GTK_VALUE_DOUBLE (*arg) = guppi_frame_state_micro_tick_thickness (state);
    break;

  case ARG_MICRO_TICK_LENGTH:
    GTK_VALUE_DOUBLE (*arg) = guppi_frame_state_micro_tick_length (state);
    break;

  case ARG_SHOW_MAJOR_RULES:
    GTK_VALUE_BOOL (*arg) = guppi_frame_state_show_major_rules (state);
    break;

  case ARG_MAJOR_RULE_COLOR:
    GTK_VALUE_UINT (*arg) = guppi_frame_state_major_rule_color (state);
    break;

  case ARG_MAJOR_RULE_THICKNESS:
    GTK_VALUE_DOUBLE (*arg) = guppi_frame_state_major_rule_thickness (state);
    break;

  case ARG_SHOW_MINOR_RULES:
    GTK_VALUE_BOOL (*arg) = guppi_frame_state_show_minor_rules (state);
    break;

  case ARG_MINOR_RULE_COLOR:
    GTK_VALUE_UINT (*arg) = guppi_frame_state_minor_rule_color (state);
    break;

  case ARG_MINOR_RULE_THICKNESS:
    GTK_VALUE_DOUBLE (*arg) = guppi_frame_state_minor_rule_thickness (state);
    break;

  case ARG_SHOW_MICRO_RULES:
    GTK_VALUE_BOOL (*arg) = guppi_frame_state_show_micro_rules (state);
    break;

  case ARG_MICRO_RULE_COLOR:
    GTK_VALUE_UINT (*arg) = guppi_frame_state_micro_rule_color (state);
    break;

  case ARG_MICRO_RULE_THICKNESS:
    GTK_VALUE_DOUBLE (*arg) = guppi_frame_state_micro_rule_thickness (state);
    break;

  case ARG_FRAME_NORTH:
    GTK_VALUE_BOOL (*arg) = guppi_frame_state_frame_north (state);
    break;

  case ARG_FRAME_SOUTH:
    GTK_VALUE_BOOL (*arg) = guppi_frame_state_frame_south (state);
    break;

  case ARG_FRAME_EAST:
    GTK_VALUE_BOOL (*arg) = guppi_frame_state_frame_east (state);
    break;

  case ARG_FRAME_WEST:
    GTK_VALUE_BOOL (*arg) = guppi_frame_state_frame_west (state);
    break;

  case ARG_FRAME_COLOR:
    GTK_VALUE_UINT (*arg) = guppi_frame_state_frame_color (state);
    break;

  case ARG_FRAME_THICKNESS:
    GTK_VALUE_DOUBLE (*arg) = guppi_frame_state_frame_thickness (state);
    break;

  default:
    break;
  };
}

static void
guppi_frame_state_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  GuppiFrameState *state = GUPPI_FRAME_STATE (obj);

  switch (arg_id) {

  case ARG_SHOW_MAJOR_TICKS:
    guppi_frame_state_set_show_major_ticks (state, GTK_VALUE_BOOL (*arg));
    break;

  case ARG_MAJOR_TICK_COLOR:
    guppi_frame_state_set_major_tick_color (state, GTK_VALUE_UINT (*arg));
    break;

  case ARG_MAJOR_TICK_THICKNESS:
    guppi_frame_state_set_major_tick_thickness (state,
						GTK_VALUE_DOUBLE (*arg));
    break;

  case ARG_MAJOR_TICK_LENGTH:
    guppi_frame_state_set_major_tick_length (state, GTK_VALUE_DOUBLE (*arg));
    break;

  case ARG_SHOW_MINOR_TICKS:
    guppi_frame_state_set_show_minor_ticks (state, GTK_VALUE_BOOL (*arg));
    break;

  case ARG_MINOR_TICK_COLOR:
    guppi_frame_state_set_minor_tick_color (state, GTK_VALUE_UINT (*arg));
    break;

  case ARG_MINOR_TICK_THICKNESS:
    guppi_frame_state_set_minor_tick_thickness (state,
						GTK_VALUE_DOUBLE (*arg));
    break;

  case ARG_MINOR_TICK_LENGTH:
    guppi_frame_state_set_minor_tick_length (state, GTK_VALUE_DOUBLE (*arg));
    break;

  case ARG_SHOW_MICRO_TICKS:
    guppi_frame_state_set_show_micro_ticks (state, GTK_VALUE_BOOL (*arg));
    break;

  case ARG_MICRO_TICK_COLOR:
    guppi_frame_state_set_micro_tick_color (state, GTK_VALUE_UINT (*arg));
    break;

  case ARG_MICRO_TICK_THICKNESS:
    guppi_frame_state_set_micro_tick_thickness (state,
						GTK_VALUE_DOUBLE (*arg));
    break;

  case ARG_MICRO_TICK_LENGTH:
    guppi_frame_state_set_micro_tick_length (state, GTK_VALUE_DOUBLE (*arg));
    break;

  case ARG_SHOW_MAJOR_RULES:
    guppi_frame_state_set_show_major_rules (state, GTK_VALUE_BOOL (*arg));
    break;

  case ARG_MAJOR_RULE_COLOR:
    guppi_frame_state_set_major_rule_color (state, GTK_VALUE_UINT (*arg));
    break;

  case ARG_MAJOR_RULE_THICKNESS:
    guppi_frame_state_set_major_rule_thickness (state,
						GTK_VALUE_DOUBLE (*arg));
    break;

  case ARG_SHOW_MINOR_RULES:
    guppi_frame_state_set_show_minor_rules (state, GTK_VALUE_BOOL (*arg));
    break;

  case ARG_MINOR_RULE_COLOR:
    guppi_frame_state_set_minor_rule_color (state, GTK_VALUE_UINT (*arg));
    break;

  case ARG_MINOR_RULE_THICKNESS:
    guppi_frame_state_set_minor_rule_thickness (state,
						GTK_VALUE_DOUBLE (*arg));
    break;

  case ARG_SHOW_MICRO_RULES:
    guppi_frame_state_set_show_micro_rules (state, GTK_VALUE_BOOL (*arg));
    break;

  case ARG_MICRO_RULE_COLOR:
    guppi_frame_state_set_micro_rule_color (state, GTK_VALUE_UINT (*arg));
    break;

  case ARG_MICRO_RULE_THICKNESS:
    guppi_frame_state_set_micro_rule_thickness (state,
						GTK_VALUE_DOUBLE (*arg));
    break;

  case ARG_FRAME_NORTH:
    guppi_frame_state_set_frame_north (state, GTK_VALUE_DOUBLE (*arg));

  case ARG_FRAME_SOUTH:
    guppi_frame_state_set_frame_south (state, GTK_VALUE_DOUBLE (*arg));

  case ARG_FRAME_EAST:
    guppi_frame_state_set_frame_east (state, GTK_VALUE_DOUBLE (*arg));

  case ARG_FRAME_WEST:
    guppi_frame_state_set_frame_west (state, GTK_VALUE_DOUBLE (*arg));
    break;

  case ARG_FRAME_COLOR:
    guppi_frame_state_set_frame_color (state, GTK_VALUE_UINT (*arg));
    break;

  case ARG_FRAME_THICKNESS:
    guppi_frame_state_set_frame_thickness (state, GTK_VALUE_DOUBLE (*arg));
    break;

  default:
    break;
  };
}

static void
guppi_frame_state_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_frame_state_finalize (GtkObject * obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/****************************************************************************/

static GuppiElementView *
make_view (GuppiElementState * state)
{
  return GUPPI_ELEMENT_VIEW (guppi_type_new (GUPPI_TYPE_FRAME_VIEW));
}

/****************************************************************************/

static GtkWidget *
config_cb (gpointer user_data)
{
  return gtk_label_new ("Frame State");
}

static GuppiConfigItem *
config_tree (GuppiElementState * state)
{
  GuppiConfigItem *node;

  node = guppi_config_item_new (_("Frame: Configure"),
				_("Configure"), config_cb, state);

  return node;
}

/****************************************************************************/

#define add_arg(str, t, symb) \
gtk_object_add_arg_type("GuppiFrameState::" str, t, GTK_ARG_READWRITE, symb)

static void
guppi_frame_state_class_init (GuppiFrameStateClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiElementStateClass *state_class = GUPPI_ELEMENT_STATE_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_ELEMENT_STATE);

  object_class->get_arg = guppi_frame_state_get_arg;
  object_class->set_arg = guppi_frame_state_set_arg;
  object_class->destroy = guppi_frame_state_destroy;
  object_class->finalize = guppi_frame_state_finalize;

  state_class->name = _("Frame");

  state_class->make_view = make_view;
  state_class->config_tree = config_tree;

  add_arg ("show_major_ticks", GTK_TYPE_BOOL, ARG_SHOW_MAJOR_TICKS);
  add_arg ("major_tick_color", GTK_TYPE_UINT, ARG_MAJOR_TICK_COLOR);
  add_arg ("major_tick_thickness", GTK_TYPE_DOUBLE, ARG_MAJOR_TICK_THICKNESS);
  add_arg ("major_tick_length", GTK_TYPE_DOUBLE, ARG_MAJOR_TICK_LENGTH);

  add_arg ("show_minor_ticks", GTK_TYPE_BOOL, ARG_SHOW_MINOR_TICKS);
  add_arg ("minor_tick_color", GTK_TYPE_UINT, ARG_MINOR_TICK_COLOR);
  add_arg ("minor_tick_thickness", GTK_TYPE_DOUBLE, ARG_MINOR_TICK_THICKNESS);
  add_arg ("minor_tick_length", GTK_TYPE_DOUBLE, ARG_MINOR_TICK_LENGTH);

  add_arg ("show_micro_ticks", GTK_TYPE_BOOL, ARG_SHOW_MICRO_TICKS);
  add_arg ("micro_tick_color", GTK_TYPE_UINT, ARG_MICRO_TICK_COLOR);
  add_arg ("micro_tick_thickness", GTK_TYPE_DOUBLE, ARG_MICRO_TICK_THICKNESS);
  add_arg ("micro_tick_length", GTK_TYPE_DOUBLE, ARG_MICRO_TICK_LENGTH);

  add_arg ("show_major_rules", GTK_TYPE_BOOL, ARG_SHOW_MAJOR_RULES);
  add_arg ("major_rule_color", GTK_TYPE_UINT, ARG_MAJOR_RULE_COLOR);
  add_arg ("major_rule_thickness", GTK_TYPE_DOUBLE, ARG_MAJOR_RULE_THICKNESS);

  add_arg ("show_minor_rules", GTK_TYPE_BOOL, ARG_SHOW_MINOR_RULES);
  add_arg ("minor_rule_color", GTK_TYPE_UINT, ARG_MINOR_RULE_COLOR);
  add_arg ("minor_rule_thickness", GTK_TYPE_DOUBLE, ARG_MINOR_RULE_THICKNESS);

  add_arg ("show_micro_rules", GTK_TYPE_BOOL, ARG_SHOW_MICRO_RULES);
  add_arg ("micro_rule_color", GTK_TYPE_UINT, ARG_MICRO_RULE_COLOR);
  add_arg ("micro_rule_thickness", GTK_TYPE_DOUBLE, ARG_MICRO_RULE_THICKNESS);
}

static void
guppi_frame_state_init (GuppiFrameState * obj)
{
  /* A set of (hopefully) reasonable defaults */

  obj->show_major_ticks = FALSE;
  obj->major_tick_color = RGBA_BLACK;
  obj->major_tick_thickness = guppi_in2pt (1.0 / 64);
  obj->major_tick_length = guppi_in2pt (1.0 / 12);

  obj->show_minor_ticks = FALSE;
  obj->minor_tick_color = RGBA_BLACK;
  obj->minor_tick_thickness = guppi_in2pt (1.0 / 96);
  obj->minor_tick_length = guppi_in2pt (1.0 / 16);

  obj->show_micro_ticks = FALSE;
  obj->minor_tick_color = RGBA_BLACK;
  obj->minor_tick_thickness = guppi_in2pt (1.0 / 96);
  obj->minor_tick_length = guppi_in2pt (1.0 / 20);

  obj->show_major_rules = TRUE;
  obj->major_rule_color = RGBA_GREY (0xff / 2);
  obj->major_rule_thickness = guppi_in2pt (1.0 / 64);

  obj->show_minor_rules = TRUE;
  obj->minor_rule_color = RGBA_GREY (3 * 0xff / 4);
  obj->minor_rule_thickness = guppi_in2pt (1.0 / 96);

  obj->show_micro_rules = TRUE;
  obj->micro_rule_color = RGBA_GREY (7 * 0xff / 8);
  obj->micro_rule_thickness = guppi_in2pt (1.0 / 128);

  obj->frame_flags = 0;
  obj->frame_color = RGBA_BLACK;
  obj->frame_thickness = guppi_in2pt (1.0 / 48);
}

GtkType guppi_frame_state_get_type (void)
{
  static GtkType guppi_frame_state_type = 0;
  if (!guppi_frame_state_type) {
    static const GtkTypeInfo guppi_frame_state_info = {
      "GuppiFrameState",
      sizeof (GuppiFrameState),
      sizeof (GuppiFrameStateClass),
      (GtkClassInitFunc) guppi_frame_state_class_init,
      (GtkObjectInitFunc) guppi_frame_state_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_frame_state_type =
      gtk_type_unique (GUPPI_TYPE_ELEMENT_STATE, &guppi_frame_state_info);
  }
  return guppi_frame_state_type;
}

GuppiElementState *
guppi_frame_state_new (void)
{
  return GUPPI_ELEMENT_STATE (guppi_type_new (guppi_frame_state_get_type ()));
}

void
guppi_frame_state_set_show_major_ticks (GuppiFrameState * state, gboolean x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->show_major_ticks != x) {
    state->show_major_ticks = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_major_tick_color (GuppiFrameState * state,
					guint32 color)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->major_tick_color != color) {
    state->major_tick_color = color;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_major_tick_thickness (GuppiFrameState * state, double x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));
  g_return_if_fail (x >= 0);

  if (state->major_tick_thickness != x) {
    state->major_tick_thickness = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_major_tick_length (GuppiFrameState * state, double x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));
  g_return_if_fail (x >= 0);

  if (state->major_tick_length != x) {
    state->major_tick_length = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_show_minor_ticks (GuppiFrameState * state, gboolean x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->show_minor_ticks != x) {
    state->show_minor_ticks = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_minor_tick_color (GuppiFrameState * state,
					guint32 color)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->minor_tick_color != color) {
    state->minor_tick_color = color;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_minor_tick_thickness (GuppiFrameState * state, double x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));
  g_return_if_fail (x >= 0);

  if (state->minor_tick_thickness != x) {
    state->minor_tick_thickness = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_minor_tick_length (GuppiFrameState * state, double x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));
  g_return_if_fail (x >= 0);

  if (state->minor_tick_length != x) {
    state->minor_tick_length = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_show_micro_ticks (GuppiFrameState * state, gboolean x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->show_micro_ticks != x) {
    state->show_micro_ticks = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_micro_tick_color (GuppiFrameState * state,
					guint32 color)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->micro_tick_color != color) {
    state->micro_tick_color = color;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_micro_tick_thickness (GuppiFrameState * state, double x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));
  g_return_if_fail (x >= 0);

  if (state->micro_tick_thickness != x) {
    state->micro_tick_thickness = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_micro_tick_length (GuppiFrameState * state, double x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));
  g_return_if_fail (x >= 0);

  if (state->micro_tick_length != x) {
    state->micro_tick_length = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_show_major_rules (GuppiFrameState * state, gboolean x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->show_major_rules != x) {
    state->show_major_rules = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_major_rule_color (GuppiFrameState * state,
					guint32 color)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->major_rule_color != color) {
    state->major_rule_color = color;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_major_rule_thickness (GuppiFrameState * state, double x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));
  g_return_if_fail (x >= 0);

  if (state->major_rule_thickness != x) {
    state->major_rule_thickness = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_show_minor_rules (GuppiFrameState * state, gboolean x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->show_minor_rules != x) {
    state->show_minor_rules = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_minor_rule_color (GuppiFrameState * state,
					guint32 color)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->minor_rule_color != color) {
    state->minor_rule_color = color;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_minor_rule_thickness (GuppiFrameState * state, double x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));
  g_return_if_fail (x >= 0);

  if (state->minor_rule_thickness != x) {
    state->minor_rule_thickness = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_show_micro_rules (GuppiFrameState * state, gboolean x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->show_micro_rules != x) {
    state->show_micro_rules = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_micro_rule_color (GuppiFrameState * state,
					guint32 color)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->micro_rule_color != color) {
    state->micro_rule_color = color;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_micro_rule_thickness (GuppiFrameState * state, double x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));
  g_return_if_fail (x >= 0);

  if (state->micro_rule_thickness != x) {
    state->micro_rule_thickness = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_frame_north (GuppiFrameState * state, gboolean x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (guppi_frame_state_frame_north (state) != x) {
    if (x)
      state->frame_flags |= GUPPI_NORTH;
    else
      state->frame_flags &= ~GUPPI_NORTH;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_frame_south (GuppiFrameState * state, gboolean x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (guppi_frame_state_frame_south (state) != x) {
    if (x)
      state->frame_flags |= GUPPI_SOUTH;
    else
      state->frame_flags &= ~GUPPI_SOUTH;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_frame_east (GuppiFrameState * state, gboolean x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (guppi_frame_state_frame_east (state) != x) {
    if (x)
      state->frame_flags |= GUPPI_EAST;
    else
      state->frame_flags &= ~GUPPI_EAST;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_frame_west (GuppiFrameState * state, gboolean x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (guppi_frame_state_frame_west (state) != x) {
    if (x)
      state->frame_flags |= GUPPI_WEST;
    else
      state->frame_flags &= ~GUPPI_WEST;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_frame_color (GuppiFrameState * state, guint32 x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));

  if (state->frame_color != x) {
    state->frame_color = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_frame_state_set_frame_thickness (GuppiFrameState * state, double x)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_FRAME_STATE (state));
  g_return_if_fail (x >= 0);

  if (state->frame_thickness != x) {
    state->frame_thickness = x;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}








/* $Id: guppi-frame-state.c,v 1.8 2001/01/16 23:36:01 trow Exp $ */
