/* This is -*- C -*- */
/* $Id: guppi-group-view.h,v 1.8 2001/01/16 23:36:26 trow Exp $ */

/*
 * guppi-group-view.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_GROUP_VIEW_H
#define _INC_GUPPI_GROUP_VIEW_H

/* #include <gnome.h> */
#include "guppi-element-view.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

typedef struct _GuppiGroupView GuppiGroupView;
typedef struct _GuppiGroupViewClass GuppiGroupViewClass;

struct _GuppiGroupView {
  GuppiElementView parent;
  gpointer opaque_internals;
};

struct _GuppiGroupViewClass {
  GuppiElementViewClass parent_class;

  void (*add_hook) (GuppiGroupView *, GuppiElementView *);
};

#define GUPPI_TYPE_GROUP_VIEW (guppi_group_view_get_type())
#define GUPPI_GROUP_VIEW(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_GROUP_VIEW,GuppiGroupView))
#define GUPPI_GROUP_VIEW0(obj) ((obj) ? (GUPPI_GROUP_VIEW(obj)) : NULL)
#define GUPPI_GROUP_VIEW_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_GROUP_VIEW,GuppiGroupViewClass))
#define GUPPI_IS_GROUP_VIEW(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_GROUP_VIEW))
#define GUPPI_IS_GROUP_VIEW0(obj) (((obj) == NULL) || (GUPPI_IS_GROUP_VIEW(obj)))
#define GUPPI_IS_GROUP_VIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_GROUP_VIEW))

GtkType guppi_group_view_get_type (void);


/* Element manipulation functions */

gboolean guppi_group_view_has (GuppiGroupView *, GuppiElementView *);

void guppi_group_view_add (GuppiGroupView *, GuppiElementView *);

void guppi_group_view_remove (GuppiGroupView *, GuppiElementView *);

void guppi_group_view_replace (GuppiGroupView * grp,
			       GuppiElementView * old,
			       GuppiElementView * nuevo);

void guppi_group_view_foreach (GuppiGroupView * grp,
			       void (*)(GuppiElementView *, gpointer),
			       gpointer);

/* Iterate across all of the items in the uncommitted "changed version"
   of the group. */
void guppi_group_view_foreach_pending (GuppiGroupView * grp,
				       void (*)(GuppiElementView *, gpointer),
				       gpointer);

void guppi_group_view_commit_changes (GuppiGroupView * grp);

/* Commit all changes to this group, and also commit the changes in
   all subgroups. */
void guppi_group_view_commit_all_changes (GuppiGroupView * grp);


/* Some functions for doing layouts */

void guppi_group_view_layout_natural_width (GuppiGroupView * grp,
					    GuppiElementView * v);

void guppi_group_view_layout_natural_height (GuppiGroupView * grp,
					     GuppiElementView * v);

void guppi_group_view_layout_left_edge_relative (GuppiGroupView * grp,
						 GuppiElementView * v,
						 double perc);

void guppi_group_view_layout_right_edge_relative (GuppiGroupView * grp,
						  GuppiElementView * v,
						  double perc);

void guppi_group_view_layout_top_edge_relative (GuppiGroupView * grp,
						GuppiElementView * v,
						double perc);

void guppi_group_view_layout_bottom_edge_relative (GuppiGroupView * grp,
						   GuppiElementView * v,
						   double perc);

void guppi_group_view_layout_flush_left (GuppiGroupView * grp,
					 GuppiElementView * v, double margin);

void guppi_group_view_layout_flush_right (GuppiGroupView * grp,
					  GuppiElementView * v,
					  double margin);

void guppi_group_view_layout_flush_top (GuppiGroupView * grp,
					GuppiElementView * v, double margin);

void guppi_group_view_layout_flush_bottom (GuppiGroupView * grp,
					   GuppiElementView * v,
					   double margin);

void guppi_group_view_layout_width_relative (GuppiGroupView * grp,
					     GuppiElementView * v,
					     double perc);

void guppi_group_view_layout_height_relative (GuppiGroupView * grp,
					      GuppiElementView * v,
					      double perc);

void guppi_group_view_layout_center_horizontally (GuppiGroupView * grp,
						  GuppiElementView * v);

void guppi_group_view_layout_center_vertically (GuppiGroupView * grp,
						GuppiElementView * v);

void guppi_group_view_layout_horizontal_fill (GuppiGroupView * grp,
					      GuppiElementView * v,
					      double lm, double rm);

void guppi_group_view_layout_vertical_fill (GuppiGroupView * grp,
					    GuppiElementView * v,
					    double lm, double rm);

void guppi_group_view_layout_aligned_left_edge (GuppiGroupView * grp,
						GuppiElementView * v1,
						GuppiElementView * v2);

void guppi_group_view_layout_aligned_right_edge (GuppiGroupView * grp,
						 GuppiElementView * v1,
						 GuppiElementView * v2);

void guppi_group_view_layout_aligned_top_edge (GuppiGroupView * grp,
					       GuppiElementView * v1,
					       GuppiElementView * v2);

void guppi_group_view_layout_aligned_bottom_edge (GuppiGroupView * grp,
						  GuppiElementView * v1,
						  GuppiElementView * v2);

void guppi_group_view_layout_horizontally_adjacent (GuppiGroupView * grp,
						    GuppiElementView * v1,
						    GuppiElementView * v2,
						    double gap);

void guppi_group_view_layout_vertically_adjacent (GuppiGroupView * grp,
						  GuppiElementView * v1,
						  GuppiElementView * v2,
						  double gap);

void guppi_group_view_layout_hbox2 (GuppiGroupView * grp,
				    GuppiElementView * v1,
				    GuppiElementView * v2, double gap);

void guppi_group_view_layout_hbox3 (GuppiGroupView * grp,
				    GuppiElementView * v1,
				    GuppiElementView * v2,
				    GuppiElementView * v3, double gap);

void guppi_group_view_layout_vbox2 (GuppiGroupView * grp,
				    GuppiElementView * v1,
				    GuppiElementView * v2, double gap);

void guppi_group_view_layout_vbox3 (GuppiGroupView * grp,
				    GuppiElementView * v1,
				    GuppiElementView * v2,
				    GuppiElementView * v3, double gap);

void guppi_group_view_layout_width_ratio (GuppiGroupView * grp,
					  GuppiElementView * v1,
					  GuppiElementView * v2, double x);

void guppi_group_view_layout_height_ratio (GuppiGroupView * grp,
					   GuppiElementView * v1,
					   GuppiElementView * v2, double x);

void guppi_group_view_layout_aspect_ratio (GuppiGroupView * grp,
					   GuppiElementView * v, double x);

void guppi_group_view_layout_same_width (GuppiGroupView * grp,
					 GuppiElementView * v1,
					 GuppiElementView * v2);

void guppi_group_view_layout_same_height (GuppiGroupView * grp,
					  GuppiElementView * v1,
					  GuppiElementView * v2);

void guppi_group_view_layout_width_equals_height (GuppiGroupView * grp,
						  GuppiElementView * v1,
						  GuppiElementView * v2);

void guppi_group_view_layout_same_size (GuppiGroupView * grp,
					GuppiElementView * v1,
					GuppiElementView * v2);

void guppi_group_view_layout_same_place (GuppiGroupView * grp,
					 GuppiElementView * v1,
					 GuppiElementView * v2);

void guppi_group_view_layout_same_x_center (GuppiGroupView * grp,
					    GuppiElementView * v1,
					    GuppiElementView * v2);

void guppi_group_view_layout_same_y_center (GuppiGroupView * grp,
					    GuppiElementView * v1,
					    GuppiElementView * v2);



END_GUPPI_DECLS

#endif /* _INC_GUPPI_GROUP_VIEW_H */

/* $Id: guppi-group-view.h,v 1.8 2001/01/16 23:36:26 trow Exp $ */
