/* $Id: guppi-root-group-tools.c,v 1.4 2001/01/16 23:36:34 trow Exp $ */

/*
 * guppi-root-group-tools.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>

#include <gdk/gdkkeysyms.h>

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>
#include <libgnome/gnome-i18n.h>

#include "guppi-root-group-view.h"
#include "guppi-root-group-item.h"
#include "guppi-root-group-tools.h"
#include "guppi-plot-toolhelp.h"

static void
show_configure_cb (GuppiPlotTool * tool, GuppiCanvasItem * item)
{
  GuppiElementView *view = guppi_canvas_item_view (item);

  guppi_root_group_view_show_configure_window (GUPPI_ROOT_GROUP_VIEW (view));
}

GuppiPlotTool *
guppi_root_group_tool_new_show_configure (void)
{
  GuppiPlotTool *tool;

  tool = guppi_plot_tool_new ();
  guppi_plot_tool_set_name (tool, _("Show Configure Window"));

  tool->supported_type = GUPPI_TYPE_ROOT_GROUP_ITEM;
  tool->first = show_configure_cb;

  return tool;
}

/****************************************************************************/

static void
config_cb (GtkWidget * w, GuppiRootGroupView * view)
{
  GuppiConfigure *conf = guppi_root_group_view_configurer (view);
  gconstpointer tag = gtk_object_get_data (GTK_OBJECT (w), "tag");

  guppi_root_group_view_show_configure_window (view);
  guppi_configure_select_by_tag (conf, tag);
}

static void
select_config_iter_fn (GuppiCanvasItem * item, gpointer ptr)
{
  GuppiCanvasItem *root_item = GUPPI_CANVAS_ITEM (ptr);
  GuppiElementView *root_view = guppi_canvas_item_view (root_item);
  GuppiElementState *state = guppi_canvas_item_state (item);
  GuppiConfigure *conf =
    guppi_root_group_view_configurer (GUPPI_ROOT_GROUP_VIEW (root_view));

  GtkMenu *menu = GTK_MENU (gtk_object_get_data (GTK_OBJECT (ptr), "menu"));
  GtkWidget *mi;

  gconstpointer tag = NULL;

  if (guppi_configure_contains_tag (conf, guppi_canvas_item_view (item)))
    tag = guppi_canvas_item_view (item);
  else
    if (guppi_configure_contains_tag (conf, guppi_canvas_item_state (item)))
      tag = guppi_canvas_item_state (item);

  if (tag == NULL)
    return;

  mi = gtk_menu_item_new_with_label (guppi_element_state_label (state));

  gtk_object_set_data (GTK_OBJECT (mi), "tag", (gpointer) tag);

  gtk_signal_connect (GTK_OBJECT (mi),
		      "activate", GTK_SIGNAL_FUNC (config_cb), root_view);

  gtk_widget_show (mi);

  gtk_menu_append (menu, mi);
}

static void
select_and_configure_cb (GuppiPlotTool * tool, GuppiCanvasItem * item)
{
  GuppiElementView *view = guppi_canvas_item_view (item);
  GtkWidget *menu;
  double pt_x, pt_y;

  menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (item), "menu", menu);

  guppi_canvas_item_c2pt (item, tool->raw_x, tool->raw_y, &pt_x, &pt_y);
  guppi_canvas_item_foreach_at (item, pt_x, pt_y, select_config_iter_fn,
				item);

  if (GTK_MENU_SHELL (menu)->children == NULL) {
    gtk_widget_destroy (menu);
    return;
  }

  gtk_widget_show (menu);

  gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
		  tool->button, GDK_CURRENT_TIME);
}

GuppiPlotTool *
guppi_root_group_tool_new_select_and_configure (void)
{
  GuppiPlotTool *tool;

  tool = guppi_plot_tool_new ();
  guppi_plot_tool_set_name (tool, _("Configure Menu"));

  tool->supported_type = GUPPI_TYPE_ROOT_GROUP_ITEM;
  tool->first = select_and_configure_cb;

  return tool;
}

/****************************************************************************/

static void
start_help_cb (GuppiPlotTool * tool, GuppiCanvasItem * item)
{
  GtkWidget *win;
  GtkWidget *frame;
  GtkWidget *help;

  help = guppi_plot_toolhelp_new (item, tool->pt_x, tool->pt_y);
  if (help == NULL)
    return;

  win = gtk_window_new (GTK_WINDOW_POPUP);
  frame = gtk_frame_new (NULL);

  gtk_container_add (GTK_CONTAINER (win), frame);
  gtk_container_add (GTK_CONTAINER (frame), help);
  gtk_window_set_position (GTK_WINDOW (win), GTK_WIN_POS_MOUSE);

  gtk_widget_show_all (win);
  tool->ptr_arg1 = win;
}

static void
end_help_cb (GuppiPlotTool * tool, GuppiCanvasItem * item)
{
  if (tool->ptr_arg1)
    gtk_widget_destroy (GTK_WIDGET (tool->ptr_arg1));
  tool->ptr_arg1 = NULL;
}

GuppiPlotTool *
guppi_root_group_tool_new_help (void)
{
  GuppiPlotTool *tool;

  tool = guppi_plot_tool_new ();
  guppi_plot_tool_set_name (tool, _("Pop-up Help"));

  tool->supported_type = GUPPI_TYPE_ROOT_GROUP_ITEM;
  tool->first = start_help_cb;
  tool->last = end_help_cb;

  return tool;
}

/****************************************************************************/

GuppiPlotToolkit *
guppi_root_group_toolkit_configure (void)
{
  GuppiPlotToolkit *tk;

  tk = guppi_plot_toolkit_new (_("Configure"));

  guppi_plot_toolkit_set_key_tool (tk, GDK_F1, 0,
				   guppi_root_group_tool_new_show_configure
				   ());

  guppi_plot_toolkit_set_button_tool (tk, 3, GDK_CONTROL_MASK,
				      guppi_root_group_tool_new_select_and_configure
				      ());

  guppi_plot_toolkit_set_key_tool (tk, GDK_question, GDK_SHIFT_MASK,
				   guppi_root_group_tool_new_help ());

  return tk;
}



/* $Id: guppi-root-group-tools.c,v 1.4 2001/01/16 23:36:34 trow Exp $ */
