/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-context-xml.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CONTEXT_XML_H
#define _INC_GUPPI_CONTEXT_XML_H

#include <glib.h>
#include <guppi-defs.h>

#ifndef CHAR
#define CHAR guchar
#endif

BEGIN_GUPPI_DECLS

typedef struct _GuppiContextXML GuppiContextXML;
typedef struct _GuppiContextXMLClass GuppiContextXMLClass;

typedef void (*xml_begin_context_fn) (gpointer user_data,
				      gpointer outer_context_data);
typedef void (*xml_end_context_fn) (gpointer user_data,
				    gpointer outer_context_data);
typedef void (*xml_char_fn) (const CHAR *, gint, gpointer);
typedef GuppiContextXML *(*xml_begin_element_fn) (const CHAR *, const CHAR **,
						  gpointer);
typedef void (*xml_end_element_fn) (const CHAR *, gpointer);

struct _GuppiContextXML {
  GtkObject parent;

  gpointer user_data;
  gboolean please_free_data, please_unref_data;
  void (*please_call_this_destroy_fn)(gpointer);

  xml_begin_context_fn begin_context;
  xml_end_context_fn end_context;
  xml_char_fn characters;
  xml_begin_element_fn begin_element;
  xml_end_element_fn end_element;

  gboolean strip_characters;

  GHashTable *element_contexts;
  GHashTable *element_begin_fns;
  GHashTable *element_end_fns;
};

struct _GuppiContextXMLClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_CONTEXT_XML (guppi_context_xml_get_type ())
#define GUPPI_CONTEXT_XML(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_CONTEXT_XML,GuppiContextXML))
#define GUPPI_CONTEXT_XML0(obj) ((obj) ? (GUPPI_CONTEXT_XML(obj)) : NULL)
#define GUPPI_CONTEXT_XML_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_CONTEXT_XML,GuppiContextXMLClass))
#define GUPPI_IS_CONTEXT_XML(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_CONTEXT_XML))
#define GUPPI_IS_CONTEXT_XML0(obj) (((obj) == NULL) || (GUPPI_IS_CONTEXT_XML(obj)))
#define GUPPI_IS_CONTEXT_XML_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_CONTEXT_XML))

GtkType guppi_context_xml_get_type (void);

GuppiContextXML *guppi_context_xml_new (void);

void guppi_context_xml_set_user_data (GuppiContextXML *, gpointer);
void guppi_context_xml_set_user_data_free (GuppiContextXML *, gpointer);
void guppi_context_xml_set_user_data_unref (GuppiContextXML *, gpointer);
void guppi_context_xml_set_user_data_destroy_fn (GuppiContextXML *
						 , gpointer,
						 void (*)(gpointer));

void guppi_context_xml_set_begin_context_fn (GuppiContextXML *, 
					   xml_begin_context_fn);
void guppi_context_xml_set_end_context_fn (GuppiContextXML *,
					   xml_end_context_fn);

void guppi_context_xml_set_characters_fn (GuppiContextXML *, xml_char_fn);
void guppi_context_xml_set_begin_element_fn (GuppiContextXML *,
					     xml_begin_element_fn);
void guppi_context_xml_set_end_element_fn (GuppiContextXML *, 
					   xml_end_element_fn);

void guppi_context_xml_add_begin_element_fn (GuppiContextXML *,
					     const CHAR *,
					     xml_begin_element_fn);
void guppi_context_xml_add_end_element_fn (GuppiContextXML *,
					   const CHAR *,
					   xml_end_element_fn);
void guppi_context_xml_add_element_fns (GuppiContextXML *,
					const CHAR *,
					xml_begin_element_fn,
					xml_end_element_fn);

void guppi_context_xml_add_element_context (GuppiContextXML *,
					    const CHAR *,
					    GuppiContextXML *new_context);

/** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** **/

void guppi_context_xml_process_begin_context (GuppiContextXML *,
					      GuppiContextXML *);
void guppi_context_xml_process_end_context (GuppiContextXML *,
					    GuppiContextXML *);
void guppi_context_xml_process_characters (GuppiContextXML *, 
					   const CHAR *, gint);
GuppiContextXML *guppi_context_xml_process_begin_element (GuppiContextXML *,
							  const CHAR *,
							  const CHAR **);
void guppi_context_xml_process_end_element (GuppiContextXML *, const CHAR *);


/** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** **/


void guppi_context_xml_warning (GuppiContextXML *, const gchar *fmt, ...);

void guppi_context_xml_error (GuppiContextXML *, const gchar *fmt, ...);


/** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** **/


gint guppi_context_xml_parse (GuppiContextXML *root_context, 
			      const gchar *filename);

gint guppi_context_xml_parse_memory (GuppiContextXML *root_context,
				     gpointer, gint size_in_bytes);


GuppiContextXML *guppi_context_xml_debug (void);
				

END_GUPPI_DECLS

#endif /* _INC_GUPPI_CONTEXT_XML_H */

/* $Id: guppi-context-xml.h,v 1.5 2001/02/04 05:37:57 trow Exp $ */
