/* This is -*- C -*- */
/* $Id: guppi-scatter-view.c,v 1.13 2001/05/06 08:26:28 trow Exp $ */

/*
 * guppi-scatter-view.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-convenient.h>
#include <guppi-debug.h>
#include "guppi-scatter-state.h"
#include "guppi-scatter-view.h"
#include "guppi-scatter-print.h"
#include "guppi-scatter-item.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_scatter_view_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_scatter_view_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_scatter_view_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_scatter_view_finalize (GtkObject * obj)
{
  GuppiScatterView *view = GUPPI_SCATTER_VIEW (obj);

  guppi_unref0 (view->last_x_data);
  guppi_unref0 (view->last_y_data);

  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/**************************************************************************/

static GuppiCanvasItem *
make_canvas_item (GuppiElementView * gev, GnomeCanvas * canvas,
		  GnomeCanvasGroup * group)
{
  GnomeCanvasItem *gci;

  gci = gnome_canvas_item_new (group, GUPPI_TYPE_SCATTER_ITEM, NULL);

  return GUPPI_CANVAS_ITEM (gci);
}

static void
state_changed (GuppiElementView * gev)
{
  GuppiScatterView *view;
  GuppiScatterState *state;
  GuppiSeqScalar *x_data;
  GuppiSeqScalar *y_data;

  view = GUPPI_SCATTER_VIEW (gev);
  state = GUPPI_SCATTER_STATE (guppi_element_view_state (gev));
  x_data = guppi_scatter_state_x_data (state);
  y_data = guppi_scatter_state_y_data (state);

  if (x_data != view->last_x_data) {

    guppi_element_view_set_preferred_x_view (gev);

    guppi_refcounting_assign (view->last_x_data, x_data);
  }

  if (y_data != view->last_y_data) {
    
    guppi_element_view_set_preferred_y_view (gev);

    guppi_refcounting_assign (view->last_y_data, y_data);
  }
}

static void
get_style_bounds (GuppiElementView * view, gint * a, gint * b)
{
  if (a)
    *a = 0;
  if (b)
    *b = GUPPI_SCATTER_STATE_STYLE_COUNT - 1;
}

static GuppiStyle *
get_style (GuppiElementView * view, gint i)
{
  GuppiScatterState *state =
    GUPPI_SCATTER_STATE (guppi_element_view_state (view));

  return GUPPI_STYLE (guppi_scatter_state_get_style (state, i));
}


static void
view_init (GuppiElementView * gev)
{
  GuppiScatterView *view = GUPPI_SCATTER_VIEW (gev);
  GuppiScatterState *state =
    GUPPI_SCATTER_STATE (guppi_element_view_state (gev));

  view->last_x_data = guppi_scatter_state_x_data (state);
  guppi_ref (view->last_x_data);

  view->last_y_data = guppi_scatter_state_y_data (state);
  guppi_ref (view->last_y_data);

}

static gboolean
valid_range (GuppiViewInterval * vi, GuppiSeqScalar * data, double *a,
	     double *b)
{
  gint i, i0, i1;
  double min, max;
  gboolean first_min = TRUE, first_max = TRUE;

  min = guppi_seq_scalar_min (data);
  max = guppi_seq_scalar_max (data);

  if (!(guppi_view_interval_valid (vi, min) &&
	guppi_view_interval_valid (vi, max))) {

    guppi_seq_bounds (GUPPI_SEQ (data), &i0, &i1);

    for (i = i0; i <= i1; ++i) {
      double x = guppi_seq_scalar_get (data, i);
      if (guppi_view_interval_valid (vi, x)) {

	if (first_min) {
	  min = x;
	  first_min = FALSE;
	} else {
	  if (x < min)
	    min = x;
	}

	if (first_max) {
	  max = x;
	  first_max = FALSE;
	} else {
	  if (x > max)
	    max = x;
	}

      }
    }

    if (first_min || first_max)
      return FALSE;
  }


  if (a)
    *a = min;

  if (b)
    *b = max;

  return TRUE;
}

static gboolean
preferred_x_range (GuppiElementView * view, double *a, double *b)
{
  GuppiScatterState *state =
    GUPPI_SCATTER_STATE (guppi_element_view_state (view));
  GuppiSeqScalar *data = guppi_scatter_state_x_data (state);

  if (data)
    return valid_range (guppi_element_view_x_view_interval (view), data, a,
			b);

  return FALSE;
}

static gboolean
preferred_y_range (GuppiElementView * view, double *a, double *b)
{
  GuppiScatterState *state =
    GUPPI_SCATTER_STATE (guppi_element_view_state (view));
  GuppiSeqScalar *data = guppi_scatter_state_y_data (state);

  if (data)
    return valid_range (guppi_element_view_y_view_interval (view), data, a,
			b);

  return FALSE;
}

/**************************************************************************/

static void
guppi_scatter_view_class_init (GuppiScatterViewClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiElementViewClass *view_class = GUPPI_ELEMENT_VIEW_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_ELEMENT_VIEW);

  object_class->get_arg = guppi_scatter_view_get_arg;
  object_class->set_arg = guppi_scatter_view_set_arg;
  object_class->destroy = guppi_scatter_view_destroy;
  object_class->finalize = guppi_scatter_view_finalize;

  view_class->make_canvas_item = make_canvas_item;
  view_class->print_type = GUPPI_TYPE_SCATTER_PRINT;
  view_class->state_changed = state_changed;
  view_class->get_style_bounds = get_style_bounds;
  view_class->get_style = get_style;
  view_class->view_init = view_init;

  view_class->preferred_x_range = preferred_x_range;
  view_class->preferred_y_range = preferred_y_range;
}

static void
guppi_scatter_view_init (GuppiScatterView * obj)
{

}

GtkType guppi_scatter_view_get_type (void)
{
  static GtkType guppi_scatter_view_type = 0;
  if (!guppi_scatter_view_type) {
    static const GtkTypeInfo guppi_scatter_view_info = {
      "GuppiScatterView",
      sizeof (GuppiScatterView),
      sizeof (GuppiScatterViewClass),
      (GtkClassInitFunc) guppi_scatter_view_class_init,
      (GtkObjectInitFunc) guppi_scatter_view_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_scatter_view_type =
      gtk_type_unique (GUPPI_TYPE_ELEMENT_VIEW, &guppi_scatter_view_info);
  }
  return guppi_scatter_view_type;
}

/***************************************************************************/

/* $Id: guppi-scatter-view.c,v 1.13 2001/05/06 08:26:28 trow Exp $ */
