/* $Id: init.c,v 1.4 2001/05/06 08:26:31 trow Exp $ */

/*
 * init.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-scripting.h>
#include <guppi-plot-plug-in.h>
#include "guppi-xybox-state.h"
#include "guppi-scm-xybox.h"

#ifdef HAVE_PYTHON
void guppi_python_xybox_init (void);
#endif

GuppiPlugIn *guppi_plug_in (void);

/*************************************************************************/

static GuppiElementState *
make_element (void)
{
  return guppi_xybox_state_new ();
}

GuppiPlugIn *
guppi_plug_in (void)
{
  GuppiPlugIn *pi;
  GuppiPlotPlugIn *ppi;

  pi = guppi_plot_plug_in_new ();
  ppi = GUPPI_PLOT_PLUG_IN (pi);

  pi->magic_number = GUPPI_PLUG_IN_MAGIC_NUMBER;
  ppi->element_constructor = make_element;

  if (guppi_supports_guile ())
    guppi_scm_xybox_init ();
#ifdef HAVE_PYTHON
  if (guppi_supports_python ())
    guppi_python_xybox_init ();
#endif

  /* Do any other necessary initialization here. */

  return pi;
}


/* $Id: init.c,v 1.4 2001/05/06 08:26:31 trow Exp $ */
