/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-gnumeric.c
 *
 * Copyright (C) 2000 Helixcode Inc
 *
 * Developed by Jody Goldberg <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
/* #include <gnome.h> */
#include <glib.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>
#include <guppi-guile.h>
#include <guppi-chart-type.h>
#include <guppi-useful.h>
#include <guppi-plot-init.h>
#include <guppi-data-init.h>
#include <guppi-bonobo.h>
#include <guppi-embeddable.h>
#include <liboaf/liboaf.h>
#include "corba-graph-manager.h"

static BonoboObject *
guppi_chart_selector_factory (BonoboGenericFactory *Factory, void *closure)
{
	BonoboObject *embeddable;
	GraphManager *manager;

	manager = graph_manager_new ();

	embeddable = guppi_bonobo_new ();
	manager->embeddable = GUPPI_BONOBO_EMBEDDABLE (embeddable);

	bonobo_object_add_interface (BONOBO_OBJECT (embeddable),
				     BONOBO_OBJECT (manager));

	guppi_bonobo_embeddable_set_plotter (GUPPI_BONOBO_EMBEDDABLE (embeddable),
					     &guppi_chart_selector_get_plot,
					     &manager->details);

	return embeddable;
}

static void
guppi_chart_selector_factory_init (void)
{
	static BonoboGenericFactory *factory = NULL;

	if (factory != NULL)
		return;

	factory = bonobo_generic_factory_new (
	      "OAFIID:GNOME_Gnumeric_Graph_Manager_Factory",
	      &guppi_chart_selector_factory, NULL);

	if (factory == NULL)
		g_error ("I could not register a GuppiChartSelector factory.");
}

static void
init_server_factory (int argc, char **argv)
{
  CORBA_ORB orb = oaf_init (argc, argv);

  if (bonobo_init (orb, NULL, NULL) == FALSE)
    g_error (_("Bonobo initialization failed."));

  guppi_chart_selector_factory_init ();
}

static void
real_main (void *closure, int argc, char* argv[])
{
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);

  gtk_type_init ();
  gnomelib_register_popt_table(oaf_popt_options, "oaf");

  gnome_init_with_popt_table ("guppi-gnumeric", VERSION,
			      argc, argv,
			      oaf_popt_options, 0, NULL);

  init_server_factory (argc, argv);

  guppi_useful_init ();
  guppi_data_init ();
  guppi_plot_init ();
  guppi_plug_in_spec_find_all ();

  bonobo_main ();
}
 
int
main(int argc, char* argv[])
{
 scm_boot_guile (argc, argv, real_main, NULL);

  g_assert_not_reached();
  return 1;
}
