/* This is -*- C -*- */
/* vim: set sw=2: */
/* $Id: guppi-xml.h,v 1.1 2001/05/03 23:02:27 trow Exp $ */

/*
 * guppi-xml.h
 *
 * Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 */

#ifndef __GUPPI_XML_H__
#define __GUPPI_XML_H__

#include <gnome-xml/tree.h>

typedef enum {
  GUPPI_XML_V1
} GuppiXMLVersion;

typedef struct _GuppiXMLDocument GuppiXMLDocument;
struct _GuppiXMLDocument {
  xmlDocPtr  doc;  /* XML Document    */
  xmlNsPtr   ns;   /* Main name space */

  GuppiXMLVersion version;
};

GuppiXMLDocument *guppi_xml_document_new        (void);

GuppiXMLDocument *guppi_xml_document_read_file  (const gchar *filename);
void              guppi_xml_document_write_file (GuppiXMLDocument *, const gchar *filename);

xmlNodePtr        guppi_xml_document_root       (GuppiXMLDocument *);

void              guppi_xml_document_add_node   (GuppiXMLDocument *, xmlNodePtr);

void              guppi_xml_document_free       (GuppiXMLDocument *);
void              guppi_xml_document_spew       (GuppiXMLDocument *);


/* Wrappers around some XML node creation/modification routines. */

xmlNodePtr guppi_xml_new_node       (GuppiXMLDocument *, const gchar *node_name);

xmlNodePtr guppi_xml_new_text_node  (GuppiXMLDocument *, const gchar *node_name, const gchar *node_text);
xmlNodePtr guppi_xml_new_text_nodef (GuppiXMLDocument *, const gchar *node_name, const gchar *node_text_format, ...);

void       guppi_xml_set_property   (xmlNodePtr, const gchar *name, const gchar *value);
void       guppi_xml_set_propertyf  (xmlNodePtr, const gchar *name, const gchar *value_format, ...);

gchar     *guppi_xml_get_property        (xmlNodePtr, const gchar *name);
gint       guppi_xml_get_property_int    (xmlNodePtr, const gchar *name);
double     guppi_xml_get_property_double (xmlNodePtr, const gchar *name);


#endif /* __GUPPI_XML_H__ */

