/* $Id: guppi-data-init.c,v 1.16 2001/05/06 00:07:34 trow Exp $ */

/*
 * guppi-data-init.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-guile.h>
#include "guppi-data-init.h"
#include "guppi-scm-data.h"

#ifdef HAVE_PYTHON
void guppi_python_data_init (void);
#endif

#include "guppi-data-transform.h"

/* Function prototypes for data type initializers. */
GtkType guppi_category_get_type (void);
GtkType guppi_date_series_get_type (void);
GtkType guppi_price_series_get_type (void);
GtkType guppi_seq_boolean_get_type (void);
GtkType guppi_seq_categorical_get_type (void);
GtkType guppi_seq_date_get_type (void);
GtkType guppi_seq_integer_get_type (void);
GtkType guppi_seq_scalar_get_type (void);
GtkType guppi_seq_string_get_type (void);
GtkType guppi_struct_get_type (void);


void
guppi_data_init (void)
{
  static gboolean inited = FALSE;
  g_return_if_fail (!inited);
  inited = TRUE;

  /* Invoke our various data types to make sure that they have been
     created. */
  guppi_category_get_type ();
  guppi_date_series_get_type ();
  guppi_price_series_get_type ();
  guppi_seq_boolean_get_type ();
  guppi_seq_categorical_get_type ();
  guppi_seq_date_get_type ();
  guppi_seq_integer_get_type ();
  guppi_seq_scalar_get_type ();
  guppi_seq_string_get_type ();
  guppi_struct_get_type ();


  /* Register some basic transforms */
  guppi_data_transforms_init ();

  if (guppi_guile_is_active ())
    guppi_scm_data_init ();

#ifdef HAVE_PYTHON
  guppi_python_data_init ();
#endif
}


/* $Id: guppi-data-init.c,v 1.16 2001/05/06 00:07:34 trow Exp $ */
