/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-date-series-core-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_DATE_SERIES_CORE_IMPL_H
#define _INC_GUPPI_DATE_SERIES_CORE_IMPL_H

/* #include <gnome.h> */
#include <guppi-defs.h>
#include <guppi-garray.h>
#include <guppi-date-series-impl.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiDateSeriesCoreImpl GuppiDateSeriesCoreImpl;
typedef struct _GuppiDateSeriesCoreImplClass GuppiDateSeriesCoreImplClass;

struct _GuppiDateSeriesCoreImpl {
  GuppiDateSeriesImpl parent;

  GDate start_date, end_date;
  gsize size;
  GuppiGArray *garray;
};

struct _GuppiDateSeriesCoreImplClass {
  GuppiDateSeriesImplClass parent_class;
};

#define GUPPI_TYPE_DATE_SERIES_CORE_IMPL (guppi_date_series_core_impl_get_type ())
#define GUPPI_DATE_SERIES_CORE_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_DATE_SERIES_CORE_IMPL,GuppiDateSeriesCoreImpl))
#define GUPPI_DATE_SERIES_CORE_IMPL0(obj) ((obj) ? (GUPPI_DATE_SERIES_CORE_IMPL(obj)) : NULL)
#define GUPPI_DATE_SERIES_CORE_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_DATE_SERIES_CORE_IMPL,GuppiDateSeriesCoreImplClass))
#define GUPPI_IS_DATE_SERIES_CORE_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_DATE_SERIES_CORE_IMPL))
#define GUPPI_IS_DATE_SERIES_CORE_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_DATE_SERIES_CORE_IMPL(obj)))
#define GUPPI_IS_DATE_SERIES_CORE_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_DATE_SERIES_CORE_IMPL))

GtkType guppi_date_series_core_impl_get_type (void);

GtkObject *guppi_date_series_core_impl_new (void);



END_GUPPI_DECLS

#endif /* _INC_GUPPI_DATE_SERIES_CORE_IMPL_H */

/* $Id: core.h,v 1.2 2001/01/16 23:35:48 trow Exp $ */
