/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-barchart-register.c
 *
 * Copyright (C) 2000 Helix Code, Inc.
 *
 * Developed by Jody Goldberg <jgoldberg@home.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/* $Id: guppi-XLplots-common.c,v 1.5 2000/12/17 20:35:31 trow Exp $ */

#include <config.h>
#include <guppi-seq-style.h>
#include <guppi-style.h>
#include <guppi-metrics.h>
#include <guppi-memory.h>
#include <guppi-root-group-state.h>
#include "guppi-XLplots-common.h"

GuppiSeqStyle *
xlplots_stock_styles (int const n)
{
  int i;
  GuppiSeqStyle *styles;
  GuppiData* tmp = guppi_seq_style_new ();

  styles = GUPPI_SEQ_STYLE (tmp);
  for (i = 0; i < n ; ++i)
    guppi_seq_style_append (styles, guppi_style_stock_alien(i));

  return styles;
}

GuppiSeqString *
xlplots_stock_labels (int const n)
{
  static GPtrArray* strings = NULL;
  GuppiSeqString *labels;
  int i;

  if (strings == NULL)
    strings = g_ptr_array_new ();

  for (i = strings->len ; i < n ; ) {
    char *str = guppi_strdup_printf ("%d", ++i);
    g_ptr_array_add (strings, str);
  }

  {
    GuppiData* tmp = guppi_seq_string_new ();
    labels = GUPPI_SEQ_STRING (tmp);
  }
  for (i = 0; i < n ; ++i)
    guppi_seq_string_append_nc (labels, g_ptr_array_index (strings, i));

  return labels;
}

GuppiElementState*
xlplots_stock_legend (void)
{
  return guppi_element_state_new("legend",
				 "box_width",  guppi_in2pt(1/8.0),
				 "box_height", guppi_in2pt(1/8.0),

				 /* Ideally this would be 0 for an
				  * un-anti-aliased un scale hair width
				  * line */
				 "box_edge_thickness", .5,

				 "edge_margin", guppi_in2pt(1/16.0),
				 NULL);
}

GuppiRootGroupView *
guppi_unimplemented_plot (void)
{
  GuppiElementState *root_state;
  GuppiGroupView *root_view;
  GuppiElementState *text_state;
  GuppiElementView *text_view;

  root_state = guppi_root_group_state_new ();
  root_view = GUPPI_GROUP_VIEW (guppi_element_state_make_view (root_state));

  text_state = guppi_element_state_new("text",
				       "font_size", 32.0,
				       "text", "Unimplemented",
				       NULL);
  text_view = guppi_element_state_make_view (text_state);

  guppi_group_view_layout_horizontal_fill (root_view, text_view, 7.2, 7.2);
  guppi_group_view_layout_vertical_fill (root_view, text_view, 7.2, 7.2);

  guppi_group_view_commit_all_changes (root_view);

  guppi_root_group_view_set_size (GUPPI_ROOT_GROUP_VIEW (root_view),
				  6*72, 4.5*72);

  return GUPPI_ROOT_GROUP_VIEW (root_view);
}

