/* This is -*- C -*- */
/* $Id: guppi-seq-object-core-impl.c,v 1.8 2001/08/21 02:54:53 trow Exp $ */

/*
 * guppi-seq-object-core-impl.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 * Copyright (C) 2001 The Free Software Foundation
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include "guppi-seq-object-core-impl.h"

/* #include <gnome.h> */

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>
#include <libgnome/gnome-i18n.h>

#include <guppi-convenient.h>
#include <guppi-data-plug-in.h>


static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_seq_object_core_get_arg (GtkObject *obj, GtkArg *arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_object_core_set_arg (GtkObject *obj, GtkArg *arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_object_core_finalize (GtkObject *obj)
{
  GuppiSeqObjectCore *impl = GUPPI_SEQ_OBJECT_CORE (obj);
  GtkObject **data;
  gint i;

  if (impl->garray) {

    data = (GtkObject **) guppi_garray_data (impl->garray);

    for (i = 0; i < impl->size; ++i)
      if (data[i])
	guppi_unref (data[i]);

    guppi_unref (impl->garray);

    impl->garray = NULL;
  }

  if (parent_class->finalize)
    parent_class->finalize (obj);

}

static GtkObject *
v_seq_object_get (GuppiSeqObject *impl, gint i)
{
  GuppiSeqObjectCore *core = GUPPI_SEQ_OBJECT_CORE (impl);
  GtkObject **data;

  data = (GtkObject **) guppi_garray_data (core->garray);
  i -= core->index_basis;
  return data[i];
}

static void
v_seq_object_set (GuppiSeqObject *impl, gint i, GtkObject *obj)
{
  GuppiSeqObjectCore *core = GUPPI_SEQ_OBJECT_CORE (impl);
  GtkObject **data;

  data = (GtkObject **) guppi_garray_data (core->garray);
  i -= core->index_basis;
  data[i] = obj;
}

static void
v_seq_object_insert (GuppiSeqObject *impl, gint i, GtkObject *obj)
{
  GuppiSeqObjectCore *core = GUPPI_SEQ_OBJECT_CORE (impl);
  GtkObject **data;
  gint j;

  i -= core->index_basis;

  if (guppi_garray_size (core->garray) <= core->size)
    guppi_garray_set_size (core->garray, MAX (20, 2 *core->size));

  data = (GtkObject **) guppi_garray_data (core->garray);
  for (j = core->size - 1; i <= j; --j)
    data[j + 1] = data[j];
  data[i] = obj;
  ++core->size;
}

static void
v_seq_object_insert_NULL (GuppiSeqObject *impl, gint i, gsize N)
{
  GuppiSeqObjectCore *core = GUPPI_SEQ_OBJECT_CORE (impl);
  GtkObject **data;
  gint j;

  i -= core->index_basis;

  if (guppi_garray_size (core->garray) < core->size + N)
    guppi_garray_set_size (core->garray,
			   MAX (MAX (20, 2 * core->size),
				core->size + 2 * N));

  data = (GtkObject **) guppi_garray_data (core->garray);

  for (j = core->size - 1; i <= j; --j)
    data[j + N] = data[j];

  for (j = 0; j < N; ++j)
    data[i + j] = NULL;

  core->size += N;
}

static void
v_seq_size_hint (GuppiSeq *impl, gsize n)
{
  GuppiSeqObjectCore *core = GUPPI_SEQ_OBJECT_CORE (impl);

  if (guppi_garray_size (core->garray) < n)
    guppi_garray_set_size (core->garray, n);
}

static void
v_seq_get_bounds (GuppiSeq *impl, gint *min, gint *max)
{
  const GuppiSeqObjectCore *core = GUPPI_SEQ_OBJECT_CORE (impl);

  if (min)
    *min = core->index_basis;

  if (max)
    *max = core->index_basis - 1 + core->size;

}

static void
v_seq_shift_indices (GuppiSeq *impl, gint delta)
{
  GuppiSeqObjectCore *core = GUPPI_SEQ_OBJECT_CORE (impl);
  core->index_basis += delta;
}

static void
v_seq_delete_many (GuppiSeq *impl, gint i, gsize N)
{
  GuppiSeqObjectCore *core = GUPPI_SEQ_OBJECT_CORE (impl);
  GtkObject **data;
  gint j;

  data = (GtkObject **) guppi_garray_data (core->garray);
  i -= core->index_basis;

  for (j = i; j + N < core->size; ++j) {
    if (data[j] != NULL)
      guppi_unref (data[j]);
    data[j] = data[j + N];
  }

  core->size -= N;
}

static void
guppi_seq_object_core_class_init (GuppiSeqObjectCoreClass *klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiDataClass *data_class = GUPPI_DATA_CLASS (klass);
  GuppiSeqClass *seq_class = GUPPI_SEQ_CLASS (klass);
  GuppiSeqObjectClass *seq_obj_class = GUPPI_SEQ_OBJECT_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_SEQ_OBJECT);

  object_class->get_arg = guppi_seq_object_core_get_arg;
  object_class->set_arg = guppi_seq_object_core_set_arg;
  object_class->finalize = guppi_seq_object_core_finalize;

  data_class->is_leaf_type = TRUE;

  seq_obj_class->get = v_seq_object_get;
  seq_obj_class->set = v_seq_object_set;
  seq_obj_class->insert = v_seq_object_insert;
  seq_obj_class->insert_NULL = v_seq_object_insert_NULL;

  seq_class->size_hint = v_seq_size_hint;
  seq_class->get_bounds = v_seq_get_bounds;
  seq_class->shift_indices = v_seq_shift_indices;
  seq_class->delete_many = v_seq_delete_many;
  seq_class->support_missing_values = TRUE;
}

static void
guppi_seq_object_core_init (GuppiSeqObjectCore *obj)
{
  obj->index_basis = 0;
  obj->size = 0;
  obj->garray = guppi_garray_new (sizeof (GtkObject *));
}

GtkType guppi_seq_object_core_get_type (void)
{
  static GtkType guppi_seq_object_core_type = 0;
  if (!guppi_seq_object_core_type) {
    static const GtkTypeInfo guppi_seq_object_core_info = {
      "GuppiSeqObjectCore",
      sizeof (GuppiSeqObjectCore),
      sizeof (GuppiSeqObjectCoreClass),
      (GtkClassInitFunc) guppi_seq_object_core_class_init,
      (GtkObjectInitFunc) guppi_seq_object_core_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_seq_object_core_type =
      gtk_type_unique (GUPPI_TYPE_SEQ_OBJECT,
		       &guppi_seq_object_core_info);
  }
  return guppi_seq_object_core_type;
}

/**************************************************************************/

static GuppiData *
constructor (void)
{
  return GUPPI_DATA (guppi_type_new (guppi_seq_object_core_get_type ()));
}

GuppiPlugIn *guppi_plug_in (void);

GuppiPlugIn *
guppi_plug_in (void)
{
  GuppiPlugIn *pi;

  pi = guppi_data_plug_in_new ();
  pi->magic_number = GUPPI_PLUG_IN_MAGIC_NUMBER;
  GUPPI_DATA_PLUG_IN (pi)->constructor = constructor;

  return pi;
}


/* $Id: guppi-seq-object-core-impl.c,v 1.8 2001/08/21 02:54:53 trow Exp $ */
