/*
    compiler_options.h
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _COMPILER_OPTIONS_H_
#define _COMPILER_OPTIONS_H_

typedef struct _CompilerOptions CompilerOptions;
typedef struct _CompilerOptionsGui CompilerOptionsGui;

struct _CompilerOptionsGui
{
  GtkWidget *window;
  GtkWidget *button[26];
  GtkWidget *inc_clist;
  GtkWidget *inc_entry;
  GtkWidget *inc_add_b;
  GtkWidget *inc_update_b;
  GtkWidget *inc_remove_b;
  GtkWidget *inc_clear_b;

  GtkWidget *lib_paths_clist;
  GtkWidget *lib_paths_entry;
  GtkWidget *lib_paths_add_b;
  GtkWidget *lib_paths_update_b;
  GtkWidget *lib_paths_remove_b;
  GtkWidget *lib_paths_clear_b;

  GtkWidget *lib_clist;
  GtkWidget *lib_stock_clist;
  GtkWidget *lib_entry;
  GtkWidget *lib_add_b;
  GtkWidget *lib_update_b;
  GtkWidget *lib_remove_b;
  GtkWidget *lib_clear_b;

  GtkWidget *def_clist;
  GtkWidget *def_entry;
  GtkWidget *def_add_b;
  GtkWidget *def_update_b;
  GtkWidget *def_remove_b;
  GtkWidget *def_clear_b;
  GtkWidget *other_options_entry;
};

struct _CompilerOptions
{
  CompilerOptionsGui     widgets;
  gint             inc_index;
  gint             lib_index;
  gint             lib_paths_index;
  gint             def_index;
  gboolean     button_state[26];
  gchar*        other_options;
  
  gboolean             is_showing;
  gint                     win_pos_x, win_pos_y;
};  

void create_compiler_options_gui(CompilerOptions*);
CompilerOptions*  compiler_options_new(void);
void compiler_options_destroy(CompilerOptions*);
void compiler_options_get(CompilerOptions*);
void compiler_options_show(CompilerOptions*);
void compiler_options_hide(CompilerOptions*);
gboolean compiler_options_save(CompilerOptions* co, FILE* s);
gboolean compiler_options_load(CompilerOptions* co, FILE* s);
gboolean compiler_options_save_yourself(CompilerOptions* co, FILE* s);
gboolean compiler_options_load_yourself(CompilerOptions* co, FILE* s);
void compiler_options_update_controls(CompilerOptions*);
gchar*
compiler_options_get_c_compile_command(CompilerOptions* co);

gchar*
compiler_options_get_cpp_compile_command(CompilerOptions* co);

gchar*
compiler_options_get_c_build_command(CompilerOptions* co);

gchar*
compiler_options_get_cpp_build_command(CompilerOptions* co);

gchar*
compiler_options_get_build_command(CompilerOptions* co);

gchar*
compiler_options_get_cflags(CompilerOptions* co);

gchar*
compiler_options_get_include_paths(CompilerOptions* co);

gchar*
compiler_options_get_library_paths(CompilerOptions* co);

gchar*
compiler_options_get_libraries(CompilerOptions* co);

gchar*
compiler_options_get_defines(CompilerOptions* co);

/**********************************************
 * compiling = TRUE for only compiling
 * otherwise, with linking: compiling = FALSE.
 **********************************************/
gchar*
compiler_options_get_all_flags(CompilerOptions* co, gboolean compiling);

#endif
