/*
 * configurer.c Copyright (C) 2000  Kh. Naba Kumar Singh
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59 
 * Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <time.h>

#include <gnome.h>

#include "anjuta.h"
#include "text_editor.h"
#include "messagebox.h"
#include "utilities.h"
#include "launcher.h"
#include "configurer.h"
#include "support.h"

Configurer*
configurer_new(void)
{
   Configurer* c = malloc(sizeof(Configurer));
    if(c)
    {
         c->args_history = NULL;
         c->args = NULL;
         c->overwrite = FALSE;
     }
     return c;
}

void
configurer_destroy(Configurer* c)
{
    gint i;
    if(c)
    {
         for(i=0;i<g_list_length(c->args_history);i++)
                        g_free(g_list_nth_data(c->args_history,i));
         g_list_free(c->args_history);
         g_free(c);
     }
}

void
configurer_show(Configurer* c)
{
  gtk_widget_show(create_configurer_dialog(c));
}

GtkWidget*
create_configurer_dialog (Configurer* c)
{
  GtkWidget *dialog2;
  GtkWidget *dialog_vbox2;
  GtkWidget *frame2;
  GtkWidget *vbox2;
  GtkWidget *frame3;
  GtkWidget *combo2;
  GtkWidget *combo_entry2;
  GtkWidget *dialog_action_area2;
  GtkWidget *button4;
  GtkWidget *button6;

  dialog2 = gnome_dialog_new (_("Configure"), NULL);
  gtk_widget_set_usize (dialog2, 332, -2);
  gtk_window_set_position (GTK_WINDOW (dialog2), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (dialog2), FALSE, FALSE, FALSE);
  gnome_dialog_set_close (GNOME_DIALOG (dialog2), TRUE);

  dialog_vbox2 = GNOME_DIALOG (dialog2)->vbox;
  gtk_widget_show (dialog_vbox2);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), frame2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 5);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame2), vbox2);

  frame3 = gtk_frame_new (_("Configure Options (if any)"));
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (vbox2), frame3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame3), 5);

  combo2 = gtk_combo_new ();
  if(c->args_history)
	gtk_combo_set_popdown_strings(GTK_COMBO(combo2), c->args_history);
  gtk_widget_show (combo2);
  gtk_container_add (GTK_CONTAINER (frame3), combo2);
  gtk_container_set_border_width (GTK_CONTAINER (combo2), 5);

  combo_entry2 = GTK_COMBO (combo2)->entry;
  gtk_widget_show (combo_entry2);

  dialog_action_area2 = GNOME_DIALOG (dialog2)->action_area;
  gtk_widget_show (dialog_action_area2);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_EDGE);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area2), 8);

  gnome_dialog_append_button (GNOME_DIALOG (dialog2), GNOME_STOCK_BUTTON_OK);
  button4 = g_list_last (GNOME_DIALOG (dialog2)->buttons)->data;
  gtk_widget_show (button4);
  GTK_WIDGET_SET_FLAGS (button4, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (dialog2), GNOME_STOCK_BUTTON_CANCEL);
  button6 = g_list_last (GNOME_DIALOG (dialog2)->buttons)->data;
  gtk_widget_show (button6);
  GTK_WIDGET_UNSET_FLAGS (button6, GTK_CAN_FOCUS);
  GTK_WIDGET_SET_FLAGS (button6, GTK_CAN_DEFAULT);

  gtk_accel_group_attach( app->accel_group, GTK_OBJECT(dialog2));

  gtk_signal_connect (GTK_OBJECT (combo_entry2), "changed",
                      GTK_SIGNAL_FUNC (on_configurer_entry_changed),
                      c);
  gtk_signal_connect (GTK_OBJECT (button4), "clicked",
                      GTK_SIGNAL_FUNC (on_configurer_ok_clicked),
                      c);

  return dialog2;
}

void
on_configurer_entry_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
   Configurer* c = user_data;
   if(c->args) g_free(c->args);
   c->args = g_strdup(gtk_entry_get_text(GTK_ENTRY(editable)));
}

void
on_configurer_ok_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  Configurer* cof;
  gchar* tmp;
  cof = user_data;

  chdir(app->project_dbase->top_proj_dir);

  if(app->project_dbase->project_is_open)
  {
     chdir(app->project_dbase->top_proj_dir);
     if(file_is_executable("./configure") == FALSE)
     {
        anjuta_error(_("Project does not have executable configure script.\n"
                           "You need to autogen the project first."));
        return;
     }
     if(cof->args)
     {
	tmp = g_strconcat("./configure ", cof->args, NULL);
	cof->args_history =
	    update_string_list(cof->args_history, cof->args, app->preferences->max_recent_files);
     }
     else tmp = g_strdup("./configure ");
     if(launcher_execute(tmp,
                                       conf_mesg_arrived,
                                       conf_mesg_arrived,
                                       conf_terminated) == FALSE){g_free(tmp); return;}
     g_free(tmp);
     messages_clear(app->messages, MESSAGE_BUILD);
     messages_append(app->messages, _("Configuring the project ....\n"), MESSAGE_BUILD);
     messages_show(app->messages, MESSAGE_BUILD);
   }
}

void
conf_mesg_arrived(gchar *mesg)
{
   messages_append(app->messages, mesg, MESSAGE_BUILD);
}

void
conf_terminated(int status, time_t time)
{
    gchar  *buff1;
    
    if(WEXITSTATUS(status))
    {
       messages_append(app->messages, _("Configure completed...............Unsuccessful\n"), MESSAGE_BUILD);
       anjuta_warning(_("Configure completed ... unsuccessful"));
    }
    else
    {
       messages_append(app->messages, _("Configure completed...............Successful\n"), MESSAGE_BUILD);
       anjuta_status(_("Configure completed ... successful"));
    }
    buff1 = g_strdup_printf(_("Total time taken: %d secs\n"), (gint)time);
    messages_append(app->messages, buff1, MESSAGE_BUILD);
    gdk_beep();
    g_free(buff1);
}
